/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import com.ibm.icu.text.BreakIterator;
import java.text.CharacterIterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;

public class JavadocDoubleClickStrategy
implements ITextDoubleClickStrategy {
    private DocumentCharacterIterator fDocIter = new DocumentCharacterIterator();

    public void doubleClicked(ITextViewer iTextViewer) {
        int n = iTextViewer.getSelectedRange().x;
        if (n < 0) {
            return;
        }
        IRegion iRegion = this.getWordRegion(iTextViewer.getDocument(), n);
        if (iRegion != null) {
            iTextViewer.setSelectedRange(iRegion.getOffset(), iRegion.getLength());
        }
    }

    private IRegion getWordRegion(IDocument iDocument, int n) {
        int n2;
        int n3;
        block13: {
            IRegion iRegion;
            block12: {
                try {
                    iRegion = iDocument.getLineInformationOfOffset(n);
                    if (n != iRegion.getOffset() + iRegion.getLength()) break block12;
                    return null;
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
            this.fDocIter.setDocument(iDocument, iRegion);
            BreakIterator breakIterator = BreakIterator.getWordInstance();
            breakIterator.setText((CharacterIterator)this.fDocIter);
            n3 = breakIterator.preceding(n);
            if (n3 == -1) {
                n3 = iRegion.getOffset();
            }
            if ((n2 = breakIterator.following(n)) == -1) {
                n2 = iRegion.getOffset() + iRegion.getLength();
            }
            if (breakIterator.isBoundary(n)) {
                if (n2 - n > n - n3) {
                    n3 = n;
                } else {
                    n2 = n;
                }
            }
            if (n3 > 0 && iDocument.getChar(n3 - 1) == '@' && Character.isJavaIdentifierPart(iDocument.getChar(n3)) && (n3 == 1 || Character.isWhitespace(iDocument.getChar(n3 - 2)) || iDocument.getChar(n3 - 2) == '{')) {
                --n3;
            } else if (n2 == n && n2 == n3 + 1 && n2 < iRegion.getOffset() + iRegion.getLength() && iDocument.getChar(n2) == '@') {
                return this.getWordRegion(iDocument, n + 1);
            }
            if (n3 != n2) break block13;
            return null;
        }
        return new Region(n3, n2 - n3);
    }

    static class DocumentCharacterIterator
    implements CharacterIterator {
        private IDocument fDocument;
        private int fOffset = -1;
        private int fEndOffset = -1;
        private int fIndex = -1;

        public void setDocument(IDocument iDocument, IRegion iRegion) {
            this.fDocument = iDocument;
            this.fOffset = iRegion.getOffset();
            this.fEndOffset = this.fOffset + iRegion.getLength();
        }

        public char first() {
            this.fIndex = this.fOffset;
            return this.current();
        }

        public char last() {
            this.fIndex = this.fOffset < this.fEndOffset ? this.fEndOffset - 1 : this.fEndOffset;
            return this.current();
        }

        public char current() {
            if (this.fOffset <= this.fIndex && this.fIndex < this.fEndOffset) {
                try {
                    return this.fDocument.getChar(this.fIndex);
                }
                catch (BadLocationException badLocationException) {}
            }
            return '\uffff';
        }

        public char next() {
            ++this.fIndex;
            int n = this.getEndIndex();
            if (this.fIndex >= n) {
                this.fIndex = n;
                return '\uffff';
            }
            return this.current();
        }

        public char previous() {
            if (this.fIndex == this.fOffset) {
                return '\uffff';
            }
            if (this.fIndex > this.fOffset) {
                --this.fIndex;
            }
            return this.current();
        }

        public char setIndex(int n) {
            this.fIndex = n;
            return this.current();
        }

        public int getBeginIndex() {
            return this.fOffset;
        }

        public int getEndIndex() {
            return this.fEndOffset;
        }

        public int getIndex() {
            return this.fIndex;
        }

        public Object clone() {
            DocumentCharacterIterator documentCharacterIterator = new DocumentCharacterIterator();
            documentCharacterIterator.fDocument = this.fDocument;
            documentCharacterIterator.fIndex = this.fIndex;
            documentCharacterIterator.fOffset = this.fOffset;
            documentCharacterIterator.fEndOffset = this.fEndOffset;
            return documentCharacterIterator;
        }
    }
}

