/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.PositionBasedCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.util.StringMatcher;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.JavaElementImageDescriptor;

public class ParameterGuesser {
    private static final char[] NO_TRIGGERS = new char[0];
    private static final char[] VOID = "void".toCharArray();
    private static final char[] HASHCODE = "hashCode()".toCharArray();
    private static final char[] TOSTRING = "toString()".toCharArray();
    private static final char[] CLONE = "clone()".toCharArray();
    private static final Map PRIMITIVE_ASSIGNMENTS;
    private static final Map AUTOUNBOX;
    private final ICompilationUnit fCompilationUnit;
    private final int fCodeAssistOffset;
    private List fVariables;
    private ImageDescriptorRegistry fRegistry = JavaPlugin.getImageDescriptorRegistry();
    private boolean fAllowAutoBoxing;

    static {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        hashMap.put("boolean", Collections.singleton("boolean"));
        hashMap.put("byte", Collections.singleton("byte"));
        hashMap.put("short", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("short", "byte"))));
        hashMap.put("char", Collections.singleton("char"));
        hashMap.put("int", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("int", "short", "char", "byte"))));
        hashMap.put("long", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("long", "int", "short", "char", "byte"))));
        hashMap.put("float", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("float", "long", "int", "short", "char", "byte"))));
        hashMap.put("double", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("double", "float", "long", "int", "short", "char", "byte"))));
        hashMap.put("primitive number", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("double", "float", "long", "int", "short", "byte"))));
        PRIMITIVE_ASSIGNMENTS = Collections.unmodifiableMap(hashMap);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("java.lang.Boolean", "boolean");
        hashMap2.put("java.lang.Byte", "byte");
        hashMap2.put("java.lang.Short", "short");
        hashMap2.put("java.lang.Character", "char");
        hashMap2.put("java.lang.Integer", "int");
        hashMap2.put("java.lang.Long", "long");
        hashMap2.put("java.lang.Float", "float");
        hashMap2.put("java.lang.Double", "double");
        hashMap2.put("java.lang.Number", "primitive number");
        AUTOUNBOX = Collections.unmodifiableMap(hashMap2);
    }

    private static final boolean isPrimitiveAssignable(String string, String string2) {
        Set set = (Set)PRIMITIVE_ASSIGNMENTS.get(string);
        return set != null && set.contains(string2);
    }

    private static final String getAutoUnboxedType(String string) {
        String string2 = (String)AUTOUNBOX.get(string);
        return string2;
    }

    public ParameterGuesser(int n, ICompilationUnit iCompilationUnit) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)iCompilationUnit);
        this.fCodeAssistOffset = n;
        this.fCompilationUnit = iCompilationUnit;
        IJavaProject iJavaProject = this.fCompilationUnit.getJavaProject();
        String string = iJavaProject == null ? JavaCore.getOption((String)"org.eclipse.wst.jsdt.core.compiler.source") : iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
        this.fAllowAutoBoxing = "1.5".compareTo(string) <= 0;
    }

    public int getCodeAssistOffset() {
        return this.fCodeAssistOffset;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public ICompletionProposal[] parameterProposals(String string, String string2, String string3, Position position, IDocument iDocument) throws JavaModelException {
        Object object;
        if (this.fVariables == null) {
            object = new VariableCollector();
            this.fVariables = object.collect(this.fCodeAssistOffset, this.fCompilationUnit);
        }
        object = new Variable(string, string2, string3, 0, 0, null, null);
        List list = this.findProposalsMatchingType(this.fVariables, (Variable)object);
        ParameterGuesser.orderMatches(list, string3);
        ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[list.size()];
        int n = 0;
        int n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Variable variable = (Variable)iterator.next();
            if (n == 0) {
                variable.alreadyMatched = true;
                n2 = variable.name.length();
            }
            final char[] cArray = new char[variable.triggerChars.length + 1];
            System.arraycopy(variable.triggerChars, 0, cArray, 0, variable.triggerChars.length);
            String string4 = variable.isAutoboxingMatch ? variable.name : variable.name;
            cArray[cArray.length - 1] = 59;
            PositionBasedCompletionProposal positionBasedCompletionProposal = new PositionBasedCompletionProposal(variable.name, position, n2, this.getImage(variable.descriptor), string4, null, null){

                public char[] getTriggerCharacters() {
                    return cArray;
                }
            };
            iCompletionProposalArray[n++] = positionBasedCompletionProposal;
        }
        return iCompletionProposalArray;
    }

    private static void orderMatches(List list, String string) {
        if (list != null) {
            Collections.sort(list, new MatchComparator(string));
        }
    }

    private List findProposalsMatchingType(List list, Variable variable) throws JavaModelException {
        if (variable.getFQN().length() == 0) {
            return null;
        }
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            Variable variable2 = (Variable)listIterator.previous();
            variable2.isAutoboxingMatch = false;
            if (!variable.isAssignable(variable2)) continue;
            arrayList.add(variable2);
        }
        return arrayList;
    }

    private static String getLongestCommonSubstring(String string, String string2) {
        String string3 = string.length() <= string2.length() ? string : string2;
        String string4 = string3 == string ? string2 : string;
        int n = string3.length();
        StringBuffer stringBuffer = new StringBuffer(string3.length() + 2);
        String string5 = "";
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + 1;
            while (n3 <= n) {
                if (n3 - n2 >= string5.length()) {
                    String string6 = string3.substring(n2, n3);
                    stringBuffer.setLength(0);
                    stringBuffer.append('*');
                    stringBuffer.append(string6);
                    stringBuffer.append('*');
                    StringMatcher stringMatcher = new StringMatcher(stringBuffer.toString(), true, false);
                    if (stringMatcher.match(string4)) {
                        string5 = string6;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return string5;
    }

    private Image getImage(ImageDescriptor imageDescriptor) {
        return imageDescriptor == null ? null : this.fRegistry.get(imageDescriptor);
    }

    private static int getCompletionOffset(String string, int n) {
        char c;
        int n2 = n;
        while (n2 > 0 && (c = string.charAt(n2 - 1)) != '{' && c != ';') {
            --n2;
        }
        return Math.min(n2 + 1, string.length());
    }

    private static class MatchComparator
    implements Comparator {
        private String fParamName;

        MatchComparator(String string) {
            this.fParamName = string;
        }

        public int compare(Object object, Object object2) {
            Variable variable = (Variable)object;
            Variable variable2 = (Variable)object2;
            return this.score(variable2) - this.score(variable);
        }

        private int score(Variable variable) {
            int n;
            int n2 = 100 - variable.variableType;
            int n3 = ParameterGuesser.getLongestCommonSubstring(variable.name, this.fParamName).length();
            if ((double)n3 < 0.6 * (double)(n = Math.min(variable.name.length(), this.fParamName.length()))) {
                n3 = 0;
            }
            int n4 = variable.positionScore;
            int n5 = variable.alreadyMatched ? 0 : 1;
            int n6 = variable.isAutoboxingMatch ? 0 : 1;
            int n7 = n6 << 30 | n2 << 21 | n3 << 11 | n5 << 10 | n4;
            return n7;
        }
    }

    final class Variable {
        public static final int LOCAL = 0;
        public static final int FIELD = 1;
        public static final int METHOD = 1;
        public static final int INHERITED_FIELD = 3;
        public static final int INHERITED_METHOD = 3;
        public final String typePackage;
        public final String typeName;
        public final String name;
        public final int variableType;
        public final int positionScore;
        public boolean alreadyMatched;
        public char[] triggerChars;
        public ImageDescriptor descriptor;
        public boolean isAutoboxingMatch;
        private String fFQN;
        private boolean fFQNResolved = false;
        private IType fType;
        private boolean fTypeResolved = false;

        public Variable(String string, String string2, String string3, int n, int n2, char[] cArray, ImageDescriptor imageDescriptor) {
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            this.typePackage = string;
            this.typeName = string2;
            this.name = string3;
            this.variableType = n;
            this.positionScore = n2;
            this.triggerChars = cArray;
            this.descriptor = imageDescriptor;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.typePackage.length() != 0) {
                stringBuffer.append(this.typePackage);
                stringBuffer.append('.');
            }
            stringBuffer.append(this.typeName);
            stringBuffer.append(' ');
            stringBuffer.append(this.name);
            stringBuffer.append(" (");
            stringBuffer.append(this.variableType);
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        String getFQN() {
            if (!this.fFQNResolved) {
                this.fFQNResolved = true;
                this.fFQN = this.computeFQN(this.typePackage, this.typeName);
            }
            return this.fFQN;
        }

        private String computeFQN(String string, String string2) {
            if (string.length() != 0) {
                return String.valueOf(string) + '.' + string2;
            }
            return string2;
        }

        IType getType(IJavaProject iJavaProject) throws JavaModelException {
            if (!this.fTypeResolved) {
                this.fTypeResolved = true;
                if (this.typePackage.length() > 0) {
                    this.fType = iJavaProject.findType(this.getFQN());
                }
            }
            return this.fType;
        }

        boolean isPrimitive() {
            return PRIMITIVE_ASSIGNMENTS.containsKey(this.getFQN());
        }

        boolean isArrayType() {
            return this.getFQN().endsWith("[]");
        }

        boolean isHierarchyAssignable(Variable variable) throws JavaModelException {
            IJavaProject iJavaProject = ParameterGuesser.this.fCompilationUnit.getJavaProject();
            IType iType = this.getType(iJavaProject);
            IType iType2 = variable.getType(iJavaProject);
            if (iType2 == null || iType == null) {
                return false;
            }
            ITypeHierarchy iTypeHierarchy = SuperTypeHierarchyCache.getTypeHierarchy(iType2);
            return iTypeHierarchy.contains(iType);
        }

        boolean isAutoBoxingAssignable(Variable variable) {
            if (this.isPrimitive()) {
                String string = ParameterGuesser.getAutoUnboxedType(variable.getFQN());
                return ParameterGuesser.isPrimitiveAssignable(this.typeName, string);
            }
            if (variable.isPrimitive()) {
                String string = ParameterGuesser.getAutoUnboxedType(this.getFQN());
                return ParameterGuesser.isPrimitiveAssignable(string, variable.typeName);
            }
            return false;
        }

        boolean isAssignable(Variable variable) throws JavaModelException {
            if (this.typePackage.length() == 0 || variable.typePackage.length() == 0) {
                if (variable.typeName.equals(this.typeName)) {
                    return true;
                }
                if (ParameterGuesser.isPrimitiveAssignable(this.typeName, variable.typeName)) {
                    return true;
                }
                if (ParameterGuesser.this.fAllowAutoBoxing && this.isAutoBoxingAssignable(variable)) {
                    variable.isAutoboxingMatch = true;
                    return true;
                }
                return false;
            }
            if (variable.getFQN().equals(this.getFQN())) {
                return true;
            }
            return this.isHierarchyAssignable(variable);
        }
    }

    private final class VariableCollector
    extends CompletionRequestor {
        private String fEnclosingTypeName;
        private List fVars;

        VariableCollector() {
            this.setIgnored(1, true);
            this.setIgnored(2, false);
            this.setIgnored(3, true);
            this.setIgnored(4, true);
            this.setIgnored(7, true);
            this.setIgnored(12, true);
            this.setIgnored(6, false);
            this.setIgnored(8, true);
            this.setIgnored(11, true);
            this.setIgnored(10, true);
            this.setIgnored(9, true);
            this.setIgnored(13, false);
            this.setIgnored(5, false);
        }

        public List collect(int n, ICompilationUnit iCompilationUnit) throws JavaModelException {
            String string;
            String string2;
            Assert.isTrue((n >= 0 ? 1 : 0) != 0);
            Assert.isNotNull((Object)iCompilationUnit);
            this.fVars = new ArrayList();
            String string3 = iCompilationUnit.getSource();
            if (string3 == null) {
                return this.fVars;
            }
            this.fEnclosingTypeName = this.getEnclosingTypeName(n, iCompilationUnit);
            int n2 = ParameterGuesser.getCompletionOffset(string3, n);
            iCompilationUnit.codeComplete(n2, (CompletionRequestor)this);
            int n3 = this.fEnclosingTypeName.lastIndexOf(46);
            if (n3 != -1) {
                string2 = this.fEnclosingTypeName.substring(n3 + 1);
                string = this.fEnclosingTypeName.substring(0, n3);
            } else {
                string = new String();
                string2 = this.fEnclosingTypeName;
            }
            this.addVariable(1, string.toCharArray(), string2.toCharArray(), "this".toCharArray(), new char[]{'.'}, this.getFieldDescriptor(17));
            this.addVariable(1, NO_TRIGGERS, "boolean".toCharArray(), "true".toCharArray(), NO_TRIGGERS, null);
            this.addVariable(1, NO_TRIGGERS, "boolean".toCharArray(), "false".toCharArray(), NO_TRIGGERS, null);
            return this.fVars;
        }

        private String getEnclosingTypeName(int n, ICompilationUnit iCompilationUnit) throws JavaModelException {
            IJavaElement iJavaElement = iCompilationUnit.getElementAt(n);
            if (iJavaElement == null) {
                return null;
            }
            if ((iJavaElement = iJavaElement.getAncestor(7)) == null) {
                return null;
            }
            return iJavaElement.getElementName();
        }

        private final boolean isInherited(String string) {
            return !string.equals(this.fEnclosingTypeName);
        }

        private void addVariable(int n, char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4, ImageDescriptor imageDescriptor) {
            this.fVars.add(new Variable(new String(cArray), new String(cArray2), new String(cArray3), n, this.fVars.size(), cArray4, imageDescriptor));
        }

        private void acceptField(char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4, int n) {
            if (!this.isInherited(new String(cArray))) {
                this.addVariable(1, cArray3, cArray4, cArray2, NO_TRIGGERS, this.getFieldDescriptor(n));
            } else {
                this.addVariable(3, cArray3, cArray4, cArray2, NO_TRIGGERS, this.getFieldDescriptor(n));
            }
        }

        private void acceptLocalVariable(char[] cArray, char[] cArray2, char[] cArray3, int n) {
            this.addVariable(0, cArray2, cArray3, cArray, NO_TRIGGERS, this.decorate(JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE, n, false));
        }

        private void acceptMethod(char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4, int n) {
            if (!this.filter(cArray3, cArray4)) {
                this.addVariable(this.isInherited(new String(cArray)) ? 3 : 1, cArray2, cArray3, cArray4, NO_TRIGGERS, this.getMemberDescriptor(n));
            }
        }

        private boolean filter(char[] cArray, char[] cArray2) {
            return Arrays.equals(VOID, cArray) || Arrays.equals(HASHCODE, cArray2) || Arrays.equals(TOSTRING, cArray2) || Arrays.equals(CLONE, cArray2);
        }

        protected ImageDescriptor getMemberDescriptor(int n) {
            ImageDescriptor imageDescriptor = JavaElementImageProvider.getMethodImageDescriptor(false, n);
            return this.decorate(imageDescriptor, n, false);
        }

        protected ImageDescriptor getFieldDescriptor(int n) {
            ImageDescriptor imageDescriptor = JavaElementImageProvider.getFieldImageDescriptor(false, n);
            return this.decorate(imageDescriptor, n, true);
        }

        private ImageDescriptor decorate(ImageDescriptor imageDescriptor, int n, boolean bl) {
            int n2 = 0;
            if (Flags.isDeprecated((int)n)) {
                n2 |= 0x400;
            }
            if (Flags.isStatic((int)n)) {
                n2 |= 8;
            }
            if (Flags.isFinal((int)n)) {
                n2 |= 2;
            }
            if (Flags.isSynchronized((int)n)) {
                n2 |= 4;
            }
            if (Flags.isAbstract((int)n)) {
                n2 |= 1;
            }
            if (bl) {
                if (Flags.isVolatile((int)n)) {
                    n2 |= 0x800;
                }
                if (Flags.isTransient((int)n)) {
                    n2 |= 0x1000;
                }
            }
            return new JavaElementImageDescriptor(imageDescriptor, n2, JavaElementImageProvider.SMALL_SIZE);
        }

        public void accept(CompletionProposal completionProposal) {
            if (this.isIgnored(completionProposal.getKind())) {
                return;
            }
            switch (completionProposal.getKind()) {
                case 2: {
                    this.acceptField(Signature.getSignatureSimpleName((char[])completionProposal.getDeclarationSignature()), completionProposal.getName(), Signature.getSignatureQualifier((char[])completionProposal.getSignature()), Signature.getSignatureSimpleName((char[])completionProposal.getSignature()), completionProposal.getFlags());
                    return;
                }
                case 5: {
                    this.acceptLocalVariable(completionProposal.getCompletion(), Signature.getSignatureQualifier((char[])completionProposal.getSignature()), Signature.getSignatureSimpleName((char[])completionProposal.getSignature()), completionProposal.getFlags());
                    return;
                }
                case 6: {
                    if (Signature.getParameterCount((char[])completionProposal.getSignature()) != 0) break;
                    this.acceptMethod(Signature.getSignatureSimpleName((char[])completionProposal.getDeclarationSignature()), Signature.getSignatureQualifier((char[])Signature.getReturnType((char[])completionProposal.getSignature())), Signature.getSignatureSimpleName((char[])Signature.getReturnType((char[])completionProposal.getSignature())), completionProposal.getCompletion(), completionProposal.getFlags());
                }
            }
        }
    }
}

