/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalLabelProvider;

public final class ProposalContextInformation
implements IContextInformation,
IContextInformationExtension {
    private final String fContextDisplayString;
    private final String fInformationDisplayString;
    private final Image fImage;
    private int fPosition;

    public ProposalContextInformation(CompletionProposal completionProposal) {
        CompletionProposalLabelProvider completionProposalLabelProvider = new CompletionProposalLabelProvider();
        this.fInformationDisplayString = completionProposalLabelProvider.createParameterList(completionProposal);
        ImageDescriptor imageDescriptor = completionProposalLabelProvider.createImageDescriptor(completionProposal);
        this.fImage = imageDescriptor != null ? JavaPlugin.getImageDescriptorRegistry().get(imageDescriptor) : null;
        this.fPosition = completionProposal.getCompletion().length == 0 ? completionProposal.getCompletionLocation() + 1 : -1;
        this.fContextDisplayString = completionProposalLabelProvider.createLabel(completionProposal);
    }

    public boolean equals(Object object) {
        if (object instanceof IContextInformation) {
            IContextInformation iContextInformation = (IContextInformation)object;
            boolean bl = this.getInformationDisplayString().equalsIgnoreCase(iContextInformation.getInformationDisplayString());
            if (this.getContextDisplayString() != null) {
                bl = bl && this.getContextDisplayString().equalsIgnoreCase(iContextInformation.getContextDisplayString());
            }
            return bl;
        }
        return false;
    }

    public String getInformationDisplayString() {
        return this.fInformationDisplayString;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getContextDisplayString() {
        return this.fContextDisplayString;
    }

    public int getContextInformationPosition() {
        return this.fPosition;
    }

    public void setContextInformationPosition(int n) {
        this.fPosition = n;
    }
}

