/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.wst.jsdt.internal.ui.text.java.ProposalSorterHandle;

public final class ProposalSorterRegistry {
    private static final String EXTENSION_POINT = "javaCompletionProposalSorters";
    private static final String DEFAULT_ID = "org.eclipse.wst.jsdt.ui.RelevanceSorter";
    private static ProposalSorterRegistry fInstance;
    private final IPreferenceStore fPreferenceStore;
    private final String fKey;
    private Map fSorters = null;
    private ProposalSorterHandle fDefaultSorter;

    public static synchronized ProposalSorterRegistry getDefault() {
        if (fInstance == null) {
            fInstance = new ProposalSorterRegistry(JavaPlugin.getDefault().getPreferenceStore(), "content_assist_sorter");
        }
        return fInstance;
    }

    private ProposalSorterRegistry(IPreferenceStore iPreferenceStore, String string) {
        Assert.isTrue((iPreferenceStore != null ? 1 : 0) != 0);
        Assert.isTrue((string != null ? 1 : 0) != 0);
        this.fPreferenceStore = iPreferenceStore;
        this.fKey = string;
    }

    public ProposalSorterHandle getCurrentSorter() {
        this.ensureSortersRead();
        String string = this.fPreferenceStore.getString(this.fKey);
        ProposalSorterHandle proposalSorterHandle = (ProposalSorterHandle)this.fSorters.get(string);
        return proposalSorterHandle != null ? proposalSorterHandle : this.fDefaultSorter;
    }

    private synchronized void ensureSortersRead() {
        if (this.fSorters != null) {
            return;
        }
        LinkedHashMap<Object[], ProposalSorterHandle> linkedHashMap = new LinkedHashMap<Object[], ProposalSorterHandle>();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>(Arrays.asList(iExtensionRegistry.getConfigurationElementsFor(JavaPlugin.getPluginId(), EXTENSION_POINT)));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray;
            IConfigurationElement iConfigurationElement = (IConfigurationElement)iterator.next();
            try {
                ProposalSorterHandle proposalSorterHandle = new ProposalSorterHandle(iConfigurationElement);
                objectArray = proposalSorterHandle.getId();
                linkedHashMap.put(objectArray, proposalSorterHandle);
                if (!DEFAULT_ID.equals(objectArray)) continue;
                this.fDefaultSorter = proposalSorterHandle;
            }
            catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                objectArray = new Object[]{iConfigurationElement.toString()};
                String string = Messages.format(JavaTextMessages.CompletionProposalComputerRegistry_invalid_message, objectArray);
                Status status = new Status(2, JavaPlugin.getPluginId(), 0, string, (Throwable)invalidRegistryObjectException);
                this.informUser((IStatus)status);
            }
        }
        this.fSorters = linkedHashMap;
    }

    private void informUser(IStatus iStatus) {
        JavaPlugin.log(iStatus);
        String string = JavaTextMessages.CompletionProposalComputerRegistry_error_dialog_title;
        String string2 = iStatus.getMessage();
        MessageDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)string, (String)string2);
    }

    public ProposalSorterHandle[] getSorters() {
        this.ensureSortersRead();
        Collection collection = this.fSorters.values();
        return collection.toArray(new ProposalSorterHandle[collection.size()]);
    }

    public void select(ProposalSorterHandle proposalSorterHandle) {
        Assert.isTrue((proposalSorterHandle != null ? 1 : 0) != 0);
        String string = proposalSorterHandle.getId();
        this.fPreferenceStore.setValue(this.fKey, string);
    }
}

