/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.javadoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.IHtmlTagConstants;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavadocContentAssistInvocationContext;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposalComputer;

public class HTMLTagCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private static final String[] fgHTMLProposals = new String[IHtmlTagConstants.HTML_GENERAL_TAGS.length * 2];
    private IDocument fDocument;
    private int fCurrentPos;
    private int fCurrentLength;
    private String fErrorMessage;
    private List fResult;
    private boolean fRestrictToMatchingCase;

    public HTMLTagCompletionProposalComputer() {
        String string = null;
        int n = 0;
        int n2 = 0;
        while (n < fgHTMLProposals.length) {
            string = IHtmlTagConstants.HTML_GENERAL_TAGS[n2];
            HTMLTagCompletionProposalComputer.fgHTMLProposals[n++] = String.valueOf('<') + string + '>';
            HTMLTagCompletionProposalComputer.fgHTMLProposals[n++] = "</" + string + '>';
            ++n2;
        }
    }

    private static boolean isWordPart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '#' || c == '.' || c == '/';
    }

    private static int findCharBeforeWord(IDocument iDocument, int n, int n2) {
        int n3 = n2 - 1;
        if (n3 > n) {
            try {
                while (n3 > n && HTMLTagCompletionProposalComputer.isWordPart(iDocument.getChar(n3))) {
                    --n3;
                }
                return n3;
            }
            catch (BadLocationException badLocationException) {}
        }
        return n2;
    }

    private static int findClosingCharacter(IDocument iDocument, int n, int n2, char c) throws BadLocationException {
        int n3 = n;
        while (n3 < n2 && iDocument.getChar(n3) != c) {
            ++n3;
        }
        if (n3 < n2) {
            return n3 + 1;
        }
        return n;
    }

    private static int findReplaceEndPos(IDocument iDocument, String string, String string2, int n) {
        if (string2.length() == 0 || string2.equals(string)) {
            return n;
        }
        try {
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n2 = iRegion.getOffset() + iRegion.getLength();
            return HTMLTagCompletionProposalComputer.findClosingCharacter(iDocument, n, n2, '>');
        }
        catch (BadLocationException badLocationException) {
            return n;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List computeCompletionProposals(ContentAssistInvocationContext contentAssistInvocationContext, IProgressMonitor iProgressMonitor) {
        if (!(contentAssistInvocationContext instanceof JavadocContentAssistInvocationContext)) {
            return Collections.EMPTY_LIST;
        }
        JavadocContentAssistInvocationContext javadocContentAssistInvocationContext = (JavadocContentAssistInvocationContext)contentAssistInvocationContext;
        int n = javadocContentAssistInvocationContext.getFlags();
        this.fCurrentPos = javadocContentAssistInvocationContext.getInvocationOffset();
        this.fCurrentLength = javadocContentAssistInvocationContext.getSelectionLength();
        this.fRestrictToMatchingCase = (n & 1) != 0;
        ICompilationUnit iCompilationUnit = javadocContentAssistInvocationContext.getCompilationUnit();
        if (iCompilationUnit == null) {
            return Collections.EMPTY_LIST;
        }
        FileEditorInput fileEditorInput = new FileEditorInput((IFile)iCompilationUnit.getResource());
        this.fDocument = JavaUI.getDocumentProvider().getDocument((Object)fileEditorInput);
        if (this.fDocument == null) {
            return null;
        }
        try {
            try {
                this.fResult = new ArrayList(100);
                this.evalProposals();
                List list = this.fResult;
                Object var8_8 = null;
                this.fResult = null;
                return list;
            }
            catch (JavaModelException javaModelException) {
                this.fErrorMessage = javaModelException.getLocalizedMessage();
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.fResult = null;
            throw throwable;
        }
        {
            Object var8_10 = null;
            this.fResult = null;
            return null;
        }
    }

    private void evalProposals() throws JavaModelException {
        try {
            IRegion iRegion = this.fDocument.getLineInformationOfOffset(this.fCurrentPos);
            int n = iRegion.getOffset();
            int n2 = HTMLTagCompletionProposalComputer.findCharBeforeWord(this.fDocument, n, this.fCurrentPos);
            if (n2 == this.fCurrentPos) {
                return;
            }
            char c = this.fDocument.getChar(n2);
            if (c == '<') {
                String string = this.fDocument.get(n2, this.fCurrentPos - n2);
                this.addProposals(string, fgHTMLProposals, "org.eclipse.wst.jsdt.ui.html_tag_obj.gif");
                return;
            }
            if (!Character.isWhitespace(c)) {
                return;
            }
            String string = this.fDocument.get(n2 + 1, this.fCurrentPos - n2 - 1);
            this.addAllTags(string);
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean prefixMatches(String string, String string2) {
        if (this.fRestrictToMatchingCase) {
            return string2.startsWith(string);
        }
        if (string2.length() >= string.length()) {
            return string.equalsIgnoreCase(string2.substring(0, string.length()));
        }
        return false;
    }

    private void addAllTags(String string) {
        String string2 = "<" + string;
        int n = 0;
        while (n < fgHTMLProposals.length) {
            String string3 = fgHTMLProposals[n];
            if (this.prefixMatches(string2, string3)) {
                this.fResult.add(this.createCompletion(string3, string, string3, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.html_tag_obj.gif"), 0));
            }
            ++n;
        }
    }

    private void addProposals(String string, String[] stringArray, String string2) {
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            if (this.prefixMatches(string, string3)) {
                this.fResult.add(this.createCompletion(string3, string, string3, JavaPluginImages.get(string2), 0));
            }
            ++n;
        }
    }

    private JavaCompletionProposal createCompletion(String string, String string2, String string3, Image image, int n) {
        int n2 = this.fCurrentPos - string2.length();
        int n3 = this.fCurrentLength + string2.length();
        if (this.fCurrentLength == 0) {
            n3 = HTMLTagCompletionProposalComputer.findReplaceEndPos(this.fDocument, string, string2, this.fCurrentPos) - n2;
        }
        if (!string.startsWith("</")) {
            ++n;
        }
        JavaCompletionProposal javaCompletionProposal = new JavaCompletionProposal(string, n2, n3, image, string3, n, true);
        javaCompletionProposal.setTriggerCharacters(new char[]{'>'});
        return javaCompletionProposal;
    }

    public List computeContextInformation(ContentAssistInvocationContext contentAssistInvocationContext, IProgressMonitor iProgressMonitor) {
        return Collections.EMPTY_LIST;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public void sessionEnded() {
        this.fErrorMessage = null;
    }

    public void sessionStarted() {
        this.fErrorMessage = null;
    }
}

