/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.HtmlTagDictionary;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.JavaDocTagDictionary;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.TaskTagDictionary;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.DefaultSpellChecker;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellDictionary;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.LocaleSensitiveSpellDictionary;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.PersistentSpellDictionary;

public class SpellCheckEngine
implements ISpellCheckEngine,
IPropertyChangeListener {
    public static final String DICTIONARY_LOCATION = "dictionaries/";
    private static ISpellCheckEngine fgEngine = null;
    private static Set fgLocalesWithInstalledDictionaries;
    private Set fGlobalDictionaries = new HashSet();
    private ISpellChecker fChecker = null;
    private Map fLocaleDictionaries = new HashMap();
    private ISpellDictionary fUserDictionary = null;

    public static Set getLocalesWithInstalledDictionaries() {
        String[] stringArray;
        URL uRL;
        if (fgLocalesWithInstalledDictionaries != null) {
            return fgLocalesWithInstalledDictionaries;
        }
        try {
            uRL = SpellCheckEngine.getDictionaryLocation();
            if (uRL == null) {
                fgLocalesWithInstalledDictionaries = Collections.EMPTY_SET;
                return fgLocalesWithInstalledDictionaries;
            }
        }
        catch (MalformedURLException malformedURLException) {
            JavaPlugin.log(malformedURLException);
            fgLocalesWithInstalledDictionaries = Collections.EMPTY_SET;
            return fgLocalesWithInstalledDictionaries;
        }
        try {
            URL uRL2 = FileLocator.toFileURL((URL)uRL);
            File file = new File(uRL2.getFile());
            if (!file.isDirectory()) {
                fgLocalesWithInstalledDictionaries = Collections.EMPTY_SET;
                return fgLocalesWithInstalledDictionaries;
            }
            stringArray = file.list();
            if (stringArray == null) {
                fgLocalesWithInstalledDictionaries = Collections.EMPTY_SET;
                return fgLocalesWithInstalledDictionaries;
            }
        }
        catch (IOException iOException) {
            JavaPlugin.log(iOException);
            fgLocalesWithInstalledDictionaries = Collections.EMPTY_SET;
            return fgLocalesWithInstalledDictionaries;
        }
        fgLocalesWithInstalledDictionaries = new HashSet();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            int n3 = string.indexOf(".dictionary");
            if (n3 > 1) {
                String string2 = string.substring(0, n3);
                int n4 = string2.indexOf(95);
                if (n4 == -1) {
                    fgLocalesWithInstalledDictionaries.add(new Locale(string2));
                } else if (n4 == 2 && string2.length() == 5) {
                    fgLocalesWithInstalledDictionaries.add(new Locale(string2.substring(0, 2), string2.substring(3)));
                } else if (string2.length() > 6 && string2.charAt(5) == '_') {
                    fgLocalesWithInstalledDictionaries.add(new Locale(string2.substring(0, 2), string2.substring(3, 5), string2.substring(6)));
                }
            }
            ++n2;
        }
        return fgLocalesWithInstalledDictionaries;
    }

    public static Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public ISpellDictionary findDictionary(Locale locale) {
        ISpellDictionary iSpellDictionary = (ISpellDictionary)this.fLocaleDictionaries.get(locale);
        if (iSpellDictionary != null) {
            return iSpellDictionary;
        }
        String string = locale.getLanguage();
        Iterator iterator = this.fLocaleDictionaries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Locale locale2 = (Locale)entry.getKey();
            if (!locale2.getLanguage().equals(string)) continue;
            return (ISpellDictionary)entry.getValue();
        }
        return null;
    }

    public static Locale findClosestLocale(Locale locale) {
        Locale locale2;
        if (locale == null || locale.toString().length() == 0) {
            return locale;
        }
        if (SpellCheckEngine.getLocalesWithInstalledDictionaries().contains(locale)) {
            return locale;
        }
        String string = locale.getLanguage();
        Iterator iterator = SpellCheckEngine.getLocalesWithInstalledDictionaries().iterator();
        while (iterator.hasNext()) {
            locale2 = (Locale)iterator.next();
            if (!locale2.getLanguage().equals(string)) continue;
            return locale2;
        }
        locale2 = Locale.US;
        if (SpellCheckEngine.getLocalesWithInstalledDictionaries().contains(locale2)) {
            return locale2;
        }
        return null;
    }

    public static URL getDictionaryLocation() throws MalformedURLException {
        JavaPlugin javaPlugin = JavaPlugin.getDefault();
        if (javaPlugin != null) {
            return javaPlugin.getBundle().getEntry("/dictionaries/");
        }
        return null;
    }

    public static final synchronized ISpellCheckEngine getInstance() {
        if (fgEngine == null) {
            fgEngine = new SpellCheckEngine();
        }
        return fgEngine;
    }

    public static final synchronized void shutdownInstance() {
        if (fgEngine != null) {
            fgEngine.shutdown();
            fgEngine = null;
        }
    }

    private SpellCheckEngine() {
        this.fGlobalDictionaries.add(new TaskTagDictionary());
        this.fGlobalDictionaries.add(new HtmlTagDictionary());
        this.fGlobalDictionaries.add(new JavaDocTagDictionary());
        try {
            Locale locale = null;
            URL uRL = SpellCheckEngine.getDictionaryLocation();
            Iterator iterator = SpellCheckEngine.getLocalesWithInstalledDictionaries().iterator();
            while (iterator.hasNext()) {
                locale = (Locale)iterator.next();
                this.fLocaleDictionaries.put(locale, new LocaleSensitiveSpellDictionary(locale, uRL));
            }
        }
        catch (MalformedURLException malformedURLException) {}
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public final synchronized ISpellChecker getSpellChecker() throws IllegalStateException {
        if (this.fGlobalDictionaries == null) {
            throw new IllegalStateException("spell checker has been shut down");
        }
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        Locale locale = this.getCurrentLocale(iPreferenceStore);
        if (this.fUserDictionary == null && "".equals(locale.toString())) {
            return null;
        }
        if (this.fChecker != null && this.fChecker.getLocale().equals(locale)) {
            return this.fChecker;
        }
        this.resetSpellChecker();
        this.fChecker = new DefaultSpellChecker(iPreferenceStore, locale);
        this.resetUserDictionary();
        Object object = this.fGlobalDictionaries.iterator();
        while (object.hasNext()) {
            ISpellDictionary iSpellDictionary = (ISpellDictionary)object.next();
            this.fChecker.addDictionary(iSpellDictionary);
        }
        object = this.findDictionary(this.fChecker.getLocale());
        if (object != null) {
            this.fChecker.addDictionary((ISpellDictionary)object);
        }
        return this.fChecker;
    }

    private Locale getCurrentLocale(IPreferenceStore iPreferenceStore) {
        return SpellCheckEngine.convertToLocale(iPreferenceStore.getString("spelling_locale"));
    }

    public static Locale convertToLocale(String string) {
        Locale locale = SpellCheckEngine.getDefaultLocale();
        if (string.equals(locale.toString())) {
            return locale;
        }
        if (string.length() >= 5) {
            return new Locale(string.substring(0, 2), string.substring(3, 5));
        }
        return new Locale("");
    }

    public final synchronized Locale getLocale() {
        if (this.fChecker == null) {
            return null;
        }
        return this.fChecker.getLocale();
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("spelling_locale")) {
            this.resetSpellChecker();
            return;
        }
        if (propertyChangeEvent.getProperty().equals("spelling_user_dictionary")) {
            this.resetUserDictionary();
            return;
        }
        if (propertyChangeEvent.getProperty().equals("spelling_user_dictionary_encoding")) {
            this.resetUserDictionary();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void resetUserDictionary() {
        IPreferenceStore iPreferenceStore;
        String string;
        if (this.fChecker == null) {
            return;
        }
        if (this.fUserDictionary != null) {
            this.fChecker.removeDictionary(this.fUserDictionary);
            this.fUserDictionary.unload();
            this.fUserDictionary = null;
        }
        if ((string = (iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore()).getString("spelling_user_dictionary")).length() <= 0) return;
        try {
            File file = new File(string);
            if (!file.exists() && !file.createNewFile()) {
                return;
            }
            URL uRL = new URL("file", null, string);
            InputStream inputStream = uRL.openStream();
            if (inputStream == null) return;
            try {
                this.fUserDictionary = new PersistentSpellDictionary(uRL);
                this.fChecker.addDictionary(this.fUserDictionary);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                inputStream.close();
                throw throwable;
            }
            {
                Object var6_8 = null;
                inputStream.close();
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        catch (IOException iOException) {}
    }

    public final synchronized void registerGlobalDictionary(ISpellDictionary iSpellDictionary) {
        this.fGlobalDictionaries.add(iSpellDictionary);
        this.resetSpellChecker();
    }

    public final synchronized void registerDictionary(Locale locale, ISpellDictionary iSpellDictionary) {
        this.fLocaleDictionaries.put(locale, iSpellDictionary);
        this.resetSpellChecker();
    }

    public final synchronized void shutdown() {
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        ISpellDictionary iSpellDictionary = null;
        Iterator<Object> iterator = this.fGlobalDictionaries.iterator();
        while (iterator.hasNext()) {
            iSpellDictionary = (ISpellDictionary)iterator.next();
            iSpellDictionary.unload();
        }
        this.fGlobalDictionaries = null;
        iterator = this.fLocaleDictionaries.values().iterator();
        while (iterator.hasNext()) {
            iSpellDictionary = (ISpellDictionary)iterator.next();
            iSpellDictionary.unload();
        }
        this.fLocaleDictionaries = null;
        this.fUserDictionary = null;
        this.fChecker = null;
    }

    private synchronized void resetSpellChecker() {
        ISpellDictionary iSpellDictionary;
        if (this.fChecker != null && (iSpellDictionary = (ISpellDictionary)this.fLocaleDictionaries.get(this.fChecker.getLocale())) != null) {
            iSpellDictionary.unload();
        }
        this.fChecker = null;
    }

    public final synchronized void unregisterDictionary(ISpellDictionary iSpellDictionary) {
        this.fGlobalDictionaries.remove(iSpellDictionary);
        this.fLocaleDictionaries.values().remove(iSpellDictionary);
        iSpellDictionary.unload();
        this.resetSpellChecker();
    }
}

