/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.JavaElementImageDescriptor;

public class HierarchyLabelProvider
extends AppearanceAwareLabelProvider {
    private Color fSpecialColor;
    private ViewerFilter fFilter;
    private TypeHierarchyLifeCycle fHierarchy;
    static /* synthetic */ Class class$0;

    public HierarchyLabelProvider(TypeHierarchyLifeCycle typeHierarchyLifeCycle) {
        super(317758862524457L, 1);
        this.fHierarchy = typeHierarchyLifeCycle;
        this.fFilter = null;
    }

    public ViewerFilter getFilter() {
        return this.fFilter;
    }

    public void setFilter(ViewerFilter viewerFilter) {
        this.fFilter = viewerFilter;
    }

    protected boolean isDifferentScope(IType iType) {
        if (this.fFilter != null && !this.fFilter.select(null, null, (Object)iType)) {
            return true;
        }
        IJavaElement iJavaElement = this.fHierarchy.getInputElement();
        if (iJavaElement == null || iJavaElement.getElementType() == 7) {
            return false;
        }
        IJavaElement iJavaElement2 = iType.getAncestor(iJavaElement.getElementType());
        return !(iJavaElement.getElementType() == 4 ? iJavaElement2 == null || iJavaElement2.getElementName().equals(iJavaElement.getElementName()) : iJavaElement.equals(iJavaElement2));
    }

    public Image getImage(Object object) {
        Image image = null;
        if (object instanceof IType) {
            Object object2 = this.getTypeImageDescriptor((IType)object);
            if (object2 != null) {
                if (object.equals(this.fHierarchy.getInputElement())) {
                    object2 = new FocusDescriptor((ImageDescriptor)object2);
                }
                image = JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)object2);
            }
        } else {
            image = this.fImageLabelProvider.getImageLabel(object, this.evaluateImageFlags(object));
        }
        return this.decorateImage(image, object);
    }

    private ImageDescriptor getTypeImageDescriptor(IType iType) {
        ITypeHierarchy iTypeHierarchy = this.fHierarchy.getHierarchy();
        if (iTypeHierarchy == null) {
            return new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_CLASS, 0, JavaElementImageProvider.BIG_SIZE);
        }
        int n = iTypeHierarchy.getCachedFlags(iType);
        if (n == -1) {
            return new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_CLASS, 0, JavaElementImageProvider.BIG_SIZE);
        }
        boolean bl = Flags.isInterface((int)n);
        boolean bl2 = iType.getDeclaringType() != null;
        ImageDescriptor imageDescriptor = JavaElementImageProvider.getTypeImageDescriptor(bl2, false, n, this.isDifferentScope(iType));
        int n2 = 0;
        if (Flags.isFinal((int)n)) {
            n2 |= 2;
        }
        if (Flags.isAbstract((int)n) && !bl) {
            n2 |= 1;
        }
        if (Flags.isStatic((int)n)) {
            n2 |= 8;
        }
        return new JavaElementImageDescriptor(imageDescriptor, n2, JavaElementImageProvider.BIG_SIZE);
    }

    public Color getForeground(Object object) {
        if (object instanceof IMethod) {
            if (this.fSpecialColor == null) {
                this.fSpecialColor = Display.getCurrent().getSystemColor(10);
            }
            return this.fSpecialColor;
        }
        if (object instanceof IType && this.isDifferentScope((IType)object)) {
            return JFaceResources.getColorRegistry().get("org.eclipse.wst.jsdt.ui.ColoredLabels.qualifier");
        }
        return null;
    }

    private static class FocusDescriptor
    extends CompositeImageDescriptor {
        private ImageDescriptor fBase;

        public FocusDescriptor(ImageDescriptor imageDescriptor) {
            this.fBase = imageDescriptor;
        }

        protected void drawCompositeImage(int n, int n2) {
            this.drawImage(this.getImageData(this.fBase), 0, 0);
            this.drawImage(this.getImageData(JavaPluginImages.DESC_OVR_FOCUS), 0, 0);
        }

        private ImageData getImageData(ImageDescriptor imageDescriptor) {
            ImageData imageData = imageDescriptor.getImageData();
            if (imageData == null) {
                imageData = DEFAULT_IMAGE_DATA;
                JavaPlugin.logErrorMessage("Image data not available: " + imageDescriptor.toString());
            }
            return imageData;
        }

        protected Point getSize() {
            return JavaElementImageProvider.BIG_SIZE;
        }

        public int hashCode() {
            return this.fBase.hashCode();
        }

        public boolean equals(Object object) {
            if (object != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.internal.ui.typehierarchy.HierarchyLabelProvider$FocusDescriptor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(object.getClass()) && ((FocusDescriptor)((Object)object)).fBase.equals(this.fBase)) {
                    return true;
                }
            }
            return false;
        }
    }
}

