/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.ITypeHierarchyLifeCycleListener;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.wst.jsdt.ui.IWorkingCopyProvider;

public abstract class TypeHierarchyContentProvider
implements ITreeContentProvider,
IWorkingCopyProvider {
    protected static final Object[] NO_ELEMENTS = new Object[0];
    protected TypeHierarchyLifeCycle fTypeHierarchy;
    protected IMember[] fMemberFilter;
    protected TreeViewer fViewer;
    private ViewerFilter fWorkingSetFilter;
    private MethodOverrideTester fMethodOverrideTester;
    private ITypeHierarchyLifeCycleListener fTypeHierarchyLifeCycleListener;

    public TypeHierarchyContentProvider(TypeHierarchyLifeCycle typeHierarchyLifeCycle) {
        this.fTypeHierarchy = typeHierarchyLifeCycle;
        this.fMemberFilter = null;
        this.fWorkingSetFilter = null;
        this.fMethodOverrideTester = null;
        this.fTypeHierarchyLifeCycleListener = new ITypeHierarchyLifeCycleListener(){

            public void typeHierarchyChanged(TypeHierarchyLifeCycle typeHierarchyLifeCycle, IType[] iTypeArray) {
                if (iTypeArray == null) {
                    TypeHierarchyContentProvider.this.fMethodOverrideTester = null;
                }
            }
        };
        typeHierarchyLifeCycle.addChangedListener(this.fTypeHierarchyLifeCycleListener);
    }

    public final void setMemberFilter(IMember[] iMemberArray) {
        this.fMemberFilter = iMemberArray;
    }

    private boolean initializeMethodOverrideTester(IMethod iMethod, IType iType) {
        IType iType2;
        IType iType3 = iMethod.getDeclaringType();
        ITypeHierarchy iTypeHierarchy = this.fTypeHierarchy.getHierarchy();
        boolean bl = JavaModelUtil.isSuperType(iTypeHierarchy, iType, iType3);
        IType iType4 = iType2 = bl ? iType3 : iType;
        if (this.fMethodOverrideTester == null || !this.fMethodOverrideTester.getFocusType().equals(iType2)) {
            this.fMethodOverrideTester = new MethodOverrideTester(iType2, iTypeHierarchy);
        }
        return bl;
    }

    private void addCompatibleMethods(IMethod iMethod, IType iType, List list) throws JavaModelException {
        boolean bl = this.initializeMethodOverrideTester(iMethod, iType);
        IMethod[] iMethodArray = iType.getMethods();
        int n = 0;
        while (n < iMethodArray.length) {
            IMethod iMethod2 = iMethodArray[n];
            if (this.isCompatibleMethod(iMethod, iMethod2, bl) && !list.contains(iMethod2)) {
                list.add(iMethod2);
            }
            ++n;
        }
    }

    private boolean hasCompatibleMethod(IMethod iMethod, IType iType) throws JavaModelException {
        boolean bl = this.initializeMethodOverrideTester(iMethod, iType);
        IMethod[] iMethodArray = iType.getMethods();
        int n = 0;
        while (n < iMethodArray.length) {
            if (this.isCompatibleMethod(iMethod, iMethodArray[n], bl)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isCompatibleMethod(IMethod iMethod, IMethod iMethod2, boolean bl) throws JavaModelException {
        if (bl) {
            return this.fMethodOverrideTester.isSubsignature(iMethod, iMethod2);
        }
        return this.fMethodOverrideTester.isSubsignature(iMethod2, iMethod);
    }

    public IMember[] getMemberFilter() {
        return this.fMemberFilter;
    }

    public void setWorkingSetFilter(ViewerFilter viewerFilter) {
        this.fWorkingSetFilter = viewerFilter;
    }

    protected final ITypeHierarchy getHierarchy() {
        return this.fTypeHierarchy.getHierarchy();
    }

    public boolean providesWorkingCopies() {
        return true;
    }

    public Object[] getElements(Object object) {
        ArrayList arrayList = new ArrayList();
        this.getRootTypes(arrayList);
        int n = arrayList.size() - 1;
        while (n >= 0) {
            IType iType = (IType)arrayList.get(n);
            try {
                if (!this.isInTree(iType)) {
                    arrayList.remove(n);
                }
            }
            catch (JavaModelException javaModelException) {}
            --n;
        }
        return arrayList.toArray();
    }

    protected void getRootTypes(List list) {
        IType iType;
        ITypeHierarchy iTypeHierarchy = this.getHierarchy();
        if (iTypeHierarchy != null && (iType = iTypeHierarchy.getType()) != null) {
            list.add(iType);
        }
    }

    protected abstract void getTypesInHierarchy(IType var1, List var2);

    protected abstract IType getParentType(IType var1);

    private boolean isInScope(IType iType) {
        if (this.fWorkingSetFilter != null && !this.fWorkingSetFilter.select(null, null, (Object)iType)) {
            return false;
        }
        IJavaElement iJavaElement = this.fTypeHierarchy.getInputElement();
        int n = iJavaElement.getElementType();
        if (n == 7) {
            return true;
        }
        IJavaElement iJavaElement2 = iType.getAncestor(iJavaElement.getElementType());
        return n == 4 ? iJavaElement2 == null || iJavaElement2.getElementName().equals(iJavaElement.getElementName()) : iJavaElement.equals(iJavaElement2);
    }

    public Object[] getChildren(Object object) {
        if (object instanceof IType) {
            try {
                IType iType = (IType)object;
                ArrayList arrayList = new ArrayList();
                if (this.fMemberFilter != null) {
                    this.addFilteredMemberChildren(iType, arrayList);
                }
                this.addTypeChildren(iType, arrayList);
                return arrayList.toArray();
            }
            catch (JavaModelException javaModelException) {}
        }
        return NO_ELEMENTS;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof IType) {
            try {
                IType iType = (IType)object;
                return this.hasTypeChildren(iType) || this.fMemberFilter != null && this.hasMemberFilterChildren(iType);
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return false;
    }

    private void addFilteredMemberChildren(IType iType, List list) throws JavaModelException {
        int n = 0;
        while (n < this.fMemberFilter.length) {
            IMember iMember = this.fMemberFilter[n];
            if (iType.equals(iMember.getDeclaringType())) {
                if (!list.contains(iMember)) {
                    list.add(iMember);
                }
            } else if (iMember instanceof IMethod) {
                this.addCompatibleMethods((IMethod)iMember, iType, list);
            }
            ++n;
        }
    }

    private void addTypeChildren(IType iType, List list) throws JavaModelException {
        ArrayList arrayList = new ArrayList();
        this.getTypesInHierarchy(iType, arrayList);
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            IType iType2 = (IType)arrayList.get(n2);
            if (this.isInTree(iType2)) {
                list.add(iType2);
            }
            ++n2;
        }
    }

    protected final boolean isInTree(IType iType) throws JavaModelException {
        if (this.isInScope(iType)) {
            if (this.fMemberFilter != null) {
                return this.hasMemberFilterChildren(iType) || this.hasTypeChildren(iType);
            }
            return true;
        }
        return this.hasTypeChildren(iType);
    }

    private boolean hasMemberFilterChildren(IType iType) throws JavaModelException {
        int n = 0;
        while (n < this.fMemberFilter.length) {
            IMember iMember = this.fMemberFilter[n];
            if (iType.equals(iMember.getDeclaringType())) {
                return true;
            }
            if (iMember instanceof IMethod && this.hasCompatibleMethod((IMethod)iMember, iType)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean hasTypeChildren(IType iType) throws JavaModelException {
        ArrayList arrayList = new ArrayList();
        this.getTypesInHierarchy(iType, arrayList);
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            IType iType2 = (IType)arrayList.get(n2);
            if (this.isInTree(iType2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        Assert.isTrue((boolean)(viewer instanceof TreeViewer));
        this.fViewer = (TreeViewer)viewer;
    }

    public void dispose() {
        this.fTypeHierarchy.removeChangedListener(this.fTypeHierarchyLifeCycleListener);
    }

    public Object getParent(Object object) {
        if (object instanceof IMember) {
            IMember iMember = (IMember)object;
            if (iMember.getElementType() == 7) {
                return this.getParentType((IType)iMember);
            }
            return iMember.getDeclaringType();
        }
        return null;
    }

    protected final boolean isAnonymous(IType iType) {
        return iType.getElementName().length() == 0;
    }

    protected final boolean isAnonymousFromInterface(IType iType) {
        return this.isAnonymous(iType) && this.fTypeHierarchy.getHierarchy().getSuperInterfaces(iType).length != 0;
    }

    protected final boolean isObject(IType iType) {
        return "Object".equals(iType.getElementName()) && iType.getDeclaringType() == null && "java.lang".equals(iType.getPackageFragment().getElementName());
    }
}

