/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.util;

import com.ibm.icu.text.BreakIterator;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContext2;
import org.eclipse.help.IHelpResource;
import org.eclipse.jface.internal.text.html.HTML2TextReader;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.JavadocContentAccess;

public class JavadocHelpContext
implements IContext2 {
    private IHelpResource[] fHelpResources;
    private String fText;
    private String fTitle;
    private static final boolean BUG_85719_FIXED = false;

    public static void displayHelp(String string, Object[] objectArray) throws CoreException {
        Object object = HelpSystem.getContext((String)string);
        if (object != null) {
            if (objectArray != null && objectArray.length > 0) {
                object = new JavadocHelpContext((IContext)object, objectArray);
            }
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(object);
        }
    }

    public JavadocHelpContext(IContext iContext, Object[] objectArray) throws JavaModelException {
        IHelpResource[] iHelpResourceArray;
        Assert.isNotNull((Object)objectArray);
        if (iContext instanceof IContext2) {
            this.fTitle = ((IContext2)iContext).getTitle();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            Object object;
            if (objectArray[n] instanceof IJavaElement && ActionUtil.isOnBuildPath(object = (IJavaElement)objectArray[n])) {
                Object object2;
                URL uRL = JavaUI.getJavadocLocation(object, true);
                if ((uRL == null || this.doesNotExist(uRL)) && (object2 = JavaModelUtil.getPackageFragmentRoot(object)) != null) {
                    uRL = JavaUI.getJavadocBaseLocation(object);
                    object = object2.getKind() == 1 ? object.getJavaProject() : object2;
                    uRL = JavaUI.getJavadocLocation(object, false);
                }
                if (uRL != null) {
                    object2 = new JavaUIHelpResource((IJavaElement)object, this.getURLString(uRL));
                    arrayList.add(object2);
                }
            }
            ++n;
        }
        if (iContext != null && (iHelpResourceArray = iContext.getRelatedTopics()) != null) {
            int n2 = 0;
            while (n2 < iHelpResourceArray.length) {
                arrayList.add(iHelpResourceArray[n2]);
                ++n2;
            }
        }
        this.fHelpResources = arrayList.toArray(new IHelpResource[arrayList.size()]);
        if (iContext != null) {
            this.fText = iContext.getText();
        }
        if (this.fText == null) {
            this.fText = "";
        }
    }

    private String getURLString(URL uRL) {
        int n;
        String string = uRL.toExternalForm();
        if (uRL.getRef() != null && (n = string.lastIndexOf(35)) != -1) {
            return String.valueOf(string.substring(0, n)) + "?noframes=true" + string.substring(n);
        }
        return String.valueOf(string) + "?noframes=true";
    }

    private boolean doesNotExist(URL uRL) {
        if (uRL.getProtocol().equals("file")) {
            File file = new File(uRL.getFile());
            return !file.exists();
        }
        return false;
    }

    private String retrieveText(IJavaElement iJavaElement) throws JavaModelException {
        if (iJavaElement instanceof IMember) {
            Reader reader = JavadocContentAccess.getHTMLContentReader((IMember)iJavaElement, true, true);
            if (reader != null) {
                reader = new HTML2TextReader(reader, null);
            }
            if (reader != null) {
                String string = JavadocHelpContext.getString(reader);
                BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                breakIterator.setText(string);
                return string.substring(0, breakIterator.next());
            }
        }
        return "";
    }

    private static String getString(Reader reader) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        try {
            int n;
            while ((n = reader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return stringBuffer.toString();
    }

    public IHelpResource[] getRelatedTopics() {
        return this.fHelpResources;
    }

    public String getText() {
        return this.fText;
    }

    public String getStyledText() {
        return this.fText;
    }

    public String getCategory(IHelpResource iHelpResource) {
        if (iHelpResource instanceof JavaUIHelpResource) {
            return JavaUIMessages.JavaUIHelpContext_javaHelpCategory_label;
        }
        return null;
    }

    public String getTitle() {
        return this.fTitle;
    }

    private static class JavaUIHelpResource
    implements IHelpResource {
        private IJavaElement fElement;
        private String fUrl;

        public JavaUIHelpResource(IJavaElement iJavaElement, String string) {
            this.fElement = iJavaElement;
            this.fUrl = string;
        }

        public String getHref() {
            return this.fUrl;
        }

        public String getLabel() {
            String string = JavaElementLabels.getTextLabel(this.fElement, JavaElementLabels.ALL_DEFAULT | JavaElementLabels.ALL_FULLY_QUALIFIED);
            return Messages.format(JavaUIMessages.JavaUIHelp_link_label, string);
        }
    }
}

