/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ColoredString {
    public static final Style DEFAULT_STYLE = null;
    private StringBuffer fBuffer = new StringBuffer();
    private ArrayList fRanges = null;

    public ColoredString() {
    }

    public ColoredString(String string) {
        this(string, DEFAULT_STYLE);
    }

    public ColoredString(String string, Style style) {
        this();
        this.append(string, style);
    }

    public String getString() {
        return this.fBuffer.toString();
    }

    public int length() {
        return this.fBuffer.length();
    }

    public Iterator getRanges() {
        if (!this.hasRanges()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.getRangesList().iterator();
    }

    public ColoredString append(String string) {
        return this.append(string, DEFAULT_STYLE);
    }

    public ColoredString append(char c) {
        return this.append(String.valueOf(c), DEFAULT_STYLE);
    }

    public ColoredString append(ColoredString coloredString) {
        int n = this.fBuffer.length();
        this.fBuffer.append(coloredString.getString());
        Iterator iterator = coloredString.getRanges();
        while (iterator.hasNext()) {
            StyleRange styleRange = (StyleRange)iterator.next();
            this.addRange(new StyleRange(n + styleRange.offset, styleRange.length, styleRange.style));
        }
        return this;
    }

    public ColoredString append(String string, Style style) {
        if (string.length() == 0) {
            return this;
        }
        int n = this.fBuffer.length();
        this.fBuffer.append(string);
        if (style != null) {
            int n2 = this.getNumberOfRanges();
            if (n2 > 0) {
                StyleRange styleRange = this.getRange(n2 - 1);
                if (styleRange.offset + styleRange.length == n && style.equals(styleRange.style)) {
                    styleRange.length += string.length();
                    return this;
                }
            }
            this.addRange(new StyleRange(n, string.length(), style));
        }
        return this;
    }

    public void colorize(int n, int n2, Style style) {
        if (n < 0 || n + n2 > this.fBuffer.length()) {
            throw new IllegalArgumentException("Invalid offset (" + n + ") or length (" + n2 + ")");
        }
        int n3 = 0;
        int n4 = this.getNumberOfRanges();
        int n5 = 0;
        while (n5 < n4) {
            StyleRange styleRange = this.getRange(n5);
            if (styleRange.offset + styleRange.length <= n) {
                n3 = n5 + 1;
            }
            ++n5;
        }
        if (n3 < n4) {
            StyleRange styleRange = this.getRange(n3);
            if (styleRange.offset > n + n2) {
                throw new IllegalArgumentException("Overlapping ranges");
            }
        }
        this.addRange(n3, new StyleRange(n, n2, style));
    }

    public String toString() {
        return this.fBuffer.toString();
    }

    private boolean hasRanges() {
        return this.fRanges != null && !this.fRanges.isEmpty();
    }

    private int getNumberOfRanges() {
        return this.fRanges == null ? 0 : this.fRanges.size();
    }

    private StyleRange getRange(int n) {
        if (this.fRanges != null) {
            return (StyleRange)this.fRanges.get(n);
        }
        throw new IndexOutOfBoundsException();
    }

    private void addRange(StyleRange styleRange) {
        this.getRangesList().add(styleRange);
    }

    private void addRange(int n, StyleRange styleRange) {
        this.getRangesList().add(n, styleRange);
    }

    private List getRangesList() {
        if (this.fRanges == null) {
            this.fRanges = new ArrayList(2);
        }
        return this.fRanges;
    }

    public static class Style {
        private final String fForegroundColorName;

        public Style(String string) {
            this.fForegroundColorName = string;
        }

        public String getForegroundColorName() {
            return this.fForegroundColorName;
        }
    }

    public static class StyleRange {
        public int offset;
        public int length;
        public Style style;

        public StyleRange(int n, int n2, Style style) {
            this.offset = n;
            this.length = n2;
            this.style = style;
        }
    }
}

