/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import java.util.ArrayList;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredJavaElementLabels;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredString;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.IRichLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.StorageLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class JavaUILabelProvider
implements ILabelProvider,
IColorProvider,
IRichLabelProvider {
    protected ListenerList fListeners = new ListenerList();
    protected JavaElementImageProvider fImageLabelProvider = new JavaElementImageProvider();
    protected StorageLabelProvider fStorageLabelProvider = new StorageLabelProvider();
    private ArrayList fLabelDecorators = null;
    private int fImageFlags;
    private long fTextFlags;

    public JavaUILabelProvider() {
        this(JavaElementLabels.ALL_DEFAULT, 1);
    }

    public JavaUILabelProvider(long l, int n) {
        this.fImageFlags = n;
        this.fTextFlags = l;
    }

    public void addLabelDecorator(ILabelDecorator iLabelDecorator) {
        if (this.fLabelDecorators == null) {
            this.fLabelDecorators = new ArrayList(2);
        }
        this.fLabelDecorators.add(iLabelDecorator);
    }

    public final void setTextFlags(long l) {
        this.fTextFlags = l;
    }

    public final void setImageFlags(int n) {
        this.fImageFlags = n;
    }

    public final int getImageFlags() {
        return this.fImageFlags;
    }

    public final long getTextFlags() {
        return this.fTextFlags;
    }

    protected int evaluateImageFlags(Object object) {
        return this.getImageFlags();
    }

    protected long evaluateTextFlags(Object object) {
        return this.getTextFlags();
    }

    protected Image decorateImage(Image image, Object object) {
        if (this.fLabelDecorators != null && image != null) {
            int n = 0;
            while (n < this.fLabelDecorators.size()) {
                ILabelDecorator iLabelDecorator = (ILabelDecorator)this.fLabelDecorators.get(n);
                image = iLabelDecorator.decorateImage(image, object);
                ++n;
            }
        }
        return image;
    }

    public Image getImage(Object object) {
        Image image = this.fImageLabelProvider.getImageLabel(object, this.evaluateImageFlags(object));
        if (image == null && object instanceof IStorage) {
            image = this.fStorageLabelProvider.getImage(object);
        }
        return this.decorateImage(image, object);
    }

    protected String decorateText(String string, Object object) {
        if (this.fLabelDecorators != null && string.length() > 0) {
            int n = 0;
            while (n < this.fLabelDecorators.size()) {
                ILabelDecorator iLabelDecorator = (ILabelDecorator)this.fLabelDecorators.get(n);
                String string2 = iLabelDecorator.decorateText(string, object);
                if (string2 != null) {
                    string = string2;
                }
                ++n;
            }
        }
        return string;
    }

    public String getText(Object object) {
        String string = JavaElementLabels.getTextLabel(object, this.evaluateTextFlags(object));
        if (string.length() == 0 && object instanceof IStorage) {
            string = this.fStorageLabelProvider.getText(object);
        }
        return this.decorateText(string, object);
    }

    public ColoredString getRichTextLabel(Object object) {
        String string;
        ColoredString coloredString = ColoredJavaElementLabels.getTextLabel(object, this.evaluateTextFlags(object) | 0x80000000000000L);
        if (coloredString.length() == 0 && object instanceof IStorage) {
            coloredString = new ColoredString(this.fStorageLabelProvider.getText(object));
        }
        if ((string = this.decorateText(coloredString.getString(), object)) != null) {
            return ColoredJavaElementLabels.decorateColoredString(coloredString, string, ColoredJavaElementLabels.DECORATIONS_STYLE);
        }
        return coloredString;
    }

    public void dispose() {
        if (this.fLabelDecorators != null) {
            int n = 0;
            while (n < this.fLabelDecorators.size()) {
                ILabelDecorator iLabelDecorator = (ILabelDecorator)this.fLabelDecorators.get(n);
                iLabelDecorator.dispose();
                ++n;
            }
            this.fLabelDecorators = null;
        }
        this.fStorageLabelProvider.dispose();
        this.fImageLabelProvider.dispose();
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        if (this.fLabelDecorators != null) {
            int n = 0;
            while (n < this.fLabelDecorators.size()) {
                ILabelDecorator iLabelDecorator = (ILabelDecorator)this.fLabelDecorators.get(n);
                iLabelDecorator.addListener(iLabelProviderListener);
                ++n;
            }
        }
        this.fListeners.add((Object)iLabelProviderListener);
    }

    public boolean isLabelProperty(Object object, String string) {
        return true;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        if (this.fLabelDecorators != null) {
            int n = 0;
            while (n < this.fLabelDecorators.size()) {
                ILabelDecorator iLabelDecorator = (ILabelDecorator)this.fLabelDecorators.get(n);
                iLabelDecorator.removeListener(iLabelProviderListener);
                ++n;
            }
        }
        this.fListeners.remove((Object)iLabelProviderListener);
    }

    public static ILabelDecorator[] getDecorators(boolean bl, ILabelDecorator iLabelDecorator) {
        if (bl) {
            if (iLabelDecorator == null) {
                return new ILabelDecorator[0];
            }
            return new ILabelDecorator[]{iLabelDecorator};
        }
        if (iLabelDecorator != null) {
            return new ILabelDecorator[]{iLabelDecorator};
        }
        return null;
    }

    public Color getForeground(Object object) {
        return null;
    }

    public Color getBackground(Object object) {
        return null;
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent labelProviderChangedEvent) {
        Object[] objectArray = this.fListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final ILabelProviderListener iLabelProviderListener = (ILabelProviderListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iLabelProviderListener.labelProviderChanged(labelProviderChangedEvent);
                }
            });
            ++n;
        }
    }
}

