/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.util.CoreUtility;
import org.eclipse.wst.jsdt.ui.actions.AbstractOpenWizardAction;
import org.eclipse.wst.jsdt.ui.actions.OpenNewClassWizardAction;
import org.osgi.framework.Bundle;

public class NewTypeDropDownAction
extends Action
implements IMenuCreator,
IWorkbenchWindowPulldownDelegate2 {
    private static final String TAG_WIZARD = "wizard";
    private static final String ATT_JAVATYPE = "javatype";
    private static final String TAG_PARAMETER = "parameter";
    private static final String TAG_NAME = "name";
    private static final String TAG_VALUE = "value";
    private static final String PL_NEW = "newWizards";
    private static final String TAG_CLASS = "class";
    private Menu fMenu = null;
    private Shell fWizardShell;

    public NewTypeDropDownAction() {
        this.setMenuCreator(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.open_class_wizard_action");
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Menu menu) {
        return null;
    }

    public Menu getMenu(Control control) {
        if (this.fMenu == null) {
            this.fMenu = new Menu(control);
            OpenTypeWizardAction[] openTypeWizardActionArray = NewTypeDropDownAction.getActionFromDescriptors();
            int n = 0;
            while (n < openTypeWizardActionArray.length) {
                OpenTypeWizardAction openTypeWizardAction = openTypeWizardActionArray[n];
                openTypeWizardAction.setShell(this.fWizardShell);
                ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)openTypeWizardAction);
                actionContributionItem.fill(this.fMenu, -1);
                ++n;
            }
        }
        return this.fMenu;
    }

    public void run() {
        new OpenNewClassWizardAction().run();
    }

    public static OpenTypeWizardAction[] getActionFromDescriptors() {
        ArrayList<OpenTypeWizardAction> arrayList = new ArrayList<OpenTypeWizardAction>();
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", PL_NEW);
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                if (iConfigurationElement.getName().equals(TAG_WIZARD) && NewTypeDropDownAction.isJavaTypeWizard(iConfigurationElement)) {
                    arrayList.add(new OpenTypeWizardAction(iConfigurationElement));
                }
                ++n;
            }
        }
        return arrayList.toArray(new OpenTypeWizardAction[arrayList.size()]);
    }

    private static boolean isJavaTypeWizard(IConfigurationElement iConfigurationElement) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren(TAG_CLASS);
        if (iConfigurationElementArray.length > 0) {
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[n].getChildren(TAG_PARAMETER);
                int n2 = 0;
                while (n2 < iConfigurationElementArray2.length) {
                    IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[n2];
                    if (ATT_JAVATYPE.equals(iConfigurationElement2.getAttribute(TAG_NAME))) {
                        return Boolean.valueOf(iConfigurationElement2.getAttribute(TAG_VALUE));
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return Boolean.valueOf(iConfigurationElement.getAttribute(ATT_JAVATYPE)) != false;
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.fWizardShell = iWorkbenchWindow.getShell();
    }

    public void run(IAction iAction) {
        this.run();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public static class OpenTypeWizardAction
    extends AbstractOpenWizardAction {
        private static final String ATT_NAME = "name";
        private static final String ATT_CLASS = "class";
        private static final String ATT_ICON = "icon";
        private static final String TAG_DESCRIPTION = "description";
        private IConfigurationElement fConfigurationElement;

        public OpenTypeWizardAction(IConfigurationElement iConfigurationElement) {
            this.fConfigurationElement = iConfigurationElement;
            this.setText(iConfigurationElement.getAttribute("name"));
            String string = this.getDescriptionFromConfig(this.fConfigurationElement);
            this.setDescription(string);
            this.setToolTipText(string);
            this.setImageDescriptor(this.getIconFromConfig(this.fConfigurationElement));
        }

        private String getDescriptionFromConfig(IConfigurationElement iConfigurationElement) {
            IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren(TAG_DESCRIPTION);
            if (iConfigurationElementArray.length >= 1) {
                return iConfigurationElementArray[0].getValue();
            }
            return "";
        }

        private ImageDescriptor getIconFromConfig(IConfigurationElement iConfigurationElement) {
            String string = iConfigurationElement.getAttribute(ATT_ICON);
            if (string != null) {
                Bundle bundle = Platform.getBundle((String)iConfigurationElement.getContributor().getName());
                return JavaPluginImages.createImageDescriptor(bundle, (IPath)new Path(string), true);
            }
            return null;
        }

        protected INewWizard createWizard() throws CoreException {
            return (INewWizard)CoreUtility.createExtension(this.fConfigurationElement, "class");
        }
    }
}

