/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.ClasspathContainerInitializer;
import org.eclipse.wst.jsdt.core.IClasspathAttribute;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;

public class BuildPathSupport {
    public static final String JRE_PREF_PAGE_ID = "org.eclipse.wst.jsdt.debug.ui.preferences.VMPreferencePage";

    private BuildPathSupport() {
    }

    public static String getDeprecationMessage(String string) {
        String string2 = JavaCore.getClasspathVariableDeprecationMessage((String)string);
        if (string2 == null) {
            return null;
        }
        return Messages.format(NewWizardMessages.BuildPathSupport_deprecated, new Object[]{string, string2});
    }

    public static IPath guessSourceAttachment(CPListElement cPListElement) {
        if (cPListElement.getEntryKind() == 5) {
            return null;
        }
        IJavaProject iJavaProject = cPListElement.getJavaProject();
        try {
            IJavaModel iJavaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            IJavaProject[] iJavaProjectArray = iJavaModel.getJavaProjects();
            int n = 0;
            while (n < iJavaProjectArray.length) {
                IJavaProject iJavaProject2 = iJavaProjectArray[n];
                if (!iJavaProject2.equals(iJavaProject)) {
                    IClasspathEntry[] iClasspathEntryArray = iJavaProject2.getRawClasspath();
                    int n2 = 0;
                    while (n2 < iClasspathEntryArray.length) {
                        IPath iPath;
                        IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
                        if (iClasspathEntry.getEntryKind() == cPListElement.getEntryKind() && iClasspathEntry.getPath().equals((Object)cPListElement.getPath()) && (iPath = iClasspathEntry.getSourceAttachmentPath()) != null && !iPath.isEmpty()) {
                            return iPath;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException.getStatus());
        }
        return null;
    }

    public static String guessJavadocLocation(CPListElement cPListElement) {
        if (cPListElement.getEntryKind() == 5) {
            return null;
        }
        IJavaProject iJavaProject = cPListElement.getJavaProject();
        try {
            IJavaModel iJavaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            IJavaProject[] iJavaProjectArray = iJavaModel.getJavaProjects();
            int n = 0;
            while (n < iJavaProjectArray.length) {
                IJavaProject iJavaProject2 = iJavaProjectArray[n];
                if (!iJavaProject2.equals(iJavaProject)) {
                    IClasspathEntry[] iClasspathEntryArray = iJavaProject2.getRawClasspath();
                    int n2 = 0;
                    while (n2 < iClasspathEntryArray.length) {
                        IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
                        if (iClasspathEntry.getEntryKind() == cPListElement.getEntryKind() && iClasspathEntry.getPath().equals((Object)cPListElement.getPath())) {
                            IClasspathAttribute[] iClasspathAttributeArray = iClasspathEntry.getExtraAttributes();
                            int n3 = 0;
                            while (n3 < iClasspathAttributeArray.length) {
                                IClasspathAttribute iClasspathAttribute = iClasspathAttributeArray[n3];
                                if ("javadoc_location".equals(iClasspathAttribute.getName())) {
                                    return iClasspathAttribute.getValue();
                                }
                                ++n3;
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException.getStatus());
        }
        return null;
    }

    public static void modifyClasspathEntry(Shell shell, IClasspathEntry iClasspathEntry, String[] stringArray, IJavaProject iJavaProject, IPath iPath, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iPath != null) {
            BuildPathSupport.updateContainerClasspath(iJavaProject, iPath, iClasspathEntry, stringArray, iProgressMonitor);
        } else {
            BuildPathSupport.updateProjectClasspath(shell, iJavaProject, iClasspathEntry, stringArray, iProgressMonitor);
        }
    }

    public static void modifyClasspathEntry(Shell shell, IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, IPath iPath, IProgressMonitor iProgressMonitor) throws CoreException {
        BuildPathSupport.modifyClasspathEntry(shell, iClasspathEntry, null, iJavaProject, iPath, iProgressMonitor);
    }

    private static void updateContainerClasspath(IJavaProject iJavaProject, IPath iPath, IClasspathEntry iClasspathEntry, String[] stringArray, IProgressMonitor iProgressMonitor) throws CoreException {
        IClasspathContainer iClasspathContainer = JavaCore.getClasspathContainer((IPath)iPath, (IJavaProject)iJavaProject);
        if (iClasspathContainer == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 4, "Container " + iPath + " cannot be resolved", null));
        }
        IClasspathEntry[] iClasspathEntryArray = iClasspathContainer.getClasspathEntries();
        IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[iClasspathEntryArray.length];
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            IClasspathEntry iClasspathEntry2 = iClasspathEntryArray[n];
            iClasspathEntryArray2[n] = iClasspathEntry2.getEntryKind() == iClasspathEntry.getEntryKind() && iClasspathEntry2.getPath().equals((Object)iClasspathEntry.getPath()) ? BuildPathSupport.getUpdatedEntry(iClasspathEntry2, iClasspathEntry, stringArray, iJavaProject) : iClasspathEntry2;
            ++n;
        }
        BuildPathSupport.requestContainerUpdate(iJavaProject, iClasspathContainer, iClasspathEntryArray2);
        iProgressMonitor.worked(1);
    }

    private static IClasspathEntry getUpdatedEntry(IClasspathEntry iClasspathEntry, IClasspathEntry iClasspathEntry2, String[] stringArray, IJavaProject iJavaProject) {
        if (stringArray == null) {
            return iClasspathEntry2;
        }
        CPListElement cPListElement = CPListElement.createFromExisting(iClasspathEntry, iJavaProject);
        CPListElement cPListElement2 = CPListElement.createFromExisting(iClasspathEntry2, iJavaProject);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            cPListElement.setAttribute(string, cPListElement2.getAttribute(string));
            ++n;
        }
        return cPListElement.getClasspathEntry();
    }

    public static void requestContainerUpdate(IJavaProject iJavaProject, IClasspathContainer iClasspathContainer, IClasspathEntry[] iClasspathEntryArray) throws CoreException {
        IPath iPath = iClasspathContainer.getPath();
        UpdatedClasspathContainer updatedClasspathContainer = new UpdatedClasspathContainer(iClasspathContainer, iClasspathEntryArray);
        ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer((String)iPath.segment(0));
        if (classpathContainerInitializer != null) {
            classpathContainerInitializer.requestClasspathContainerUpdate(iPath, iJavaProject, (IClasspathContainer)updatedClasspathContainer);
        }
    }

    private static void updateProjectClasspath(Shell shell, IJavaProject iJavaProject, IClasspathEntry iClasspathEntry, String[] stringArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>(n + 1);
        int n2 = iClasspathEntry.getEntryKind();
        IPath iPath = iClasspathEntry.getPath();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n) {
            IClasspathEntry iClasspathEntry2 = iClasspathEntryArray[n3];
            if (iClasspathEntry2.getEntryKind() == n2 && iClasspathEntry2.getPath().equals((Object)iPath)) {
                arrayList.add(BuildPathSupport.getUpdatedEntry(iClasspathEntry2, iClasspathEntry, stringArray, iJavaProject));
                bl = true;
            } else {
                arrayList.add(iClasspathEntry2);
            }
            ++n3;
        }
        if (!bl) {
            if (!BuildPathSupport.putJarOnClasspathDialog(shell)) {
                return;
            }
            arrayList.add(iClasspathEntry);
        }
        IClasspathEntry[] iClasspathEntryArray2 = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
        iJavaProject.setRawClasspath(iClasspathEntryArray2, iProgressMonitor);
    }

    private static boolean putJarOnClasspathDialog(final Shell shell) {
        if (shell == null) {
            return false;
        }
        final boolean[] blArray = new boolean[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                String string = NewWizardMessages.BuildPathSupport_putoncpdialog_title;
                String string2 = NewWizardMessages.BuildPathSupport_putoncpdialog_message;
                blArray[0] = MessageDialog.openQuestion((Shell)shell, (String)string, (String)string2);
            }
        });
        return blArray[0];
    }

    private static class UpdatedClasspathContainer
    implements IClasspathContainer {
        private IClasspathEntry[] fNewEntries;
        private IClasspathContainer fOriginal;

        public UpdatedClasspathContainer(IClasspathContainer iClasspathContainer, IClasspathEntry[] iClasspathEntryArray) {
            this.fNewEntries = iClasspathEntryArray;
            this.fOriginal = iClasspathContainer;
        }

        public IClasspathEntry[] getClasspathEntries() {
            return this.fNewEntries;
        }

        public String getDescription() {
            return this.fOriginal.getDescription();
        }

        public int getKind() {
            return this.fOriginal.getKind();
        }

        public IPath getPath() {
            return this.fOriginal.getPath();
        }
    }
}

