/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.jsdt.core.IClasspathAttribute;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.ui.wizards.ClasspathAttributeConfiguration;

public class CPListElementAttribute {
    private CPListElement fParent;
    private String fKey;
    private Object fValue;
    private final boolean fBuiltIn;
    private IStatus fStatus;
    private ClasspathAttributeConfiguration.ClasspathAttributeAccess fCachedAccess;

    public CPListElementAttribute(CPListElement cPListElement, String string, Object object, boolean bl) {
        this.fKey = string;
        this.fValue = object;
        this.fParent = cPListElement;
        this.fBuiltIn = bl;
        if (!bl) {
            Assert.isTrue((object instanceof String || object == null ? 1 : 0) != 0);
        }
        this.fStatus = this.getContainerChildStatus();
    }

    private CPListElementAttribute(boolean bl) {
        this.fBuiltIn = bl;
    }

    public IClasspathAttribute getClasspathAttribute() {
        Assert.isTrue((!this.fBuiltIn ? 1 : 0) != 0);
        return JavaCore.newClasspathAttribute((String)this.fKey, (String)((String)this.fValue));
    }

    public CPListElement getParent() {
        return this.fParent;
    }

    public boolean isBuiltIn() {
        return this.fBuiltIn;
    }

    public boolean isNonModifiable() {
        return this.fStatus != null && !this.fStatus.isOK();
    }

    public boolean isNotSupported() {
        return this.fStatus != null && this.fStatus.getCode() == 1;
    }

    private IStatus getContainerChildStatus() {
        return this.fParent.getContainerChildStatus(this);
    }

    public String getKey() {
        return this.fKey;
    }

    public Object getValue() {
        return this.fValue;
    }

    public void setValue(Object object) {
        this.fValue = object;
        this.fCachedAccess = null;
        this.getParent().attributeChanged(this.fKey);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CPListElementAttribute)) {
            return false;
        }
        CPListElementAttribute cPListElementAttribute = (CPListElementAttribute)object;
        return cPListElementAttribute.fKey == this.fKey && cPListElementAttribute.getParent().getPath().equals((Object)this.fParent.getPath());
    }

    public CPListElementAttribute copy() {
        CPListElementAttribute cPListElementAttribute = new CPListElementAttribute(this.fBuiltIn);
        cPListElementAttribute.fParent = this.fParent;
        cPListElementAttribute.fKey = this.fKey;
        cPListElementAttribute.fValue = this.fValue;
        cPListElementAttribute.fStatus = this.fStatus;
        return cPListElementAttribute;
    }

    public ClasspathAttributeConfiguration.ClasspathAttributeAccess getClasspathAttributeAccess() {
        if (this.fCachedAccess == null) {
            this.fCachedAccess = new ClasspathAttributeConfiguration.ClasspathAttributeAccess(){

                public IClasspathAttribute getClasspathAttribute() {
                    return CPListElementAttribute.this.getClasspathAttribute();
                }

                public IJavaProject getJavaProject() {
                    return CPListElementAttribute.this.getParent().getJavaProject();
                }

                public IClasspathEntry getParentClasspassEntry() {
                    return CPListElementAttribute.this.getParent().getClasspathEntry();
                }
            };
        }
        return this.fCachedAccess;
    }
}

