/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ClasspathContainerDefaultPage;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ClasspathContainerDescriptor;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ClasspathContainerSelectionPage;
import org.eclipse.wst.jsdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.wst.jsdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.wst.jsdt.ui.wizards.IClasspathContainerPageExtension2;

public class ClasspathContainerWizard
extends Wizard {
    private ClasspathContainerDescriptor fPageDesc;
    private IClasspathEntry fEntryToEdit;
    private IClasspathEntry[] fNewEntries;
    private IClasspathContainerPage fContainerPage;
    private IJavaProject fCurrProject;
    private IClasspathEntry[] fCurrClasspath;
    private ClasspathContainerSelectionPage fSelectionWizardPage;

    public ClasspathContainerWizard(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, IClasspathEntry[] iClasspathEntryArray) {
        this(iClasspathEntry, null, iJavaProject, iClasspathEntryArray);
    }

    public ClasspathContainerWizard(ClasspathContainerDescriptor classpathContainerDescriptor, IJavaProject iJavaProject, IClasspathEntry[] iClasspathEntryArray) {
        this(null, classpathContainerDescriptor, iJavaProject, iClasspathEntryArray);
    }

    private ClasspathContainerWizard(IClasspathEntry iClasspathEntry, ClasspathContainerDescriptor classpathContainerDescriptor, IJavaProject iJavaProject, IClasspathEntry[] iClasspathEntryArray) {
        this.fEntryToEdit = iClasspathEntry;
        this.fPageDesc = classpathContainerDescriptor;
        this.fNewEntries = null;
        this.fCurrProject = iJavaProject;
        this.fCurrClasspath = iClasspathEntryArray;
        String string = iClasspathEntry == null ? NewWizardMessages.ClasspathContainerWizard_new_title : NewWizardMessages.ClasspathContainerWizard_edit_title;
        this.setWindowTitle(string);
    }

    public IClasspathEntry[] getNewEntries() {
        return this.fNewEntries;
    }

    public boolean performFinish() {
        if (this.fContainerPage != null && this.fContainerPage.finish()) {
            if (this.fEntryToEdit == null && this.fContainerPage instanceof IClasspathContainerPageExtension2) {
                this.fNewEntries = ((IClasspathContainerPageExtension2)((Object)this.fContainerPage)).getNewContainers();
            } else {
                IClasspathEntry[] iClasspathEntryArray;
                IClasspathEntry iClasspathEntry = this.fContainerPage.getSelection();
                if (iClasspathEntry != null) {
                    IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[1];
                    iClasspathEntryArray = iClasspathEntryArray2;
                    iClasspathEntryArray2[0] = iClasspathEntry;
                } else {
                    iClasspathEntryArray = null;
                }
                this.fNewEntries = iClasspathEntryArray;
            }
            return true;
        }
        return false;
    }

    public void addPages() {
        if (this.fPageDesc != null) {
            this.fContainerPage = this.getContainerPage(this.fPageDesc);
            this.addPage(this.fContainerPage);
        } else if (this.fEntryToEdit == null) {
            ClasspathContainerDescriptor[] classpathContainerDescriptorArray = ClasspathContainerDescriptor.getDescriptors();
            this.fSelectionWizardPage = new ClasspathContainerSelectionPage(classpathContainerDescriptorArray);
            this.addPage((IWizardPage)this.fSelectionWizardPage);
            this.fContainerPage = new ClasspathContainerDefaultPage();
            this.addPage(this.fContainerPage);
        } else {
            ClasspathContainerDescriptor[] classpathContainerDescriptorArray = ClasspathContainerDescriptor.getDescriptors();
            ClasspathContainerDescriptor classpathContainerDescriptor = this.findDescriptorPage(classpathContainerDescriptorArray, this.fEntryToEdit);
            this.fContainerPage = this.getContainerPage(classpathContainerDescriptor);
            this.addPage(this.fContainerPage);
        }
        super.addPages();
    }

    private IClasspathContainerPage getContainerPage(ClasspathContainerDescriptor classpathContainerDescriptor) {
        IClasspathContainerPage iClasspathContainerPage = null;
        if (classpathContainerDescriptor != null) {
            IClasspathContainerPage iClasspathContainerPage2 = classpathContainerDescriptor.getPage();
            if (iClasspathContainerPage2 != null) {
                return iClasspathContainerPage2;
            }
            try {
                iClasspathContainerPage = classpathContainerDescriptor.createPage();
            }
            catch (CoreException coreException) {
                this.handlePageCreationFailed(coreException);
                iClasspathContainerPage = null;
            }
        }
        if (iClasspathContainerPage == null) {
            iClasspathContainerPage = new ClasspathContainerDefaultPage();
            if (classpathContainerDescriptor != null) {
                classpathContainerDescriptor.setPage(iClasspathContainerPage);
            }
        }
        if (iClasspathContainerPage instanceof IClasspathContainerPageExtension) {
            ((IClasspathContainerPageExtension)((Object)iClasspathContainerPage)).initialize(this.fCurrProject, this.fCurrClasspath);
        }
        iClasspathContainerPage.setSelection(this.fEntryToEdit);
        iClasspathContainerPage.setWizard((IWizard)this);
        return iClasspathContainerPage;
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        if (iWizardPage == this.fSelectionWizardPage) {
            ClasspathContainerDescriptor classpathContainerDescriptor = this.fSelectionWizardPage.getSelected();
            this.fContainerPage = this.getContainerPage(classpathContainerDescriptor);
            return this.fContainerPage;
        }
        return super.getNextPage(iWizardPage);
    }

    private void handlePageCreationFailed(CoreException coreException) {
        String string = NewWizardMessages.ClasspathContainerWizard_pagecreationerror_title;
        String string2 = NewWizardMessages.ClasspathContainerWizard_pagecreationerror_message;
        ExceptionHandler.handle(coreException, this.getShell(), string, string2);
    }

    private ClasspathContainerDescriptor findDescriptorPage(ClasspathContainerDescriptor[] classpathContainerDescriptorArray, IClasspathEntry iClasspathEntry) {
        int n = 0;
        while (n < classpathContainerDescriptorArray.length) {
            if (classpathContainerDescriptorArray[n].canEdit(iClasspathEntry)) {
                return classpathContainerDescriptorArray[n];
            }
            ++n;
        }
        return null;
    }

    public void dispose() {
        if (this.fSelectionWizardPage != null) {
            ClasspathContainerDescriptor[] classpathContainerDescriptorArray = this.fSelectionWizardPage.getContainers();
            int n = 0;
            while (n < classpathContainerDescriptorArray.length) {
                classpathContainerDescriptorArray[n].dispose();
                ++n;
            }
        }
        super.dispose();
    }

    public boolean canFinish() {
        if (this.fSelectionWizardPage != null && !this.fContainerPage.isPageComplete()) {
            return false;
        }
        if (this.fContainerPage != null) {
            return this.fContainerPage.isPageComplete();
        }
        return false;
    }

    public static int openWizard(Shell shell, ClasspathContainerWizard classpathContainerWizard) {
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)classpathContainerWizard);
        PixelConverter pixelConverter = new PixelConverter(JFaceResources.getDialogFont());
        wizardDialog.setMinimumPageSize(pixelConverter.convertWidthInCharsToPixels(70), pixelConverter.convertHeightInCharsToPixels(20));
        wizardDialog.create();
        return wizardDialog.open();
    }
}

