/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.jarimport.JarImportWizard;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.AccessRulesDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.wst.jsdt.ui.wizards.BuildPathDialogAccess;

public class LibrariesWorkbookPage
extends BuildPathBasePage {
    private ListDialogField fClassPathList;
    private IJavaProject fCurrJProject;
    private TreeListDialogField fLibrariesList;
    private Control fSWTControl;
    private final IWorkbenchPreferenceContainer fPageContainer;
    private final int IDX_ADDLIB = 0;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;

    public LibrariesWorkbookPage(CheckedListDialogField checkedListDialogField, IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        this.fClassPathList = checkedListDialogField;
        this.fPageContainer = iWorkbenchPreferenceContainer;
        this.fSWTControl = null;
        String[] stringArray = new String[4];
        stringArray[0] = NewWizardMessages.LibrariesWorkbookPage_libraries_addlibrary_button;
        stringArray[2] = NewWizardMessages.LibrariesWorkbookPage_libraries_edit_button;
        stringArray[3] = NewWizardMessages.LibrariesWorkbookPage_libraries_remove_button;
        String[] stringArray2 = stringArray;
        LibrariesAdapter librariesAdapter = new LibrariesAdapter();
        this.fLibrariesList = new TreeListDialogField(librariesAdapter, stringArray2, (ILabelProvider)new CPListLabelProvider());
        this.fLibrariesList.setDialogFieldListener(librariesAdapter);
        this.fLibrariesList.setLabelText(NewWizardMessages.LibrariesWorkbookPage_libraries_label);
        this.fLibrariesList.enableButton(2, false);
        this.fLibrariesList.enableButton(3, false);
        this.fLibrariesList.setViewerComparator(new CPListElementSorter());
    }

    public void init(IJavaProject iJavaProject) {
        this.fCurrJProject = iJavaProject;
        if (Display.getCurrent() != null) {
            this.updateLibrariesList();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    LibrariesWorkbookPage.this.updateLibrariesList();
                }
            });
        }
    }

    private void updateLibrariesList() {
        List list = this.fClassPathList.getElements();
        ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>(list.size());
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            CPListElement cPListElement = (CPListElement)list.get(n2);
            if (this.isEntryKind(cPListElement.getEntryKind())) {
                arrayList.add(cPListElement);
            }
            ++n2;
        }
        this.fLibrariesList.setElements(arrayList);
    }

    public Control getControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fLibrariesList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fLibrariesList.getTreeControl(null));
        int n = pixelConverter.convertWidthInCharsToPixels(24);
        this.fLibrariesList.setButtonsMinWidth(n);
        this.fLibrariesList.setViewerComparator(new CPListElementSorter());
        this.fSWTControl = composite2;
        return composite2;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    private void libaryPageCustomButtonPressed(DialogField dialogField, int n) {
        Object[] objectArray = null;
        switch (n) {
            case 0: {
                objectArray = this.openContainerSelectionDialog(null);
                break;
            }
            case 2: {
                this.editEntry();
                return;
            }
            case 3: {
                this.removeEntry();
                return;
            }
        }
        if (objectArray != null) {
            int n2 = objectArray.length;
            List list = this.fLibrariesList.getElements();
            ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>(n2);
            int n3 = 0;
            while (n3 < n2) {
                CPListElement cPListElement = objectArray[n3];
                if (!list.contains(cPListElement) && !arrayList.contains(cPListElement)) {
                    arrayList.add(cPListElement);
                    cPListElement.setAttribute("sourcepath", BuildPathSupport.guessSourceAttachment(cPListElement));
                    cPListElement.setAttribute("javadoc_location", BuildPathSupport.guessJavadocLocation(cPListElement));
                }
                ++n3;
            }
            this.fLibrariesList.addElements(arrayList);
            if (n == 0) {
                this.fLibrariesList.refresh();
            }
            this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection(objectArray));
        }
    }

    public void addElement(CPListElement cPListElement) {
        this.fLibrariesList.addElement(cPListElement);
        this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection((Object)cPListElement));
    }

    protected void libaryPageDoubleClicked(TreeListDialogField treeListDialogField) {
        List list = this.fLibrariesList.getSelectedElements();
        if (this.canEdit(list)) {
            this.editEntry();
        }
    }

    protected void libaryPageKeyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
        List list;
        if (treeListDialogField == this.fLibrariesList && keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.canRemove(list = treeListDialogField.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private IPackageFragmentRoot getSelectedPackageFragmentRoot() {
        IJavaProject iJavaProject;
        CPListElement cPListElement;
        IClasspathEntry iClasspathEntry;
        Object e;
        List list = this.fLibrariesList.getSelectedElements();
        if (list.size() == 1 && (e = list.get(0)) instanceof CPListElement && JarImportWizard.isValidClassPathEntry(iClasspathEntry = (cPListElement = (CPListElement)e).getClasspathEntry()) && (iJavaProject = cPListElement.getJavaProject()) != null) {
            try {
                IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
                int n = 0;
                while (n < iPackageFragmentRootArray.length) {
                    if (iClasspathEntry.equals(iPackageFragmentRootArray[n].getRawClasspathEntry())) {
                        return iPackageFragmentRootArray[n];
                    }
                    ++n;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
        return null;
    }

    private void removeEntry() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        List list = this.fLibrariesList.getSelectedElements();
        HashMap<IAccessRule[], Object> hashMap = new HashMap<IAccessRule[], Object>();
        int n = list.size() - 1;
        while (n >= 0) {
            object5 = list.get(n);
            if (object5 instanceof CPListElementAttribute) {
                object4 = (CPListElementAttribute)object5;
                object3 = ((CPListElementAttribute)object4).getKey();
                if (((CPListElementAttribute)object4).isBuiltIn()) {
                    object2 = null;
                    if (((String)object3).equals("accessrules")) {
                        object2 = new IAccessRule[]{};
                    }
                    ((CPListElementAttribute)object4).setValue(object2);
                } else {
                    this.removeCustomAttribute((CPListElementAttribute)object4);
                }
                list.remove(n);
                if (((CPListElementAttribute)object4).getParent().getParentContainer() instanceof CPListElement) {
                    object2 = ((CPListElementAttribute)object4).getParent();
                    object = (HashSet)hashMap.get(object2);
                    if (object == null) {
                        object = new HashSet();
                        hashMap.put((IAccessRule[])object2, object);
                    }
                    ((HashSet)object).add(object3);
                }
            }
            --n;
        }
        if (list.isEmpty()) {
            this.fLibrariesList.refresh();
            this.fClassPathList.dialogFieldChanged();
        } else {
            this.fLibrariesList.removeElements(list);
        }
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object5 = iterator.next();
            object4 = (CPListElement)object5.getKey();
            object3 = (HashSet)object5.getValue();
            object2 = ((HashSet)object3).toArray(new String[((HashSet)object3).size()]);
            object = ((CPListElement)object4).getClasspathEntry();
            this.updateContainerEntry((IClasspathEntry)object, (String[])object2, this.fCurrJProject, ((CPListElement)((CPListElement)object4).getParentContainer()).getPath());
        }
    }

    private boolean canRemove(List list) {
        if (list.size() == 0) {
            return false;
        }
        int n = 0;
        while (n < list.size()) {
            Object object;
            Object e = list.get(n);
            if (e instanceof CPListElementAttribute) {
                object = (CPListElementAttribute)e;
                if (((CPListElementAttribute)object).isNonModifiable()) {
                    return false;
                }
                if (((CPListElementAttribute)object).isBuiltIn()) {
                    if (((CPListElementAttribute)object).getParent().isInContainer("org.eclipse.wst.jsdt.launching.JRE_CONTAINER") && "accessrules".equals(((CPListElementAttribute)object).getKey())) {
                        return false;
                    }
                    if (((CPListElementAttribute)object).getKey().equals("accessrules")) {
                        return ((IAccessRule[])((CPListElementAttribute)object).getValue()).length > 0;
                    }
                    if (((CPListElementAttribute)object).getValue() == null) {
                        return false;
                    }
                } else if (!this.canRemoveCustomAttribute((CPListElementAttribute)object)) {
                    return false;
                }
            } else {
                if (e instanceof CPListElement) {
                    object = (CPListElement)e;
                    return !((CPListElement)object).isInNonModifiableContainer();
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    private void editEntry() {
        List list = this.fLibrariesList.getSelectedElements();
        if (list.size() != 1) {
            return;
        }
        Object e = list.get(0);
        if (this.fLibrariesList.getIndexOfElement(e) != -1) {
            this.editElementEntry((CPListElement)e);
        } else if (e instanceof CPListElementAttribute) {
            this.editAttributeEntry((CPListElementAttribute)e);
        }
    }

    private void editAttributeEntry(CPListElementAttribute cPListElementAttribute) {
        String string = cPListElementAttribute.getKey();
        CPListElement cPListElement = cPListElementAttribute.getParent();
        if (string.equals("sourcepath")) {
            IClasspathEntry iClasspathEntry = BuildPathDialogAccess.configureSourceAttachment(this.getShell(), cPListElement.getClasspathEntry());
            if (iClasspathEntry != null) {
                cPListElement.setAttribute("sourcepath", iClasspathEntry.getSourceAttachmentPath());
                String[] stringArray = new String[]{"sourcepath"};
                this.attributeUpdated(cPListElement, stringArray);
                this.fLibrariesList.refresh(cPListElementAttribute);
                this.fLibrariesList.update(cPListElement);
                this.fClassPathList.refresh();
                this.updateEnabledState();
            }
        } else if (string.equals("accessrules")) {
            AccessRulesDialog accessRulesDialog = new AccessRulesDialog(this.getShell(), cPListElement, this.fCurrJProject, this.fPageContainer != null);
            int n = accessRulesDialog.open();
            if (n == 0 || n == 10) {
                cPListElement.setAttribute("accessrules", accessRulesDialog.getAccessRules());
                String[] stringArray = new String[]{"accessrules"};
                this.attributeUpdated(cPListElement, stringArray);
                this.fLibrariesList.refresh(cPListElementAttribute);
                this.fClassPathList.dialogFieldChanged();
                this.updateEnabledState();
                if (n == 10) {
                    accessRulesDialog.performPageSwitch(this.fPageContainer);
                }
            }
        } else if (this.editCustomAttribute(this.getShell(), cPListElementAttribute)) {
            String[] stringArray = new String[]{string};
            this.attributeUpdated(cPListElement, stringArray);
            this.fLibrariesList.refresh(cPListElementAttribute);
            this.fClassPathList.dialogFieldChanged();
            this.updateEnabledState();
        }
    }

    private void attributeUpdated(CPListElement cPListElement, String[] stringArray) {
        Object object = cPListElement.getParentContainer();
        if (object instanceof CPListElement) {
            IClasspathEntry iClasspathEntry = cPListElement.getClasspathEntry();
            this.updateContainerEntry(iClasspathEntry, stringArray, this.fCurrJProject, ((CPListElement)object).getPath());
        }
    }

    private void updateContainerEntry(final IClasspathEntry iClasspathEntry, final String[] stringArray, final IJavaProject iJavaProject, final IPath iPath) {
        try {
            IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    BuildPathSupport.modifyClasspathEntry(null, iClasspathEntry, stringArray, iJavaProject, iPath, iProgressMonitor);
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(iWorkspaceRunnable));
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = NewWizardMessages.LibrariesWorkbookPage_configurecontainer_error_title;
            String string2 = NewWizardMessages.LibrariesWorkbookPage_configurecontainer_error_message;
            ExceptionHandler.handle(invocationTargetException, this.getShell(), string, string2);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void editElementEntry(CPListElement cPListElement) {
        CPListElement[] cPListElementArray = null;
        switch (cPListElement.getEntryKind()) {
            case 5: {
                cPListElementArray = this.openContainerSelectionDialog(cPListElement);
                break;
            }
            case 1: {
                cPListElement.getResource();
            }
        }
        if (cPListElementArray != null && cPListElementArray.length > 0) {
            CPListElement cPListElement2 = cPListElementArray[0];
            cPListElement2.setExported(cPListElement.isExported());
            cPListElement2.setAttributesFromExisting(cPListElement);
            this.fLibrariesList.replaceElement(cPListElement, cPListElement2);
            if (cPListElement.getEntryKind() == 4) {
                this.fLibrariesList.refresh();
            }
        }
    }

    private void libaryPageSelectionChanged(DialogField dialogField) {
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        List list = this.fLibrariesList.getSelectedElements();
        this.fLibrariesList.enableButton(2, this.canEdit(list));
        this.fLibrariesList.enableButton(3, this.canRemove(list));
        boolean bl = this.containsOnlyTopLevelEntries(list);
        this.fLibrariesList.enableButton(0, bl);
    }

    private boolean canEdit(List list) {
        if (list.size() != 1) {
            return false;
        }
        Object e = list.get(0);
        if (e instanceof CPListElement) {
            CPListElement cPListElement = (CPListElement)e;
            return !cPListElement.isInNonModifiableContainer();
        }
        if (e instanceof CPListElementAttribute) {
            CPListElementAttribute cPListElementAttribute = (CPListElementAttribute)e;
            if (!cPListElementAttribute.isBuiltIn()) {
                return this.canEditCustomAttribute(cPListElementAttribute);
            }
            return true;
        }
        return false;
    }

    private void libaryPageDialogFieldChanged(DialogField dialogField) {
        if (this.fCurrJProject != null) {
            this.updateClasspathList();
        }
    }

    private void updateClasspathList() {
        int n;
        List list = this.fLibrariesList.getElements();
        List list2 = this.fClassPathList.getElements();
        int n2 = n = list2.size();
        int n3 = n - 1;
        while (n3 >= 0) {
            CPListElement cPListElement = (CPListElement)list2.get(n3);
            int n4 = cPListElement.getEntryKind();
            if (this.isEntryKind(n4) && !list.remove(cPListElement)) {
                list2.remove(n3);
                n2 = n3;
            }
            --n3;
        }
        list2.addAll(n2, list);
        if (n2 != n || !list.isEmpty()) {
            this.fClassPathList.setElements(list2);
        }
    }

    private IPath[] getUsedContainers(CPListElement cPListElement) {
        List list;
        ArrayList arrayList = new ArrayList();
        if (this.fCurrJProject.exists()) {
            try {
                list = this.fCurrJProject.getOutputLocation();
                if (list != null && list.segmentCount() > 1) {
                    arrayList.add(list);
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException.getStatus());
            }
        }
        list = this.fLibrariesList.getElements();
        int n = 0;
        while (n < list.size()) {
            IResource iResource;
            CPListElement cPListElement2 = (CPListElement)list.get(n);
            if (cPListElement2.getEntryKind() == 1 && cPListElement2 != cPListElement && (iResource = cPListElement2.getResource()) instanceof IContainer && !iResource.equals((Object)cPListElement)) {
                arrayList.add(iResource.getFullPath());
            }
            ++n;
        }
        return arrayList.toArray(new IPath[arrayList.size()]);
    }

    private CPListElement[] openContainerSelectionDialog(CPListElement cPListElement) {
        if (cPListElement == null) {
            IClasspathEntry[] iClasspathEntryArray = BuildPathDialogAccess.chooseContainerEntries(this.getShell(), this.fCurrJProject, this.getRawClasspath());
            if (iClasspathEntryArray != null) {
                CPListElement[] cPListElementArray = new CPListElement[iClasspathEntryArray.length];
                int n = 0;
                while (n < cPListElementArray.length) {
                    cPListElementArray[n] = new CPListElement(this.fCurrJProject, iClasspathEntryArray[n].getEntryKind(), iClasspathEntryArray[n].getPath(), null);
                    ++n;
                }
                return cPListElementArray;
            }
        } else {
            IClasspathEntry iClasspathEntry = BuildPathDialogAccess.configureContainerEntry(this.getShell(), cPListElement.getClasspathEntry(), this.fCurrJProject, this.getRawClasspath());
            if (iClasspathEntry != null) {
                CPListElement cPListElement2 = new CPListElement(this.fCurrJProject, iClasspathEntry.getEntryKind(), iClasspathEntry.getPath(), null);
                return new CPListElement[]{cPListElement2};
            }
        }
        return null;
    }

    private IClasspathEntry[] getRawClasspath() {
        IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[this.fClassPathList.getSize()];
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            CPListElement cPListElement = (CPListElement)this.fClassPathList.getElement(n);
            iClasspathEntryArray[n] = cPListElement.getClasspathEntry();
            ++n;
        }
        return iClasspathEntryArray;
    }

    public boolean isEntryKind(int n) {
        return n == 1 || n == 4 || n == 5;
    }

    public List getSelection() {
        return this.fLibrariesList.getSelectedElements();
    }

    public void setSelection(List list, boolean bl) {
        this.fLibrariesList.selectElements((ISelection)new StructuredSelection(list));
        if (bl) {
            int n = 0;
            while (n < list.size()) {
                this.fLibrariesList.expandElement(list.get(n), 1);
                ++n;
            }
        }
    }

    public void setFocus() {
        this.fLibrariesList.setFocus();
    }

    private class LibrariesAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        private LibrariesAdapter() {
        }

        public void customButtonPressed(TreeListDialogField treeListDialogField, int n) {
            LibrariesWorkbookPage.this.libaryPageCustomButtonPressed(treeListDialogField, n);
        }

        public void selectionChanged(TreeListDialogField treeListDialogField) {
            LibrariesWorkbookPage.this.libaryPageSelectionChanged(treeListDialogField);
        }

        public void doubleClicked(TreeListDialogField treeListDialogField) {
            LibrariesWorkbookPage.this.libaryPageDoubleClicked(treeListDialogField);
        }

        public void keyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
            LibrariesWorkbookPage.this.libaryPageKeyPressed(treeListDialogField, keyEvent);
        }

        public Object[] getChildren(TreeListDialogField treeListDialogField, Object object) {
            CPListElementAttribute cPListElementAttribute;
            if (object instanceof CPListElement) {
                return ((CPListElement)object).getChildren(false);
            }
            if (object instanceof CPListElementAttribute && "accessrules".equals((cPListElementAttribute = (CPListElementAttribute)object).getKey())) {
                return (IAccessRule[])cPListElementAttribute.getValue();
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField treeListDialogField, Object object) {
            return this.getChildren(treeListDialogField, object).length > 0;
        }

        public void dialogFieldChanged(DialogField dialogField) {
            LibrariesWorkbookPage.this.libaryPageDialogFieldChanged(dialogField);
        }
    }
}

