/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPVariableElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;

public class VariableCreationDialog
extends StatusDialog {
    private IDialogSettings fDialogSettings;
    private StringDialogField fNameField;
    private StatusInfo fNameStatus;
    private StringButtonDialogField fPathField;
    private StatusInfo fPathStatus;
    private SelectionButtonDialogField fDirButton;
    private CPVariableElement fElement;
    private List fExistingNames;

    public VariableCreationDialog(Shell shell, CPVariableElement cPVariableElement, List list) {
        super(shell);
        if (cPVariableElement == null) {
            this.setTitle(NewWizardMessages.VariableCreationDialog_titlenew);
        } else {
            this.setTitle(NewWizardMessages.VariableCreationDialog_titleedit);
        }
        this.fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        this.fElement = cPVariableElement;
        this.fNameStatus = new StatusInfo();
        this.fPathStatus = new StatusInfo();
        NewVariableAdapter newVariableAdapter = new NewVariableAdapter();
        this.fNameField = new StringDialogField();
        this.fNameField.setDialogFieldListener(newVariableAdapter);
        this.fNameField.setLabelText(NewWizardMessages.VariableCreationDialog_name_label);
        this.fPathField = new StringButtonDialogField(newVariableAdapter);
        this.fPathField.setDialogFieldListener(newVariableAdapter);
        this.fPathField.setLabelText(NewWizardMessages.VariableCreationDialog_path_label);
        this.fPathField.setButtonLabel(NewWizardMessages.VariableCreationDialog_path_file_button);
        this.fDirButton = new SelectionButtonDialogField(8);
        this.fDirButton.setDialogFieldListener(newVariableAdapter);
        this.fDirButton.setLabelText(NewWizardMessages.VariableCreationDialog_path_dir_button);
        this.fExistingNames = list;
        if (cPVariableElement != null) {
            this.fNameField.setText(cPVariableElement.getName());
            this.fPathField.setText(cPVariableElement.getPath().toString());
            this.fExistingNames.remove(cPVariableElement.getName());
        } else {
            this.fNameField.setText("");
            this.fPathField.setText("");
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.variable_creation_dialog_context");
    }

    public CPVariableElement getClasspathElement() {
        return new CPVariableElement(this.fNameField.getText(), (IPath)new Path(this.fPathField.getText()));
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setFont(composite2.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 3;
        composite3.setLayout((Layout)gridLayout);
        int n = this.convertWidthInCharsToPixels(50);
        this.fNameField.doFillIntoGrid(composite3, 2);
        LayoutUtil.setWidthHint((Control)this.fNameField.getTextControl(null), n);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        DialogField.createEmptySpace(composite3, 1);
        this.fPathField.doFillIntoGrid(composite3, 3);
        LayoutUtil.setWidthHint((Control)this.fPathField.getTextControl(null), n);
        DialogField.createEmptySpace(composite3, 2);
        this.fDirButton.doFillIntoGrid(composite3, 1);
        StringDialogField stringDialogField = this.fElement == null ? this.fNameField : this.fPathField;
        stringDialogField.postSetFocusOnDialogField(composite.getDisplay());
        VariableCreationDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void doChangeControlPressed(DialogField dialogField) {
        IPath iPath;
        if (dialogField == this.fPathField && (iPath = this.chooseExtJarFile()) != null) {
            this.fPathField.setText(iPath.toString());
        }
    }

    private void doFieldUpdated(DialogField dialogField) {
        IPath iPath;
        if (dialogField == this.fNameField) {
            this.fNameStatus = this.nameUpdated();
        } else if (dialogField == this.fPathField) {
            this.fPathStatus = this.pathUpdated();
        } else if (dialogField == this.fDirButton && (iPath = this.chooseExtDirectory()) != null) {
            this.fPathField.setText(iPath.toString());
        }
        this.updateStatus(StatusUtil.getMoreSevere(this.fPathStatus, this.fNameStatus));
    }

    private StatusInfo nameUpdated() {
        StatusInfo statusInfo = new StatusInfo();
        String string = this.fNameField.getText();
        if (string.length() == 0) {
            statusInfo.setError(NewWizardMessages.VariableCreationDialog_error_entername);
            return statusInfo;
        }
        if (string.trim().length() != string.length()) {
            statusInfo.setError(NewWizardMessages.VariableCreationDialog_error_whitespace);
        } else if (!Path.ROOT.isValidSegment(string)) {
            statusInfo.setError(NewWizardMessages.VariableCreationDialog_error_invalidname);
        } else if (this.nameConflict(string)) {
            statusInfo.setError(NewWizardMessages.VariableCreationDialog_error_nameexists);
        }
        return statusInfo;
    }

    private boolean nameConflict(String string) {
        if (this.fElement != null && this.fElement.getName().equals(string)) {
            return false;
        }
        int n = 0;
        while (n < this.fExistingNames.size()) {
            CPVariableElement cPVariableElement = (CPVariableElement)this.fExistingNames.get(n);
            if (string.equals(cPVariableElement.getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private StatusInfo pathUpdated() {
        StatusInfo statusInfo = new StatusInfo();
        String string = this.fPathField.getText();
        if (string.length() > 0) {
            if (!Path.ROOT.isValidPath(string)) {
                statusInfo.setError(NewWizardMessages.VariableCreationDialog_error_invalidpath);
            } else if (!new File(string).exists()) {
                statusInfo.setWarning(NewWizardMessages.VariableCreationDialog_warning_pathnotexists);
            }
        }
        return statusInfo;
    }

    private String getInitPath() {
        String string = this.fPathField.getText();
        if (string.length() == 0) {
            string = this.fDialogSettings.get("org.eclipse.wst.jsdt.ui.lastextjar");
            if (string == null) {
                string = "";
            }
        } else {
            Path path = new Path(string);
            if (ArchiveFileFilter.isArchivePath((IPath)path)) {
                path.removeLastSegments(1);
            }
            string = path.toOSString();
        }
        return string;
    }

    private IPath chooseExtJarFile() {
        String string = this.getInitPath();
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setText(NewWizardMessages.VariableCreationDialog_extjardialog_text);
        fileDialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        fileDialog.setFilterPath(string);
        String string2 = fileDialog.open();
        if (string2 != null) {
            this.fDialogSettings.put("org.eclipse.wst.jsdt.ui.lastextjar", fileDialog.getFilterPath());
            return Path.fromOSString((String)string2).makeAbsolute();
        }
        return null;
    }

    private IPath chooseExtDirectory() {
        String string = this.getInitPath();
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        directoryDialog.setText(NewWizardMessages.VariableCreationDialog_extdirdialog_text);
        directoryDialog.setMessage(NewWizardMessages.VariableCreationDialog_extdirdialog_message);
        directoryDialog.setFilterPath(string);
        String string2 = directoryDialog.open();
        if (string2 != null) {
            this.fDialogSettings.put("org.eclipse.wst.jsdt.ui.lastextjar", directoryDialog.getFilterPath());
            return Path.fromOSString((String)string2);
        }
        return null;
    }

    private class NewVariableAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private NewVariableAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            VariableCreationDialog.this.doFieldUpdated(dialogField);
        }

        public void changeControlPressed(DialogField dialogField) {
            VariableCreationDialog.this.doChangeControlPressed(dialogField);
        }
    }
}

