/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;

public class ExcludeFromBuildpathAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;

    public ExcludeFromBuildpathAction(IWorkbenchSite iWorkbenchSite) {
        this(iWorkbenchSite, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public ExcludeFromBuildpathAction(IRunnableContext iRunnableContext, ISetSelectionTarget iSetSelectionTarget) {
        this(null, iSetSelectionTarget, iRunnableContext);
    }

    private ExcludeFromBuildpathAction(IWorkbenchSite iWorkbenchSite, ISetSelectionTarget iSetSelectionTarget, IRunnableContext iRunnableContext) {
        super(iWorkbenchSite, iSetSelectionTarget, 2);
        this.fContext = iRunnableContext;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Exclude_label);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_EXCLUDE_FROM_BUILDPATH);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Exclude_tooltip);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_EXCLUDE_FROM_BUILDPATH);
    }

    public String getDetailedDescription() {
        if (!this.isEnabled()) {
            return null;
        }
        if (this.getSelectedElements().size() != 1) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_Exclude;
        }
        IJavaElement iJavaElement = (IJavaElement)this.getSelectedElements().get(0);
        String string = ClasspathModifier.escapeSpecialChars(iJavaElement.getElementName());
        if (iJavaElement instanceof IPackageFragment) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ExcludePackage, string);
        }
        if (iJavaElement instanceof ICompilationUnit) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ExcludeFile, string);
        }
        return null;
    }

    public void run() {
        Object e = this.getSelectedElements().get(0);
        final IJavaProject iJavaProject = e instanceof ICompilationUnit ? ((ICompilationUnit)e).getJavaProject() : ((IPackageFragment)e).getJavaProject();
        try {
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        List list = ExcludeFromBuildpathAction.this.exclude(ExcludeFromBuildpathAction.this.getSelectedElements(), iJavaProject, iProgressMonitor);
                        ExcludeFromBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(list));
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                }
            };
            this.fContext.run(false, false, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)invocationTargetException.getCause(), NewWizardMessages.ExcludeFromBuildathAction_ErrorTitle);
            } else {
                JavaPlugin.log(invocationTargetException);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private List exclude(List list, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        ArrayList<IResource> arrayList;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Excluding, list.size() + 4);
            List list2 = ClasspathModifier.getExistingEntries(iJavaProject);
            ArrayList<IResource> arrayList2 = new ArrayList<IResource>();
            int n = 0;
            while (n < list.size()) {
                IPackageFragmentRoot iPackageFragmentRoot;
                CPListElement cPListElement;
                IJavaElement iJavaElement = (IJavaElement)list.get(n);
                IResource iResource = ClasspathModifier.exclude(iJavaElement, cPListElement = ClasspathModifier.getClasspathEntry(list2, iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement.getAncestor(3)), iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                if (iResource != null) {
                    arrayList2.add(iResource);
                }
                ++n;
            }
            ClasspathModifier.commitClassPath(list2, iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 4));
            BuildpathDelta buildpathDelta = new BuildpathDelta(this.getToolTipText());
            buildpathDelta.setNewEntries(list2.toArray(new CPListElement[list2.size()]));
            this.informListeners(buildpathDelta);
            arrayList = arrayList2;
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return arrayList;
    }

    protected boolean canHandle(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() == 0) {
            return false;
        }
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof IPackageFragment) {
                IPackageFragment iPackageFragment = (IPackageFragment)e;
                if (ClasspathModifier.isDefaultFragment(iPackageFragment)) {
                    return false;
                }
                if (!((IPackageFragmentRoot)iPackageFragment.getAncestor(3)).isArchive()) continue;
                return false;
            }
            if (e instanceof ICompilationUnit) continue;
            return false;
        }
        return true;
    }
}

