/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.workingsets;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetMessages;

public abstract class AbstractWorkingSetWizardPage
extends WizardPage
implements IWorkingSetPage {
    private boolean fIsFirstValidation;
    private Text fWorkingSetName;
    private IWorkingSet fWorkingSet;

    public AbstractWorkingSetWizardPage(String string, String string2, ImageDescriptor imageDescriptor) {
        super(string, string2, imageDescriptor);
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite2);
        Label label = new Label(composite2, 64);
        label.setText(WorkingSetMessages.AbstractWorkingSetPage_workingSet_name);
        GridData gridData = new GridData(772);
        label.setLayoutData((Object)gridData);
        this.fWorkingSetName = new Text(composite2, 2052);
        this.fWorkingSetName.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                AbstractWorkingSetWizardPage.this.validateInput();
            }
        });
        this.fWorkingSetName.setFocus();
        Dialog.applyDialogFont((Control)composite2);
    }

    public IWorkingSet getSelection() {
        return this.fWorkingSet;
    }

    public void setSelection(IWorkingSet iWorkingSet) {
        Assert.isNotNull((Object)iWorkingSet, (String)"Working set must not be null");
        this.fWorkingSet = iWorkingSet;
        if (this.getContainer() != null && this.getShell() != null && this.fWorkingSetName != null) {
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
            this.validateInput();
        }
    }

    public void finish() {
        String string = this.fWorkingSetName.getText();
        if (this.fWorkingSet == null) {
            this.fWorkingSet = this.createWorkingSet(string);
        }
        this.fWorkingSet.setName(string);
    }

    protected abstract IWorkingSet createWorkingSet(String var1);

    private void validateInput() {
        String string = null;
        String string2 = this.fWorkingSetName.getText();
        if (!string2.equals(string2.trim())) {
            string = WorkingSetMessages.AbstractWorkingSetPage_warning_nameWhitespace;
        }
        if (string2.equals("")) {
            if (this.fIsFirstValidation) {
                this.setPageComplete(false);
                this.fIsFirstValidation = false;
                return;
            }
            string = WorkingSetMessages.AbstractWorkingSetPage_warning_nameMustNotBeEmpty;
        }
        this.fIsFirstValidation = false;
        if (!(string != null || this.fWorkingSet != null && string2.equals(this.fWorkingSet.getName()))) {
            IWorkingSet[] iWorkingSetArray = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int n = 0;
            while (n < iWorkingSetArray.length) {
                if (string2.equals(iWorkingSetArray[n].getName())) {
                    string = WorkingSetMessages.AbstractWorkingSetPage_warning_workingSetExists;
                }
                ++n;
            }
        }
        this.setErrorMessage(string);
        this.setPageComplete(string == null);
    }
}

