/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.launching;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.compiler.libraries.SystemLibraryLocation;
import org.eclipse.wst.jsdt.launching.IRuntimeClasspathEntry;
import org.eclipse.wst.jsdt.launching.IRuntimeClasspathEntryResolver;
import org.eclipse.wst.jsdt.launching.IRuntimeClasspathEntryResolver2;
import org.eclipse.wst.jsdt.launching.IRuntimeClasspathProvider;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.IVMInstallChangedListener;
import org.eclipse.wst.jsdt.launching.IVMInstallType;
import org.eclipse.wst.jsdt.launching.JREContainerInitializer;
import org.eclipse.wst.jsdt.launching.LibraryLocation;
import org.eclipse.wst.jsdt.launching.ListenerList;
import org.eclipse.wst.jsdt.launching.PropertyChangeEvent;
import org.eclipse.wst.jsdt.launching.StandardClasspathProvider;
import org.eclipse.wst.jsdt.launching.StandardVM;
import org.eclipse.wst.jsdt.launching.StandardVMType;

public final class JavaRuntime {
    public static final String JRELIB_VARIABLE = "JRE_LIB";
    public static final String JRESRC_VARIABLE = "JRE_SRC";
    public static final String JRESRCROOT_VARIABLE = "JRE_SRCROOT";
    public static final String EXTENSION_POINT_RUNTIME_CLASSPATH_ENTRY_RESOLVERS = "runtimeClasspathEntryResolvers";
    public static final String EXTENSION_POINT_RUNTIME_CLASSPATH_PROVIDERS = "classpathProviders";
    public static final String EXTENSION_POINT_EXECUTION_ENVIRONMENTS = "executionEnvironments";
    public static final String EXTENSION_POINT_VM_INSTALLS = "vmInstalls";
    public static final String JRE_CONTAINER = "org.eclipse.wst.jsdt.launching.JRE_CONTAINER";
    public static final String DEFAULT_SUPER_TYPE = "Global";
    public static final String DEFAULT_SUPER_TYPE_LIBRARY = "org.eclipse.wst.jsdt.launching.JRE_CONTAINER";
    public static final int ERR_UNABLE_TO_RESOLVE_JRE = 160;
    public static final String PREF_CONNECT_TIMEOUT = "org.eclipse.wst.jsdt.core.PREF_CONNECT_TIMEOUT";
    public static final String PREF_VM_XML = "org.eclipse.wst.jsdt.core.PREF_VM_XML";
    public static final int DEF_CONNECT_TIMEOUT = 20000;
    public static final String ATTR_CMDLINE = "org.eclipse.wst.jsdt.core.launcher.cmdLine";
    public static final String CLASSPATH_ATTR_LIBRARY_PATH_ENTRY = "org.eclipse.wst.jsdt.core.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY";
    private static Object fgVMLock = new Object();
    private static boolean fgInitializingVMs = false;
    private static IVMInstallType[] fgVMTypes = null;
    private static String fgDefaultVMId = null;
    private static String fgDefaultVMConnectorId = null;
    private static Map fgVariableResolvers = null;
    private static Map fgContainerResolvers = null;
    private static Map fgRuntimeClasspathEntryResolvers = null;
    private static Map fgPathProviders = null;
    private static IRuntimeClasspathProvider fgDefaultClasspathProvider = new StandardClasspathProvider();
    private static ListenerList fgVMListeners = new ListenerList(5);
    private static ThreadLocal fgProjects = new ThreadLocal();
    private static ThreadLocal fgEntryCount = new ThreadLocal();
    private static Set fgContributedVMs = new HashSet();
    private static IVMInstall defaultVM;

    private JavaRuntime() {
    }

    public static IVMInstall getVMInstall(IJavaProject iJavaProject) throws CoreException {
        IVMInstall iVMInstall = null;
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        IRuntimeClasspathEntryResolver2 iRuntimeClasspathEntryResolver2 = null;
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
            switch (iClasspathEntry.getEntryKind()) {
                case 4: {
                    iRuntimeClasspathEntryResolver2 = JavaRuntime.getVariableResolver(iClasspathEntry.getPath().segment(0));
                    if (iRuntimeClasspathEntryResolver2 == null) break;
                    iVMInstall = iRuntimeClasspathEntryResolver2.resolveVMInstall(iClasspathEntry);
                    break;
                }
                case 5: {
                    iRuntimeClasspathEntryResolver2 = JavaRuntime.getContainerResolver(iClasspathEntry.getPath().segment(0));
                    if (iRuntimeClasspathEntryResolver2 == null) break;
                    iVMInstall = iRuntimeClasspathEntryResolver2.resolveVMInstall(iClasspathEntry);
                }
            }
            if (iVMInstall != null) {
                return iVMInstall;
            }
            ++n;
        }
        return null;
    }

    public static IVMInstallType getVMInstallType(String string) {
        IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
        int n = 0;
        while (n < iVMInstallTypeArray.length) {
            if (iVMInstallTypeArray[n].getId().equals(string)) {
                return iVMInstallTypeArray[n];
            }
            ++n;
        }
        return null;
    }

    public static void setDefaultVMInstall(IVMInstall iVMInstall, IProgressMonitor iProgressMonitor) throws CoreException {
        JavaRuntime.setDefaultVMInstall(iVMInstall, iProgressMonitor, true);
    }

    public static void setDefaultVMInstall(IVMInstall iVMInstall, IProgressMonitor iProgressMonitor, boolean bl) throws CoreException {
        IVMInstall iVMInstall2 = null;
        if (fgDefaultVMId != null) {
            iVMInstall2 = JavaRuntime.getVMFromCompositeId(fgDefaultVMId);
        }
        fgDefaultVMId = JavaRuntime.getCompositeIdFromVM(iVMInstall);
        if (bl) {
            JavaRuntime.saveVMConfiguration();
        }
        IVMInstall iVMInstall3 = null;
        if (fgDefaultVMId != null) {
            iVMInstall3 = JavaRuntime.getVMFromCompositeId(fgDefaultVMId);
        }
        if (iVMInstall2 != iVMInstall3) {
            JavaRuntime.notifyDefaultVMChanged(iVMInstall2, iVMInstall3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IVMInstall getDefaultVMInstall() {
        IVMInstall iVMInstall = JavaRuntime.getVMFromCompositeId(JavaRuntime.getDefaultVMId());
        if (iVMInstall != null) {
            return iVMInstall;
        }
        if (iVMInstall != null) {
            iVMInstall.getVMInstallType().disposeVMInstall(iVMInstall.getId());
        }
        Object object = fgVMLock;
        synchronized (object) {
            fgDefaultVMId = null;
            fgVMTypes = null;
            JavaRuntime.initializeVMs();
        }
        return JavaRuntime.getVMFromCompositeId(JavaRuntime.getDefaultVMId());
    }

    public static IVMInstallType[] getVMInstallTypes() {
        JavaRuntime.initializeVMs();
        return fgVMTypes;
    }

    private static String getDefaultVMId() {
        JavaRuntime.initializeVMs();
        return fgDefaultVMId;
    }

    public static String getCompositeIdFromVM(IVMInstall iVMInstall) {
        if (iVMInstall == null) {
            return null;
        }
        throw new UnimplementedException();
    }

    public static IVMInstall getVMFromCompositeId(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return defaultVM;
    }

    public static IRuntimeClasspathEntry newArchiveRuntimeClasspathEntry(IResource iResource) {
        IClasspathEntry iClasspathEntry = JavaCore.newLibraryEntry((IPath)iResource.getFullPath(), null, null);
        return JavaRuntime.newRuntimeClasspathEntry(iClasspathEntry);
    }

    public static IRuntimeClasspathEntry newArchiveRuntimeClasspathEntry(IPath iPath) {
        IClasspathEntry iClasspathEntry = JavaCore.newLibraryEntry((IPath)iPath, null, null);
        return JavaRuntime.newRuntimeClasspathEntry(iClasspathEntry);
    }

    public static IRuntimeClasspathEntry newVariableRuntimeClasspathEntry(IPath iPath) {
        IClasspathEntry iClasspathEntry = JavaCore.newVariableEntry((IPath)iPath, null, null);
        return JavaRuntime.newRuntimeClasspathEntry(iClasspathEntry);
    }

    public static IRuntimeClasspathEntry newRuntimeContainerClasspathEntry(IPath iPath, int n) throws CoreException {
        return JavaRuntime.newRuntimeContainerClasspathEntry(iPath, n, null);
    }

    public static IRuntimeClasspathEntry newRuntimeContainerClasspathEntry(IPath iPath, int n, IJavaProject iJavaProject) throws CoreException {
        throw new UnimplementedException();
    }

    public static IRuntimeClasspathEntry newRuntimeClasspathEntry(String string) throws CoreException {
        throw new UnimplementedException();
    }

    private static IRuntimeClasspathEntry newRuntimeClasspathEntry(IClasspathEntry iClasspathEntry) {
        throw new UnimplementedException();
    }

    public static IRuntimeClasspathEntry[] computeUnresolvedRuntimeClasspath(IJavaProject iJavaProject) throws CoreException {
        throw new UnimplementedException();
    }

    public static IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry iRuntimeClasspathEntry, ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        throw new UnimplementedException();
    }

    public static IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry iRuntimeClasspathEntry, IJavaProject iJavaProject) throws CoreException {
        throw new UnimplementedException();
    }

    private static IRuntimeClasspathEntry[] computeDefaultContainerEntries(IRuntimeClasspathEntry iRuntimeClasspathEntry, ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IJavaProject iJavaProject = iRuntimeClasspathEntry.getJavaProject();
        if (iJavaProject == null) {
            iJavaProject = JavaRuntime.getJavaProject(iLaunchConfiguration);
        }
        return JavaRuntime.computeDefaultContainerEntries(iRuntimeClasspathEntry, iJavaProject);
    }

    private static IRuntimeClasspathEntry[] computeDefaultContainerEntries(IRuntimeClasspathEntry iRuntimeClasspathEntry, IJavaProject iJavaProject) throws CoreException {
        throw new UnimplementedException();
    }

    public static IJavaProject getJavaProject(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        throw new UnimplementedException();
    }

    public static String[] computeDefaultRuntimeClassPath(IJavaProject iJavaProject) throws CoreException {
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = JavaRuntime.computeUnresolvedRuntimeClasspath(iJavaProject);
        ArrayList<String> arrayList = new ArrayList<String>(iRuntimeClasspathEntryArray.length);
        int n = 0;
        while (n < iRuntimeClasspathEntryArray.length) {
            IRuntimeClasspathEntry iRuntimeClasspathEntry = iRuntimeClasspathEntryArray[n];
            if (iRuntimeClasspathEntry.getClasspathProperty() == 3) {
                IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray2 = JavaRuntime.resolveRuntimeClasspathEntry(iRuntimeClasspathEntry, iJavaProject);
                int n2 = 0;
                while (n2 < iRuntimeClasspathEntryArray2.length) {
                    String string = iRuntimeClasspathEntryArray2[n2].getLocation();
                    if (string != null) {
                        arrayList.add(string);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void saveVMConfiguration() throws CoreException {
        if (fgVMTypes == null) {
            return;
        }
        throw new UnimplementedException();
    }

    public static LibraryLocation[] getLibraryLocations(IVMInstall iVMInstall) {
        URL[] uRLArray;
        IPath[] iPathArray;
        IPath[] iPathArray2;
        IPath[] iPathArray3;
        LibraryLocation[] libraryLocationArray = iVMInstall.getLibraryLocations();
        if (libraryLocationArray == null) {
            URL uRL = iVMInstall.getJavadocLocation();
            LibraryLocation[] libraryLocationArray2 = iVMInstall.getVMInstallType().getDefaultLibraryLocations(iVMInstall.getInstallLocation());
            iPathArray3 = new IPath[libraryLocationArray2.length];
            iPathArray2 = new IPath[libraryLocationArray2.length];
            iPathArray = new IPath[libraryLocationArray2.length];
            uRLArray = new URL[libraryLocationArray2.length];
            int n = 0;
            while (n < libraryLocationArray2.length) {
                iPathArray3[n] = libraryLocationArray2[n].getSystemLibraryPath();
                uRLArray[n] = uRL == null ? libraryLocationArray2[n].getJavadocLocation() : uRL;
                if (!iPathArray3[n].toFile().isFile()) {
                    iPathArray3[n] = Path.EMPTY;
                }
                iPathArray2[n] = libraryLocationArray2[n].getSystemLibrarySourcePath();
                if (iPathArray2[n] != null && iPathArray2[n].toFile().isFile()) {
                    iPathArray[n] = libraryLocationArray2[n].getPackageRootPath();
                } else {
                    iPathArray2[n] = Path.EMPTY;
                    iPathArray[n] = Path.EMPTY;
                }
                ++n;
            }
        } else {
            iPathArray3 = new IPath[libraryLocationArray.length];
            iPathArray2 = new IPath[libraryLocationArray.length];
            iPathArray = new IPath[libraryLocationArray.length];
            uRLArray = new URL[libraryLocationArray.length];
            int n = 0;
            while (n < libraryLocationArray.length) {
                iPathArray3[n] = libraryLocationArray[n].getSystemLibraryPath();
                iPathArray2[n] = libraryLocationArray[n].getSystemLibrarySourcePath();
                iPathArray[n] = libraryLocationArray[n].getPackageRootPath();
                uRLArray[n] = libraryLocationArray[n].getJavadocLocation();
                ++n;
            }
        }
        libraryLocationArray = new LibraryLocation[iPathArray2.length];
        int n = 0;
        while (n < iPathArray2.length) {
            libraryLocationArray[n] = new LibraryLocation(iPathArray3[n], iPathArray2[n], iPathArray[n], uRLArray[n]);
            ++n;
        }
        return libraryLocationArray;
    }

    public static IClasspathEntry getDefaultJREContainerEntry() {
        return JavaCore.newContainerEntry((IPath)JavaRuntime.newDefaultJREContainerPath());
    }

    public static IPath newDefaultJREContainerPath() {
        return new Path("org.eclipse.wst.jsdt.launching.JRE_CONTAINER");
    }

    public static String getExecutionEnvironmentId(IPath iPath) {
        return JREContainerInitializer.getExecutionEnvironmentId(iPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRuntimeClasspathEntry computeJREEntry(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = iLaunchConfiguration.getAttribute("org.eclipse.wst.jsdt.launching.JRE_CONTAINER", null);
        IPath iPath = null;
        if (string == null) {
            String string2 = iLaunchConfiguration.getAttribute("org.eclipse.wst.jsdt.core.VM_INSTALL_TYPE_ID", null);
            if (string2 == null) {
                IJavaProject iJavaProject = JavaRuntime.getJavaProject(iLaunchConfiguration);
                if (iJavaProject != null) return JavaRuntime.computeJREEntry(iJavaProject);
                iPath = JavaRuntime.newDefaultJREContainerPath();
            } else {
                String string3 = iLaunchConfiguration.getAttribute("org.eclipse.wst.jsdt.core.VM_INSTALL_NAME", null);
                if (string3 != null) {
                    iPath = JavaRuntime.newDefaultJREContainerPath().append(string2).append(string3);
                }
            }
        } else {
            iPath = Path.fromPortableString((String)string);
        }
        if (iPath == null) return null;
        return JavaRuntime.newRuntimeContainerClasspathEntry(iPath, 1);
    }

    public static IRuntimeClasspathEntry computeJREEntry(IJavaProject iJavaProject) throws CoreException {
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        IRuntimeClasspathEntryResolver2 iRuntimeClasspathEntryResolver2 = null;
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
            block0 : switch (iClasspathEntry.getEntryKind()) {
                case 4: {
                    iRuntimeClasspathEntryResolver2 = JavaRuntime.getVariableResolver(iClasspathEntry.getPath().segment(0));
                    if (iRuntimeClasspathEntryResolver2 == null || !iRuntimeClasspathEntryResolver2.isVMInstallReference(iClasspathEntry)) break;
                    return JavaRuntime.newRuntimeClasspathEntry(iClasspathEntry);
                }
                case 5: {
                    IClasspathContainer iClasspathContainer;
                    iRuntimeClasspathEntryResolver2 = JavaRuntime.getContainerResolver(iClasspathEntry.getPath().segment(0));
                    if (iRuntimeClasspathEntryResolver2 == null || !iRuntimeClasspathEntryResolver2.isVMInstallReference(iClasspathEntry) || (iClasspathContainer = JavaCore.getClasspathContainer((IPath)iClasspathEntry.getPath(), (IJavaProject)iJavaProject)) == null) break;
                    switch (iClasspathContainer.getKind()) {
                        case 1: {
                            break block0;
                        }
                        case 3: {
                            return JavaRuntime.newRuntimeContainerClasspathEntry(iClasspathEntry.getPath(), 1);
                        }
                        case 2: {
                            return JavaRuntime.newRuntimeContainerClasspathEntry(iClasspathEntry.getPath(), 2);
                        }
                    }
                }
            }
            ++n;
        }
        return null;
    }

    public static void addContainerResolver(IRuntimeClasspathEntryResolver iRuntimeClasspathEntryResolver, String string) {
        Map map = JavaRuntime.getContainerResolvers();
        map.put(string, iRuntimeClasspathEntryResolver);
    }

    private static Map getVariableResolvers() {
        if (fgVariableResolvers == null) {
            JavaRuntime.initializeResolvers();
        }
        return fgVariableResolvers;
    }

    private static Map getContainerResolvers() {
        if (fgContainerResolvers == null) {
            JavaRuntime.initializeResolvers();
        }
        return fgContainerResolvers;
    }

    private static void initializeResolvers() {
        throw new UnimplementedException();
    }

    private static IRuntimeClasspathEntryResolver2 getVariableResolver(String string) {
        return (IRuntimeClasspathEntryResolver2)JavaRuntime.getVariableResolvers().get(string);
    }

    private static IRuntimeClasspathEntryResolver2 getContainerResolver(String string) {
        return (IRuntimeClasspathEntryResolver2)JavaRuntime.getContainerResolvers().get(string);
    }

    private static void notifyDefaultVMChanged(IVMInstall iVMInstall, IVMInstall iVMInstall2) {
        Object[] objectArray = fgVMListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IVMInstallChangedListener iVMInstallChangedListener = (IVMInstallChangedListener)objectArray[n];
            iVMInstallChangedListener.defaultVMInstallChanged(iVMInstall, iVMInstall2);
            ++n;
        }
    }

    public static void fireVMChanged(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = fgVMListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IVMInstallChangedListener iVMInstallChangedListener = (IVMInstallChangedListener)objectArray[n];
            iVMInstallChangedListener.vmChanged(propertyChangeEvent);
            ++n;
        }
    }

    public static void fireVMAdded(IVMInstall iVMInstall) {
        if (!fgInitializingVMs) {
            Object[] objectArray = fgVMListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                IVMInstallChangedListener iVMInstallChangedListener = (IVMInstallChangedListener)objectArray[n];
                iVMInstallChangedListener.vmAdded(iVMInstall);
                ++n;
            }
        }
    }

    public static void fireVMRemoved(IVMInstall iVMInstall) {
        Object[] objectArray = fgVMListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IVMInstallChangedListener iVMInstallChangedListener = (IVMInstallChangedListener)objectArray[n];
            iVMInstallChangedListener.vmRemoved(iVMInstall);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initializeVMs() {
        Object object = fgVMLock;
        synchronized (object) {
            if (fgVMTypes != null) return;
            try {
                fgInitializingVMs = true;
                fgVMTypes = new IVMInstallType[]{new StandardVMType()};
                defaultVM = new StandardVM(fgVMTypes[0], "defaultVM");
                fgDefaultVMId = defaultVM.getId();
                File file = SystemLibraryLocation.getInstance().getWorkingLibPath().toFile();
                defaultVM.setInstallLocation(file);
                Object var2_4 = null;
                fgInitializingVMs = false;
                return;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                fgInitializingVMs = false;
                throw throwable;
            }
        }
    }
}

