/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.launching;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.launching.AbstractVMInstallType;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.LaunchingMessages;
import org.eclipse.wst.jsdt.launching.LibraryLocation;
import org.eclipse.wst.jsdt.launching.StandardVM;

public class StandardVMType
extends AbstractVMInstallType {
    public static final String ID_STANDARD_VM_TYPE = "org.eclipse.wst.jsdt.internal.debug.ui.launcher.StandardVMType";
    private String fDefaultRootPath;
    private static Map fgFailedInstallPath = new HashMap();
    private static final char fgSeparator = File.separatorChar;
    private static final String[] fgCandidateJavaFiles = new String[]{"javaw", "javaw.exe", "java", "java.exe", "j9w", "j9w.exe", "j9", "j9.exe"};
    private static final String[] fgCandidateJavaLocations = new String[]{"bin" + fgSeparator, "jre" + fgSeparator + "bin" + fgSeparator};

    public static File findJavaExecutable(File file) {
        int n = 0;
        while (n < fgCandidateJavaFiles.length) {
            int n2 = 0;
            while (n2 < fgCandidateJavaLocations.length) {
                File file2 = new File(file, String.valueOf(fgCandidateJavaLocations[n2]) + fgCandidateJavaFiles[n]);
                if (file2.isFile()) {
                    return file2;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public String getName() {
        return LaunchingMessages.StandardVMType_Standard_VM_3;
    }

    protected IVMInstall doCreateVMInstall(String string) {
        return new StandardVM(this, string);
    }

    protected String getVMVersion(File file, File file2) {
        throw new UnimplementedException();
    }

    public File detectInstallLocation() {
        throw new UnimplementedException();
    }

    protected IPath getDefaultSystemLibrary(File file) {
        IPath iPath = new Path(file.getPath()).append("lib").append("rt.jar");
        if (iPath.toFile().isFile()) {
            return iPath;
        }
        return new Path(file.getPath()).append("jre").append("lib").append("rt.jar");
    }

    protected IPath getDefaultSystemLibrarySource(File file) {
        Object object;
        File file2 = file.getParentFile();
        while (file2 != null) {
            object = new File(file2, "src.jar");
            if (((File)object).isFile()) {
                this.setDefaultRootPath("src");
                return new Path(((File)object).getPath());
            }
            object = new File(file2, "src.zip");
            if (((File)object).isFile()) {
                this.setDefaultRootPath("");
                return new Path(((File)object).getPath());
            }
            file2 = file2.getParentFile();
        }
        object = this.checkForJ9LibrarySource(file);
        if (object != null) {
            return object;
        }
        this.setDefaultRootPath("");
        return Path.EMPTY;
    }

    private IPath checkForJ9LibrarySource(File file) {
        File file2 = file.getParentFile();
        String string = file.getName();
        if (string.equalsIgnoreCase("classes.zip")) {
            File file3 = new File(file2, "source/source.zip");
            return file3.isFile() ? new Path(file3.getPath()) : Path.EMPTY;
        }
        if (string.equalsIgnoreCase("locale.zip")) {
            File file4 = new File(file2, "source/locale-src.zip");
            return file4.isFile() ? new Path(file4.getPath()) : Path.EMPTY;
        }
        if (string.equalsIgnoreCase("charconv.zip")) {
            File file5 = new File(file2, "charconv-src.zip");
            return file5.isFile() ? new Path(file5.getPath()) : Path.EMPTY;
        }
        return null;
    }

    protected IPath getDefaultPackageRootPath() {
        return new Path(this.getDefaultRootPath());
    }

    public LibraryLocation[] getDefaultLibraryLocations(File file) {
        File file2 = new File(file, "system.js");
        Path path = new Path(file2.getAbsolutePath());
        LibraryLocation libraryLocation = new LibraryLocation((IPath)path, null, null);
        return new LibraryLocation[]{libraryLocation};
    }

    private void appendLibraries(List list, List list2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LibraryLocation libraryLocation = (LibraryLocation)iterator.next();
            if (this.isDuplicateLibrary(list2, libraryLocation)) continue;
            list2.add(libraryLocation);
        }
    }

    private boolean isDuplicateLibrary(List list, LibraryLocation libraryLocation) {
        String string = libraryLocation.getSystemLibraryPath().toOSString();
        int n = 0;
        while (n < list.size()) {
            LibraryLocation libraryLocation2 = (LibraryLocation)list.get(n);
            if (libraryLocation2.getSystemLibraryPath().toOSString().equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected List gatherAllLibraries(String[] stringArray) {
        ArrayList<LibraryLocation> arrayList = new ArrayList<LibraryLocation>();
        int n = 0;
        while (n < stringArray.length) {
            File file = new File(stringArray[n]);
            if (file.exists() && file.isDirectory()) {
                String[] stringArray2 = file.list();
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    String string;
                    int n3;
                    String string2 = stringArray2[n2];
                    File file2 = new File(file, string2);
                    if (file2.isFile() && (n3 = string2.length()) > 4 && ((string = string2.substring(n3 - 4)).equalsIgnoreCase(".zip") || string.equalsIgnoreCase(".jar"))) {
                        try {
                            Path path = new Path(file2.getCanonicalPath());
                            LibraryLocation libraryLocation = new LibraryLocation((IPath)path, (IPath)Path.EMPTY, (IPath)Path.EMPTY, null);
                            arrayList.add(libraryLocation);
                        }
                        catch (IOException iOException) {
                            JavaPlugin.log(iOException);
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList;
    }

    protected File getDefaultExtensionDirectory(File file) {
        File file2 = null;
        file2 = file.getName().equalsIgnoreCase("jre") ? file : new File(file, "jre");
        File file3 = new File(file2, "lib");
        File file4 = new File(file3, "ext");
        return file4;
    }

    protected File getDefaultEndorsedDirectory(File file) {
        File file2 = new File(file, "lib");
        File file3 = new File(file2, "endorsed");
        return file3;
    }

    protected String getDefaultRootPath() {
        return this.fDefaultRootPath;
    }

    protected void setDefaultRootPath(String string) {
        this.fDefaultRootPath = string;
    }

    public IStatus validateInstallLocation(File file) {
        throw new UnimplementedException();
    }

    protected String[] parsePaths(String string) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = string.indexOf(File.pathSeparatorChar, n);
        while (n2 > 0) {
            string2 = string.substring(n, n2);
            arrayList.add(string2);
            n = n2 + 1;
            n2 = string.indexOf(File.pathSeparatorChar, n);
        }
        string2 = string.substring(n);
        if (!string2.equals("null")) {
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void disposeVMInstall(String string) {
        IVMInstall iVMInstall = this.findVMInstall(string);
        if (iVMInstall != null) {
            iVMInstall.getInstallLocation().getAbsolutePath();
            throw new UnimplementedException();
        }
        super.disposeVMInstall(string);
    }

    public URL getDefaultJavadocLocation(File file) {
        throw new UnimplementedException();
    }
}

