/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.IProblemChangedListener;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.wst.jsdt.ui.JavaElementImageDescriptor;

public class ProblemsLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private static final int ERRORTICK_WARNING = 32;
    private static final int ERRORTICK_ERROR = 64;
    private ImageDescriptorRegistry fRegistry;
    private boolean fUseNewRegistry = false;
    private IProblemChangedListener fProblemChangedListener;
    private ListenerList fListeners;
    private ISourceRange fCachedRange;

    public ProblemsLabelDecorator() {
        this(null);
        this.fUseNewRegistry = true;
    }

    public ProblemsLabelDecorator(ImageDescriptorRegistry imageDescriptorRegistry) {
        this.fRegistry = imageDescriptorRegistry;
        this.fProblemChangedListener = null;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.fUseNewRegistry ? new ImageDescriptorRegistry() : JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String decorateText(String string, Object object) {
        return string;
    }

    public Image decorateImage(Image image, Object object) {
        int n = this.computeAdornmentFlags(object);
        if (n != 0) {
            ImageImageDescriptor imageImageDescriptor = new ImageImageDescriptor(image);
            Rectangle rectangle = image.getBounds();
            return this.getRegistry().get((ImageDescriptor)new JavaElementImageDescriptor(imageImageDescriptor, n, new Point(rectangle.width, rectangle.height)));
        }
        return image;
    }

    protected int computeAdornmentFlags(Object object) {
        block12: {
            try {
                if (object instanceof IJavaElement) {
                    IJavaElement iJavaElement = (IJavaElement)object;
                    int n = iJavaElement.getElementType();
                    switch (n) {
                        case 1: 
                        case 2: 
                        case 3: {
                            return this.getErrorTicksFromMarkers(iJavaElement.getResource(), 2, null);
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            return this.getErrorTicksFromMarkers(iJavaElement.getResource(), 1, null);
                        }
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: {
                            ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement.getAncestor(5);
                            if (iCompilationUnit != null) {
                                ISourceReference iSourceReference = n == 5 ? null : (ISourceReference)iJavaElement;
                                IAnnotationModel iAnnotationModel = this.isInJavaAnnotationModel(iCompilationUnit);
                                int n2 = 0;
                                n2 = iAnnotationModel != null ? this.getErrorTicksFromAnnotationModel(iAnnotationModel, iSourceReference) : this.getErrorTicksFromMarkers(iCompilationUnit.getResource(), 1, iSourceReference);
                                this.fCachedRange = null;
                                return n2;
                            }
                            break block12;
                        }
                    }
                    break block12;
                }
                if (object instanceof IResource) {
                    return this.getErrorTicksFromMarkers((IResource)object, 2, null);
                }
            }
            catch (CoreException coreException) {
                if (coreException instanceof JavaModelException && ((JavaModelException)((Object)coreException)).isDoesNotExist()) {
                    return 0;
                }
                if (coreException.getStatus().getCode() == 376) {
                    return 0;
                }
                JavaPlugin.log(coreException);
            }
        }
        return 0;
    }

    private int getErrorTicksFromMarkers(IResource iResource, int n, ISourceReference iSourceReference) throws CoreException {
        if (iResource == null || !iResource.isAccessible()) {
            return 0;
        }
        int n2 = 0;
        if (iSourceReference == null) {
            n2 = iResource.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, n);
        } else {
            IMarker[] iMarkerArray = iResource.findMarkers("org.eclipse.core.resources.problemmarker", true, n);
            if (iMarkerArray != null && iMarkerArray.length > 0) {
                int n3 = 0;
                while (n3 < iMarkerArray.length && n2 != 2) {
                    int n4;
                    IMarker iMarker = iMarkerArray[n3];
                    if (this.isMarkerInRange(iMarker, iSourceReference) && ((n4 = iMarker.getAttribute("severity", -1)) == 1 || n4 == 2)) {
                        n2 = n4;
                    }
                    ++n3;
                }
            }
        }
        if (n2 == 2) {
            return 64;
        }
        if (n2 == 1) {
            return 32;
        }
        return 0;
    }

    private boolean isMarkerInRange(IMarker iMarker, ISourceReference iSourceReference) throws CoreException {
        if (iMarker.isSubtypeOf("org.eclipse.core.resources.textmarker")) {
            int n = iMarker.getAttribute("charStart", -1);
            return this.isInside(n, iSourceReference);
        }
        return false;
    }

    private IAnnotationModel isInJavaAnnotationModel(ICompilationUnit iCompilationUnit) {
        if (iCompilationUnit.isWorkingCopy()) {
            FileEditorInput fileEditorInput = new FileEditorInput((IFile)iCompilationUnit.getResource());
            return JavaPlugin.getDefault().getCompilationUnitDocumentProvider().getAnnotationModel(fileEditorInput);
        }
        return null;
    }

    private int getErrorTicksFromAnnotationModel(IAnnotationModel iAnnotationModel, ISourceReference iSourceReference) throws CoreException {
        int n = 0;
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (n != 64 && iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            IMarker iMarker = this.isAnnotationInRange(iAnnotationModel, annotation, iSourceReference);
            if (iMarker == null) continue;
            int n2 = iMarker.getAttribute("severity", -1);
            if (n2 == 1) {
                n = 32;
                continue;
            }
            if (n2 != 2) continue;
            n = 64;
        }
        return n;
    }

    private IMarker isAnnotationInRange(IAnnotationModel iAnnotationModel, Annotation annotation, ISourceReference iSourceReference) throws CoreException {
        IMarker iMarker;
        if (annotation instanceof MarkerAnnotation && (iSourceReference == null || this.isInside(iAnnotationModel.getPosition(annotation), iSourceReference)) && (iMarker = ((MarkerAnnotation)annotation).getMarker()).exists() && iMarker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
            return iMarker;
        }
        return null;
    }

    private boolean isInside(Position position, ISourceReference iSourceReference) throws CoreException {
        return position != null && this.isInside(position.getOffset(), iSourceReference);
    }

    protected boolean isInside(int n, ISourceReference iSourceReference) throws CoreException {
        ISourceRange iSourceRange;
        if (this.fCachedRange == null) {
            this.fCachedRange = iSourceReference.getSourceRange();
        }
        if ((iSourceRange = this.fCachedRange) != null) {
            int n2 = iSourceRange.getOffset();
            return n2 <= n && n2 + iSourceRange.getLength() > n;
        }
        return false;
    }

    public void dispose() {
        if (this.fProblemChangedListener != null) {
            JavaPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
            this.fProblemChangedListener = null;
        }
        if (this.fRegistry != null && this.fUseNewRegistry) {
            this.fRegistry.dispose();
        }
    }

    public boolean isLabelProperty(Object object, String string) {
        return true;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)iLabelProviderListener);
        if (this.fProblemChangedListener == null) {
            this.fProblemChangedListener = new IProblemChangedListener(){

                public void problemsChanged(IResource[] iResourceArray, boolean bl) {
                    ProblemsLabelDecorator.this.fireProblemsChanged(iResourceArray, bl);
                }
            };
            JavaPlugin.getDefault().getProblemMarkerManager().addListener(this.fProblemChangedListener);
        }
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)iLabelProviderListener);
            if (this.fListeners.isEmpty() && this.fProblemChangedListener != null) {
                JavaPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
                this.fProblemChangedListener = null;
            }
        }
    }

    private void fireProblemsChanged(IResource[] iResourceArray, boolean bl) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            ProblemsLabelChangedEvent problemsLabelChangedEvent = new ProblemsLabelChangedEvent((IBaseLabelProvider)this, iResourceArray, bl);
            Object[] objectArray = this.fListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ((ILabelProviderListener)objectArray[n]).labelProviderChanged((LabelProviderChangedEvent)problemsLabelChangedEvent);
                ++n;
            }
        }
    }

    public void decorate(Object object, IDecoration iDecoration) {
        int n = this.computeAdornmentFlags(object);
        if (n == 64) {
            iDecoration.addOverlay(JavaPluginImages.DESC_OVR_ERROR);
        } else if (n == 32) {
            iDecoration.addOverlay(JavaPluginImages.DESC_OVR_WARNING);
        }
    }

    public static class ProblemsLabelChangedEvent
    extends LabelProviderChangedEvent {
        private static final long serialVersionUID = 1L;
        private boolean fMarkerChange;

        public ProblemsLabelChangedEvent(IBaseLabelProvider iBaseLabelProvider, IResource[] iResourceArray, boolean bl) {
            super(iBaseLabelProvider, (Object[])iResourceArray);
            this.fMarkerChange = bl;
        }

        public boolean isMarkerChange() {
            return this.fMarkerChange;
        }
    }
}

