/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;

public abstract class AbstractOpenWizardAction
extends Action {
    private Shell fShell = null;
    private IStructuredSelection fSelection = null;
    private IJavaElement fCreatedElement = null;

    protected AbstractOpenWizardAction() {
    }

    public void run() {
        Shell shell = this.getShell();
        if (!this.doCreateProjectFirstOnEmptyWorkspace(shell)) {
            return;
        }
        try {
            INewWizard iNewWizard = this.createWizard();
            iNewWizard.init(PlatformUI.getWorkbench(), this.getSelection());
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)iNewWizard);
            PixelConverter pixelConverter = new PixelConverter(JFaceResources.getDialogFont());
            wizardDialog.setMinimumPageSize(pixelConverter.convertWidthInCharsToPixels(70), pixelConverter.convertHeightInCharsToPixels(20));
            wizardDialog.create();
            int n = wizardDialog.open();
            if (n == 0 && iNewWizard instanceof NewElementWizard) {
                this.fCreatedElement = ((NewElementWizard)iNewWizard).getCreatedElement();
            }
            this.notifyResult(n == 0);
        }
        catch (CoreException coreException) {
            String string = NewWizardMessages.AbstractOpenWizardAction_createerror_title;
            String string2 = NewWizardMessages.AbstractOpenWizardAction_createerror_message;
            ExceptionHandler.handle(coreException, shell, string, string2);
        }
    }

    protected abstract INewWizard createWizard() throws CoreException;

    protected IStructuredSelection getSelection() {
        if (this.fSelection == null) {
            return this.evaluateCurrentSelection();
        }
        return this.fSelection;
    }

    private IStructuredSelection evaluateCurrentSelection() {
        ISelection iSelection;
        IWorkbenchWindow iWorkbenchWindow = JavaPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iSelection = iWorkbenchWindow.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)iSelection;
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(IStructuredSelection iStructuredSelection) {
        this.fSelection = iStructuredSelection;
    }

    protected Shell getShell() {
        if (this.fShell == null) {
            return JavaPlugin.getActiveWorkbenchShell();
        }
        return this.fShell;
    }

    public void setShell(Shell shell) {
        this.fShell = shell;
    }

    protected boolean doCreateProjectFirstOnEmptyWorkspace(Shell shell) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (iWorkspaceRoot.getProjects().length == 0) {
            String string = NewWizardMessages.AbstractOpenWizardAction_noproject_title;
            String string2 = NewWizardMessages.AbstractOpenWizardAction_noproject_message;
            if (MessageDialog.openQuestion((Shell)shell, (String)string, (String)string2)) {
                new NewProjectAction().run();
                return iWorkspaceRoot.getProjects().length != 0;
            }
            return false;
        }
        return true;
    }

    public IJavaElement getCreatedElement() {
        return this.fCreatedElement;
    }
}

