/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.ui.actions.FindExceptionOccurrencesAction;
import org.eclipse.wst.jsdt.ui.actions.FindImplementOccurrencesAction;
import org.eclipse.wst.jsdt.ui.actions.FindOccurrencesInFileAction;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class OccurrencesSearchGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private JavaEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindOccurrencesInFileAction fOccurrencesInFileAction;
    private FindExceptionOccurrencesAction fExceptionOccurrencesAction;
    private FindImplementOccurrencesAction fFindImplementorOccurrencesAction;
    static /* synthetic */ Class class$0;

    public OccurrencesSearchGroup(IWorkbenchSite iWorkbenchSite) {
        this.fSite = iWorkbenchSite;
        this.fGroupId = "group.search";
        this.fOccurrencesInFileAction = new FindOccurrencesInFileAction(iWorkbenchSite);
        this.fOccurrencesInFileAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.occurrences.in.file");
        this.fOccurrencesInFileAction.setText(SearchMessages.Search_FindOccurrencesInFile_shortLabel);
        this.fExceptionOccurrencesAction = new FindExceptionOccurrencesAction(iWorkbenchSite);
        this.fExceptionOccurrencesAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.exception.occurrences");
        this.fFindImplementorOccurrencesAction = new FindImplementOccurrencesAction(iWorkbenchSite);
        this.fFindImplementorOccurrencesAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.implement.occurrences");
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        this.registerAction(this.fOccurrencesInFileAction, iSelectionProvider, iSelection);
        this.registerAction(this.fExceptionOccurrencesAction, iSelectionProvider, iSelection);
        this.registerAction(this.fFindImplementorOccurrencesAction, iSelectionProvider, iSelection);
    }

    public OccurrencesSearchGroup(JavaEditor javaEditor) {
        this.fEditor = javaEditor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fOccurrencesInFileAction = new FindOccurrencesInFileAction(this.fEditor);
        this.fOccurrencesInFileAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.occurrences.in.file");
        this.fOccurrencesInFileAction.setText(SearchMessages.Search_FindOccurrencesInFile_shortLabel);
        this.fEditor.setAction("SearchOccurrencesInFile", (IAction)this.fOccurrencesInFileAction);
        this.fExceptionOccurrencesAction = new FindExceptionOccurrencesAction(this.fEditor);
        this.fExceptionOccurrencesAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.exception.occurrences");
        this.fEditor.setAction("SearchExceptionOccurrences", (IAction)this.fExceptionOccurrencesAction);
        this.fFindImplementorOccurrencesAction = new FindImplementOccurrencesAction(this.fEditor);
        this.fFindImplementorOccurrencesAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.implement.occurrences");
        this.fEditor.setAction("SearchImplementOccurrences", (IAction)this.fFindImplementorOccurrencesAction);
    }

    private void registerAction(SelectionDispatchAction selectionDispatchAction, ISelectionProvider iSelectionProvider, ISelection iSelection) {
        selectionDispatchAction.update(iSelection);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)selectionDispatchAction);
    }

    private IAction[] getActions() {
        IAction[] iActionArray = new IAction[]{this.fOccurrencesInFileAction, this.fExceptionOccurrencesAction, this.fFindImplementorOccurrencesAction};
        return iActionArray;
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        String string = SearchMessages.group_occurrences;
        String string2 = this.getShortcutString();
        if (string2 != null) {
            string = String.valueOf(string) + '\t' + string2;
        }
        MenuManager menuManager = new MenuManager(string, "group.search");
        IAction[] iActionArray = this.getActions();
        int n = 0;
        while (n < iActionArray.length) {
            IAction iAction = iActionArray[n];
            if (iAction.isEnabled()) {
                menuManager.add(iAction);
            }
            ++n;
        }
        if (!menuManager.isEmpty()) {
            iMenuManager.appendToGroup(this.fGroupId, (IContributionItem)menuManager);
        }
    }

    private String getShortcutString() {
        IBindingService iBindingService;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iBindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz)) == null) {
            return null;
        }
        return iBindingService.getBestActiveBindingFormattedFor("org.eclipse.wst.jsdt.ui.edit.text.java.search.occurrences.in.file.quickMenu");
    }

    public void fillActionBars(IActionBars iActionBars) {
        Assert.isNotNull((Object)iActionBars);
        super.fillActionBars(iActionBars);
        this.fActionBars = iActionBars;
        this.updateGlobalActionHandlers();
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        if (iSelectionProvider != null) {
            this.disposeAction(this.fFindImplementorOccurrencesAction, iSelectionProvider);
            this.disposeAction(this.fExceptionOccurrencesAction, iSelectionProvider);
            this.disposeAction(this.fOccurrencesInFileAction, iSelectionProvider);
        }
        super.dispose();
        this.fFindImplementorOccurrencesAction = null;
        this.fExceptionOccurrencesAction = null;
        this.fOccurrencesInFileAction = null;
        this.updateGlobalActionHandlers();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.OccurrencesInFile", (IAction)this.fOccurrencesInFileAction);
        }
    }

    private void disposeAction(ISelectionChangedListener iSelectionChangedListener, ISelectionProvider iSelectionProvider) {
        if (iSelectionChangedListener != null) {
            iSelectionProvider.removeSelectionChangedListener(iSelectionChangedListener);
        }
    }
}

