/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.AddUnimplementedMethodsOperation;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.dialogs.OverrideMethodDialog;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.wst.jsdt.internal.ui.util.ElementValidator;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class OverrideMethodsAction
extends SelectionDispatchAction {
    private static final String DIALOG_TITLE = ActionMessages.OverrideMethodsAction_error_title;
    private CompilationUnitEditor fEditor;
    static /* synthetic */ Class class$0;

    public OverrideMethodsAction(CompilationUnitEditor compilationUnitEditor) {
        this((IWorkbenchSite)compilationUnitEditor.getEditorSite());
        this.fEditor = compilationUnitEditor;
        this.setEnabled(this.checkEnabledEditor());
    }

    public OverrideMethodsAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.OverrideMethodsAction_label);
        this.setDescription(ActionMessages.OverrideMethodsAction_description);
        this.setToolTipText(ActionMessages.OverrideMethodsAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.add_unimplemented_methods_action_context");
    }

    private boolean canEnable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (iStructuredSelection.size() == 1 && iStructuredSelection.getFirstElement() instanceof IType) {
            IType iType = (IType)iStructuredSelection.getFirstElement();
            return iType.getCompilationUnit() != null && !iType.isInterface();
        }
        return iStructuredSelection.size() == 1 && iStructuredSelection.getFirstElement() instanceof ICompilationUnit;
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor);
    }

    private String getDialogTitle() {
        return DIALOG_TITLE;
    }

    private IType getSelectedType(IStructuredSelection iStructuredSelection) throws JavaModelException {
        IType iType;
        Object[] objectArray = iStructuredSelection.toArray();
        if (objectArray.length == 1 && objectArray[0] instanceof IType) {
            IType iType2 = (IType)objectArray[0];
            if (iType2.getCompilationUnit() != null && !iType2.isInterface()) {
                return iType2;
            }
        } else if (objectArray[0] instanceof ICompilationUnit && (iType = ((ICompilationUnit)objectArray[0]).findPrimaryType()) != null && !iType.isInterface()) {
            return iType;
        }
        return null;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        try {
            IType iType = this.getSelectedType(iStructuredSelection);
            if (iType == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_not_applicable);
                this.notifyResult(false);
                return;
            }
            if (!ElementValidator.check((IJavaElement)iType, this.getShell(), this.getDialogTitle(), false) || !ActionUtil.isEditable(this.getShell(), (IJavaElement)iType)) {
                this.notifyResult(false);
                return;
            }
            this.run(this.getShell(), iType);
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, this.getShell(), this.getDialogTitle(), ActionMessages.OverrideMethodsAction_error_actionfailed);
        }
    }

    public void run(ITextSelection iTextSelection) {
        try {
            IType iType = SelectionConverter.getTypeAtOffset(this.fEditor);
            if (iType != null) {
                if (!ElementValidator.check((IJavaElement)iType, this.getShell(), this.getDialogTitle(), false) || !ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)iType)) {
                    this.notifyResult(false);
                    return;
                }
                if (iType.isAnnotation()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_annotation_not_applicable);
                    this.notifyResult(false);
                    return;
                }
                if (iType.isInterface()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_interface_not_applicable);
                    this.notifyResult(false);
                    return;
                }
                this.run(this.getShell(), iType);
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_not_applicable);
            }
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), this.getShell(), this.getDialogTitle(), null);
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, this.getShell(), this.getDialogTitle(), ActionMessages.OverrideMethodsAction_error_actionfailed);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run(Shell shell, IType iType) throws CoreException {
        block22: {
            IRewriteTarget iRewriteTarget;
            IRewriteTarget iRewriteTarget2;
            Object object;
            OverrideMethodDialog overrideMethodDialog = new OverrideMethodDialog(shell, this.fEditor, iType, false);
            if (!overrideMethodDialog.hasMethodsToOverride()) {
                MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_error_nothing_found);
                this.notifyResult(false);
                return;
            }
            if (overrideMethodDialog.open() != 0) {
                this.notifyResult(false);
                return;
            }
            Object[] objectArray = overrideMethodDialog.getResult();
            if (objectArray == null) {
                this.notifyResult(false);
                return;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < objectArray.length) {
                object = objectArray[n];
                if (object instanceof IMethodBinding) {
                    arrayList.add(object);
                }
                ++n;
            }
            IMethodBinding[] iMethodBindingArray = arrayList.toArray(new IMethodBinding[arrayList.size()]);
            object = JavaUI.openInEditor((IJavaElement)iType.getCompilationUnit());
            if (object != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iRewriteTarget2 = (IRewriteTarget)object.getAdapter((Class)clazz);
            } else {
                iRewriteTarget2 = iRewriteTarget = null;
            }
            if (iRewriteTarget != null) {
                iRewriteTarget.beginCompoundChange();
            }
            try {
                try {
                    CompilationUnit compilationUnit = overrideMethodDialog.getCompilationUnit();
                    ITypeBinding iTypeBinding = ASTNodes.getTypeBinding(compilationUnit, iType);
                    int n2 = overrideMethodDialog.getInsertOffset();
                    AddUnimplementedMethodsOperation addUnimplementedMethodsOperation = (AddUnimplementedMethodsOperation)OverrideMethodsAction.createRunnable(compilationUnit, iTypeBinding, iMethodBindingArray, n2, overrideMethodDialog.getGenerateComment());
                    Object object2 = JavaPlugin.getActiveWorkbenchWindow();
                    if (object2 == null) {
                        object2 = new BusyIndicatorRunnableContext();
                    }
                    PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)object2, (IRunnableWithProgress)new WorkbenchRunnableAdapter(addUnimplementedMethodsOperation, addUnimplementedMethodsOperation.getSchedulingRule()), addUnimplementedMethodsOperation.getSchedulingRule());
                    String[] stringArray = addUnimplementedMethodsOperation.getCreatedMethods();
                    if (stringArray == null || stringArray.length == 0) {
                        MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_error_nothing_found);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    ExceptionHandler.handle(invocationTargetException, shell, this.getDialogTitle(), null);
                }
                catch (InterruptedException interruptedException) {}
                Object var15_19 = null;
                if (iRewriteTarget == null) break block22;
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                if (iRewriteTarget != null) {
                    iRewriteTarget.endCompoundChange();
                }
                throw throwable;
            }
            iRewriteTarget.endCompoundChange();
        }
        this.notifyResult(true);
    }

    public static IWorkspaceRunnable createRunnable(CompilationUnit compilationUnit, ITypeBinding iTypeBinding, IMethodBinding[] iMethodBindingArray, int n, boolean bl) {
        AddUnimplementedMethodsOperation addUnimplementedMethodsOperation = new AddUnimplementedMethodsOperation(compilationUnit, iTypeBinding, iMethodBindingArray, n, true, true, false);
        addUnimplementedMethodsOperation.setCreateComments(bl);
        return addUnimplementedMethodsOperation;
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        try {
            this.setEnabled(this.canEnable(iStructuredSelection));
        }
        catch (JavaModelException javaModelException) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) {
                JavaPlugin.log(javaModelException);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }
}

