/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.RenameJavaElementAction;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.RenameResourceAction;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class RenameAction
extends SelectionDispatchAction {
    private RenameJavaElementAction fRenameJavaElement;
    private RenameResourceAction fRenameResource;

    public RenameAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(RefactoringMessages.RenameAction_text);
        this.fRenameJavaElement = new RenameJavaElementAction(iWorkbenchSite);
        this.fRenameJavaElement.setText(this.getText());
        this.fRenameResource = new RenameResourceAction(iWorkbenchSite);
        this.fRenameResource.setText(this.getText());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.rename_action");
    }

    public RenameAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fRenameJavaElement = new RenameJavaElementAction(javaEditor);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.fRenameJavaElement.selectionChanged(selectionChangedEvent);
        if (this.fRenameResource != null) {
            this.fRenameResource.selectionChanged(selectionChangedEvent);
        }
        this.setEnabled(this.computeEnabledState());
    }

    public void update(ISelection iSelection) {
        this.fRenameJavaElement.update(iSelection);
        if (this.fRenameResource != null) {
            this.fRenameResource.update(iSelection);
        }
        this.setEnabled(this.computeEnabledState());
    }

    private boolean computeEnabledState() {
        if (this.fRenameResource != null) {
            return this.fRenameJavaElement.isEnabled() || this.fRenameResource.isEnabled();
        }
        return this.fRenameJavaElement.isEnabled();
    }

    public void run(IStructuredSelection iStructuredSelection) {
        if (this.fRenameJavaElement.isEnabled()) {
            this.fRenameJavaElement.run(iStructuredSelection);
        }
        if (this.fRenameResource != null && this.fRenameResource.isEnabled()) {
            this.fRenameResource.run(iStructuredSelection);
        }
    }

    public void run(ITextSelection iTextSelection) {
        if (this.fRenameJavaElement.canRunInEditor()) {
            this.fRenameJavaElement.run(iTextSelection);
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.RenameAction_rename, (String)RefactoringMessages.RenameAction_unavailable);
        }
    }
}

