/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.SortMembersOperation;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.SortMembersMessageDialog;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.wst.jsdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.wst.jsdt.internal.ui.util.ElementValidator;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class SortMembersAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private static final String ID_OPTIONAL_DIALOG = "org.eclipse.wst.jsdt.ui.actions.SortMembersAction";

    public SortMembersAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.SortMembersAction_label);
        this.setDescription(ActionMessages.SortMembersAction_description);
        this.setToolTipText(ActionMessages.SortMembersAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.sort_members_action");
    }

    public SortMembersAction(CompilationUnitEditor compilationUnitEditor) {
        this((IWorkbenchSite)compilationUnitEditor.getEditorSite());
        this.fEditor = compilationUnitEditor;
        this.setEnabled(this.checkEnabledEditor());
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor);
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        boolean bl = false;
        bl = this.getSelectedCompilationUnit(iStructuredSelection) != null;
        this.setEnabled(bl);
    }

    public void run(IStructuredSelection iStructuredSelection) {
        Shell shell = this.getShell();
        try {
            ICompilationUnit iCompilationUnit = this.getSelectedCompilationUnit(iStructuredSelection);
            if (iCompilationUnit == null) {
                return;
            }
            IType[] iTypeArray = iCompilationUnit.getTypes();
            if (!this.hasMembersToSort((IJavaElement[])iTypeArray)) {
                return;
            }
            if (!ActionUtil.isEditable(this.getShell(), (IJavaElement)iCompilationUnit)) {
                return;
            }
            SortMembersMessageDialog sortMembersMessageDialog = new SortMembersMessageDialog(this.getShell());
            if (sortMembersMessageDialog.open() != 0) {
                return;
            }
            if (!ElementValidator.check((IJavaElement)iCompilationUnit, this.getShell(), this.getDialogTitle(), false)) {
                return;
            }
            IEditorPart iEditorPart = JavaUI.openInEditor((IJavaElement)iCompilationUnit);
            if (iEditorPart != null) {
                this.run(shell, iCompilationUnit, iEditorPart, sortMembersMessageDialog.isNotSortingFieldsEnabled());
            }
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, shell, this.getDialogTitle(), null);
        }
    }

    private boolean hasMembersToSort(IJavaElement[] iJavaElementArray) throws JavaModelException {
        IJavaElement iJavaElement;
        if (iJavaElementArray.length > 1) {
            return true;
        }
        if (iJavaElementArray.length == 1 && (iJavaElement = iJavaElementArray[0]) instanceof IParent) {
            return this.hasMembersToSort(((IParent)iJavaElement).getChildren());
        }
        return false;
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }

    public void run(ITextSelection iTextSelection) {
        Shell shell = this.getShell();
        IJavaElement iJavaElement = SelectionConverter.getInput(this.fEditor);
        if (iJavaElement instanceof ICompilationUnit) {
            if (!ActionUtil.isEditable(this.fEditor)) {
                return;
            }
            SortMembersMessageDialog sortMembersMessageDialog = new SortMembersMessageDialog(this.getShell());
            if (sortMembersMessageDialog.open() != 0) {
                return;
            }
            if (!ElementValidator.check(iJavaElement, this.getShell(), this.getDialogTitle(), true)) {
                return;
            }
            this.run(shell, (ICompilationUnit)iJavaElement, (IEditorPart)this.fEditor, sortMembersMessageDialog.isNotSortingFieldsEnabled());
        } else {
            MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.SortMembersAction_not_applicable);
        }
    }

    private boolean containsRelevantMarkers(IEditorPart iEditorPart) {
        IAnnotationModel iAnnotationModel = JavaUI.getDocumentProvider().getAnnotationModel((Object)iEditorPart.getEditorInput());
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            IJavaAnnotation iJavaAnnotation;
            Object e = iterator.next();
            if (!(e instanceof IJavaAnnotation) || (iJavaAnnotation = (IJavaAnnotation)e).isMarkedDeleted() || !iJavaAnnotation.isPersistent() || iJavaAnnotation.isProblem()) continue;
            return true;
        }
        return false;
    }

    private void run(Shell shell, ICompilationUnit iCompilationUnit, IEditorPart iEditorPart, boolean bl) {
        int n;
        if (this.containsRelevantMarkers(iEditorPart) && (n = OptionalMessageDialog.open(ID_OPTIONAL_DIALOG, this.getShell(), this.getDialogTitle(), null, ActionMessages.SortMembersAction_containsmarkers, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0)) != 1025 && n != 0) {
            return;
        }
        SortMembersOperation sortMembersOperation = new SortMembersOperation(iCompilationUnit, null, bl);
        try {
            BusyIndicatorRunnableContext busyIndicatorRunnableContext = new BusyIndicatorRunnableContext();
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)busyIndicatorRunnableContext, (IRunnableWithProgress)new WorkbenchRunnableAdapter(sortMembersOperation, sortMembersOperation.getScheduleRule()), sortMembersOperation.getScheduleRule());
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, shell, this.getDialogTitle(), null);
        }
        catch (InterruptedException interruptedException) {}
    }

    private ICompilationUnit getSelectedCompilationUnit(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() == 1) {
            IType iType;
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof ICompilationUnit) {
                return (ICompilationUnit)object;
            }
            if (object instanceof IType && (iType = (IType)object).getParent() instanceof ICompilationUnit) {
                return iType.getCompilationUnit();
            }
        }
        return null;
    }

    private String getDialogTitle() {
        return ActionMessages.SortMembersAction_dialog_title;
    }
}

