/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.text.java;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.CompletionContext;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.internal.corext.util.TypeFilter;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.AnonymousTypeCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.AnonymousTypeProposalInfo;
import org.eclipse.wst.jsdt.internal.ui.text.java.FieldProposalInfo;
import org.eclipse.wst.jsdt.internal.ui.text.java.GetterSetterCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.MethodDeclarationCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.MethodProposalInfo;
import org.eclipse.wst.jsdt.internal.ui.text.java.OverrideCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.ProposalContextInformation;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavadocInlineTagCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavadocLinkTypeCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalLabelProvider;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public class CompletionProposalCollector
extends CompletionRequestor {
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.ui/debug/ResultCollector"));
    protected static final char[] METHOD_TRIGGERS = new char[]{';', ',', '.', '\t', '[', ' '};
    protected static final char[] METHOD_WITH_ARGUMENTS_TRIGGERS = new char[]{'(', '-', ' '};
    protected static final char[] TYPE_TRIGGERS = new char[]{'.', '\t', '[', '(', ' '};
    protected static final char[] VAR_TRIGGER = new char[]{'\t', ' ', '=', ';', '.'};
    private final CompletionProposalLabelProvider fLabelProvider = new CompletionProposalLabelProvider();
    private final ImageDescriptorRegistry fRegistry = JavaPlugin.getImageDescriptorRegistry();
    private final List fJavaProposals = new ArrayList();
    private final List fKeywords = new ArrayList();
    private final Set fSuggestedMethodNames = new HashSet();
    private final ICompilationUnit fCompilationUnit;
    private final IJavaProject fJavaProject;
    private int fUserReplacementLength;
    private CompletionContext fContext;
    private IProblem fLastProblem;
    private long fStartTime;
    private long fUITime;
    private JavaContentAssistInvocationContext fInvocationContext;

    public CompletionProposalCollector(ICompilationUnit iCompilationUnit) {
        this(iCompilationUnit.getJavaProject(), iCompilationUnit);
    }

    public CompletionProposalCollector(IJavaProject iJavaProject) {
        this(iJavaProject, null);
    }

    private CompletionProposalCollector(IJavaProject iJavaProject, ICompilationUnit iCompilationUnit) {
        this.fJavaProject = iJavaProject;
        this.fCompilationUnit = iCompilationUnit;
        this.fUserReplacementLength = -1;
    }

    public void setInvocationContext(JavaContentAssistInvocationContext javaContentAssistInvocationContext) {
        Assert.isNotNull((Object)javaContentAssistInvocationContext);
        this.fInvocationContext = javaContentAssistInvocationContext;
        javaContentAssistInvocationContext.setCollector(this);
    }

    protected final JavaContentAssistInvocationContext getInvocationContext() {
        if (this.fInvocationContext == null) {
            this.setInvocationContext(new JavaContentAssistInvocationContext(this.getCompilationUnit()));
        }
        return this.fInvocationContext;
    }

    public void accept(CompletionProposal completionProposal) {
        long l = DEBUG ? System.currentTimeMillis() : 0L;
        try {
            if (this.isFiltered(completionProposal)) {
                return;
            }
            if (completionProposal.getKind() == 11) {
                this.acceptPotentialMethodDeclaration(completionProposal);
            } else {
                IJavaCompletionProposal iJavaCompletionProposal = this.createJavaCompletionProposal(completionProposal);
                if (iJavaCompletionProposal != null) {
                    this.fJavaProposals.add(iJavaCompletionProposal);
                    if (completionProposal.getKind() == 3) {
                        this.fKeywords.add(iJavaCompletionProposal);
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, "Exception when processing proposal for: " + String.valueOf(completionProposal.getCompletion()), (Throwable)illegalArgumentException));
        }
        if (DEBUG) {
            this.fUITime += System.currentTimeMillis() - l;
        }
    }

    public void acceptContext(CompletionContext completionContext) {
        this.fContext = completionContext;
        this.fLabelProvider.setContext(completionContext);
    }

    public void beginReporting() {
        if (DEBUG) {
            this.fStartTime = System.currentTimeMillis();
            this.fUITime = 0L;
        }
        this.fLastProblem = null;
        this.fJavaProposals.clear();
        this.fKeywords.clear();
        this.fSuggestedMethodNames.clear();
    }

    public void completionFailure(IProblem iProblem) {
        this.fLastProblem = iProblem;
    }

    public void endReporting() {
        if (DEBUG) {
            long l = System.currentTimeMillis() - this.fStartTime;
            System.err.println("Core Collector (core):\t" + (l - this.fUITime));
            System.err.println("Core Collector (ui):\t" + this.fUITime);
        }
    }

    public String getErrorMessage() {
        if (this.fLastProblem != null) {
            return this.fLastProblem.getMessage();
        }
        return "";
    }

    public final IJavaCompletionProposal[] getJavaCompletionProposals() {
        return this.fJavaProposals.toArray(new IJavaCompletionProposal[this.fJavaProposals.size()]);
    }

    public final JavaCompletionProposal[] getKeywordCompletionProposals() {
        return this.fKeywords.toArray(new JavaCompletionProposal[this.fKeywords.size()]);
    }

    public final void setReplacementLength(int n) {
        Assert.isLegal((n >= 0 ? 1 : 0) != 0);
        this.fUserReplacementLength = n;
    }

    protected int computeRelevance(CompletionProposal completionProposal) {
        int n = completionProposal.getRelevance() * 16;
        switch (completionProposal.getKind()) {
            case 8: {
                return n + 0;
            }
            case 4: {
                return n + 1;
            }
            case 3: {
                return n + 2;
            }
            case 1: 
            case 9: {
                return n + 3;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                return n + 4;
            }
            case 11: {
                return n + 4;
            }
            case 2: {
                return n + 5;
            }
            case 5: 
            case 10: {
                return n + 6;
            }
        }
        return n;
    }

    protected IJavaCompletionProposal createJavaCompletionProposal(CompletionProposal completionProposal) {
        switch (completionProposal.getKind()) {
            case 3: {
                return this.createKeywordProposal(completionProposal);
            }
            case 8: {
                return this.createPackageProposal(completionProposal);
            }
            case 9: {
                return this.createTypeProposal(completionProposal);
            }
            case 16: {
                return this.createJavadocLinkTypeProposal(completionProposal);
            }
            case 2: 
            case 14: 
            case 17: {
                return this.createFieldProposal(completionProposal);
            }
            case 6: 
            case 12: 
            case 15: {
                return this.createMethodReferenceProposal(completionProposal);
            }
            case 7: {
                return this.createMethodDeclarationProposal(completionProposal);
            }
            case 1: {
                return this.createAnonymousTypeProposal(completionProposal);
            }
            case 4: {
                return this.createLabelProposal(completionProposal);
            }
            case 5: 
            case 10: {
                return this.createLocalVariableProposal(completionProposal);
            }
            case 13: {
                return this.createAnnotationAttributeReferenceProposal(completionProposal);
            }
            case 18: 
            case 19: {
                return this.createJavadocSimpleProposal(completionProposal);
            }
            case 20: {
                return this.createJavadocInlineTagProposal(completionProposal);
            }
        }
        return null;
    }

    protected final IContextInformation createMethodContextInformation(CompletionProposal completionProposal) {
        Assert.isTrue((completionProposal.getKind() == 6 ? 1 : 0) != 0);
        return new ProposalContextInformation(completionProposal);
    }

    protected final ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    protected final CompletionContext getContext() {
        return this.fContext;
    }

    protected final Image getImage(ImageDescriptor imageDescriptor) {
        return imageDescriptor == null ? null : this.fRegistry.get(imageDescriptor);
    }

    protected final CompletionProposalLabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    protected final int getLength(CompletionProposal completionProposal) {
        int n;
        int n2 = completionProposal.getReplaceStart();
        int n3 = completionProposal.getReplaceEnd();
        if (this.fUserReplacementLength == -1) {
            n = n3 - n2;
        } else {
            n = this.fUserReplacementLength;
            int n4 = completionProposal.getCompletionLocation() + 1;
            if (n2 < n4) {
                n += n4 - n2;
            }
        }
        return n;
    }

    protected boolean isFiltered(CompletionProposal completionProposal) {
        if (this.isIgnored(completionProposal.getKind())) {
            return true;
        }
        char[] cArray = this.getDeclaringType(completionProposal);
        return cArray != null && TypeFilter.isFiltered(cArray);
    }

    protected final char[] getDeclaringType(CompletionProposal completionProposal) {
        switch (completionProposal.getKind()) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                char[] cArray = completionProposal.getDeclarationSignature();
                if (cArray == null) {
                    return "java.lang.Object".toCharArray();
                }
                return Signature.toCharArray((char[])cArray);
            }
            case 8: {
                return completionProposal.getDeclarationSignature();
            }
            case 9: 
            case 16: {
                return Signature.toCharArray((char[])completionProposal.getSignature());
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 18: 
            case 19: 
            case 20: {
                return null;
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private void acceptPotentialMethodDeclaration(CompletionProposal completionProposal) {
        if (this.fCompilationUnit == null) {
            return;
        }
        String string = String.valueOf(completionProposal.getName());
        int n = completionProposal.getReplaceStart();
        int n2 = completionProposal.getReplaceEnd();
        int n3 = this.computeRelevance(completionProposal);
        try {
            IType iType;
            IJavaElement iJavaElement = this.fCompilationUnit.getElementAt(completionProposal.getCompletionLocation() + 1);
            if (iJavaElement != null && (iType = (IType)iJavaElement.getAncestor(7)) != null) {
                GetterSetterCompletionProposal.evaluateProposals(iType, string, n, n2 - n, n3 + 1, this.fSuggestedMethodNames, this.fJavaProposals);
                MethodDeclarationCompletionProposal.evaluateProposals(iType, string, n, n2 - n, n3, this.fSuggestedMethodNames, this.fJavaProposals);
            }
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
    }

    private IJavaCompletionProposal createAnnotationAttributeReferenceProposal(CompletionProposal completionProposal) {
        String string = this.fLabelProvider.createLabelWithTypeAndDeclaration(completionProposal);
        ImageDescriptor imageDescriptor = this.fLabelProvider.createMethodImageDescriptor(completionProposal);
        String string2 = String.valueOf(completionProposal.getCompletion());
        return new JavaCompletionProposal(string2, completionProposal.getReplaceStart(), this.getLength(completionProposal), this.getImage(imageDescriptor), string, this.computeRelevance(completionProposal));
    }

    private IJavaCompletionProposal createAnonymousTypeProposal(CompletionProposal completionProposal) {
        if (this.fCompilationUnit == null || this.fJavaProject == null) {
            return null;
        }
        String string = String.valueOf(completionProposal.getCompletion());
        int n = completionProposal.getReplaceStart();
        int n2 = this.getLength(completionProposal);
        int n3 = this.computeRelevance(completionProposal);
        String string2 = this.fLabelProvider.createAnonymousTypeLabel(completionProposal);
        AnonymousTypeCompletionProposal anonymousTypeCompletionProposal = new AnonymousTypeCompletionProposal(this.fJavaProject, this.fCompilationUnit, n, n2, string, string2, String.valueOf(completionProposal.getDeclarationSignature()), n3);
        anonymousTypeCompletionProposal.setProposalInfo(new AnonymousTypeProposalInfo(this.fJavaProject, completionProposal));
        return anonymousTypeCompletionProposal;
    }

    private IJavaCompletionProposal createFieldProposal(CompletionProposal completionProposal) {
        String string = String.valueOf(completionProposal.getCompletion());
        int n = completionProposal.getReplaceStart();
        int n2 = this.getLength(completionProposal);
        String string2 = this.fLabelProvider.createLabel(completionProposal);
        Image image = this.getImage(this.fLabelProvider.createFieldImageDescriptor(completionProposal));
        int n3 = this.computeRelevance(completionProposal);
        JavaCompletionProposal javaCompletionProposal = new JavaCompletionProposal(string, n, n2, image, string2, n3, this.getContext().isInJavadoc(), this.getInvocationContext());
        if (this.fJavaProject != null) {
            javaCompletionProposal.setProposalInfo(new FieldProposalInfo(this.fJavaProject, completionProposal));
        }
        javaCompletionProposal.setTriggerCharacters(VAR_TRIGGER);
        return javaCompletionProposal;
    }

    private IJavaCompletionProposal createJavadocSimpleProposal(CompletionProposal completionProposal) {
        LazyJavaCompletionProposal lazyJavaCompletionProposal = new LazyJavaCompletionProposal(completionProposal, this.getInvocationContext());
        return lazyJavaCompletionProposal;
    }

    private IJavaCompletionProposal createJavadocInlineTagProposal(CompletionProposal completionProposal) {
        JavadocInlineTagCompletionProposal javadocInlineTagCompletionProposal = new JavadocInlineTagCompletionProposal(completionProposal, this.getInvocationContext());
        this.adaptLength(javadocInlineTagCompletionProposal, completionProposal);
        return javadocInlineTagCompletionProposal;
    }

    private IJavaCompletionProposal createKeywordProposal(CompletionProposal completionProposal) {
        String string = String.valueOf(completionProposal.getCompletion());
        int n = completionProposal.getReplaceStart();
        int n2 = this.getLength(completionProposal);
        String string2 = this.fLabelProvider.createSimpleLabel(completionProposal);
        int n3 = this.computeRelevance(completionProposal);
        return new JavaCompletionProposal(string, n, n2, null, string2, n3);
    }

    private IJavaCompletionProposal createLabelProposal(CompletionProposal completionProposal) {
        String string = String.valueOf(completionProposal.getCompletion());
        int n = completionProposal.getReplaceStart();
        int n2 = this.getLength(completionProposal);
        String string2 = this.fLabelProvider.createSimpleLabel(completionProposal);
        int n3 = this.computeRelevance(completionProposal);
        return new JavaCompletionProposal(string, n, n2, null, string2, n3);
    }

    private IJavaCompletionProposal createLocalVariableProposal(CompletionProposal completionProposal) {
        String string = String.valueOf(completionProposal.getCompletion());
        int n = completionProposal.getReplaceStart();
        int n2 = this.getLength(completionProposal);
        Image image = this.getImage(this.fLabelProvider.createLocalImageDescriptor(completionProposal));
        String string2 = this.fLabelProvider.createSimpleLabelWithType(completionProposal);
        int n3 = this.computeRelevance(completionProposal);
        JavaCompletionProposal javaCompletionProposal = new JavaCompletionProposal(string, n, n2, image, string2, n3);
        javaCompletionProposal.setTriggerCharacters(VAR_TRIGGER);
        return javaCompletionProposal;
    }

    private IJavaCompletionProposal createMethodDeclarationProposal(CompletionProposal completionProposal) {
        if (this.fCompilationUnit == null || this.fJavaProject == null) {
            return null;
        }
        String string = String.valueOf(completionProposal.getName());
        String[] stringArray = Signature.getParameterTypes((String)String.valueOf(completionProposal.getSignature()));
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = Signature.toString((String)stringArray[n]);
            ++n;
        }
        n = completionProposal.getReplaceStart();
        int n2 = this.getLength(completionProposal);
        String string2 = this.fLabelProvider.createOverrideMethodProposalLabel(completionProposal);
        OverrideCompletionProposal overrideCompletionProposal = new OverrideCompletionProposal(this.fJavaProject, this.fCompilationUnit, string, stringArray, n, n2, string2, String.valueOf(completionProposal.getCompletion()));
        overrideCompletionProposal.setImage(this.getImage(this.fLabelProvider.createMethodImageDescriptor(completionProposal)));
        overrideCompletionProposal.setProposalInfo(new MethodProposalInfo(this.fJavaProject, completionProposal));
        overrideCompletionProposal.setRelevance(this.computeRelevance(completionProposal));
        this.fSuggestedMethodNames.add(new String(string));
        return overrideCompletionProposal;
    }

    private IJavaCompletionProposal createMethodReferenceProposal(CompletionProposal completionProposal) {
        JavaMethodCompletionProposal javaMethodCompletionProposal = new JavaMethodCompletionProposal(completionProposal, this.getInvocationContext());
        this.adaptLength(javaMethodCompletionProposal, completionProposal);
        return javaMethodCompletionProposal;
    }

    private void adaptLength(LazyJavaCompletionProposal lazyJavaCompletionProposal, CompletionProposal completionProposal) {
        if (this.fUserReplacementLength != -1) {
            lazyJavaCompletionProposal.setReplacementLength(this.getLength(completionProposal));
        }
    }

    private IJavaCompletionProposal createPackageProposal(CompletionProposal completionProposal) {
        String string = String.valueOf(completionProposal.getCompletion());
        int n = completionProposal.getReplaceStart();
        int n2 = this.getLength(completionProposal);
        String string2 = this.fLabelProvider.createSimpleLabel(completionProposal);
        Image image = this.getImage(this.fLabelProvider.createPackageImageDescriptor(completionProposal));
        int n3 = this.computeRelevance(completionProposal);
        return new JavaCompletionProposal(string, n, n2, image, string2, n3);
    }

    private IJavaCompletionProposal createTypeProposal(CompletionProposal completionProposal) {
        LazyJavaTypeCompletionProposal lazyJavaTypeCompletionProposal = new LazyJavaTypeCompletionProposal(completionProposal, this.getInvocationContext());
        this.adaptLength(lazyJavaTypeCompletionProposal, completionProposal);
        return lazyJavaTypeCompletionProposal;
    }

    private IJavaCompletionProposal createJavadocLinkTypeProposal(CompletionProposal completionProposal) {
        JavadocLinkTypeCompletionProposal javadocLinkTypeCompletionProposal = new JavadocLinkTypeCompletionProposal(completionProposal, this.getInvocationContext());
        this.adaptLength(javadocLinkTypeCompletionProposal, completionProposal);
        return javadocLinkTypeCompletionProposal;
    }
}

