/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.debug.ui;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.jsdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.wst.jsdt.ui.text.JavaTextTools;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class JDIDebugUIPlugin
extends AbstractUIPlugin
implements IStartup {
    private static final String PI_JDI_DEBUG = "org.eclipse.wst.jsdt.atfdebug";
    public static final String COMMAND_INSPECT = "org.eclipse.wst.jsdt.debug.ui.commands.Inspect";
    private static JDIDebugUIPlugin fgPlugin;
    private IDebugModelPresentation fUtilPresentation;
    private boolean fShuttingDown = false;
    private JavaTextTools fTextTools = null;

    public JDIDebugUIPlugin() {
        JDIDebugUIPlugin.setDefault(this);
    }

    private static void setDefault(JDIDebugUIPlugin jDIDebugUIPlugin) {
        fgPlugin = jDIDebugUIPlugin;
    }

    public static JDIDebugUIPlugin getDefault() {
        return fgPlugin;
    }

    public static String getUniqueIdentifier() {
        return PI_JDI_DEBUG;
    }

    public static void log(IStatus iStatus) {
        JDIDebugUIPlugin.getDefault().getLog().log(iStatus);
    }

    public static void logErrorMessage(String string) {
        JDIDebugUIPlugin.log((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, string, null));
    }

    public static void log(Throwable throwable) {
        if (throwable instanceof CoreException) {
            JDIDebugUIPlugin.log(((CoreException)throwable).getStatus());
        } else {
            JDIDebugUIPlugin.log((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, "Internal Error", throwable));
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return JDIDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow iWorkbenchWindow = JDIDebugUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = JDIDebugUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getShell();
        }
        return null;
    }

    public static void statusDialog(IStatus iStatus) {
        switch (iStatus.getSeverity()) {
            case 4: {
                JDIDebugUIPlugin.statusDialog(DebugUIMessages.JDIDebugUIPlugin_Error_1, iStatus);
                break;
            }
            case 2: {
                JDIDebugUIPlugin.statusDialog(DebugUIMessages.JDIDebugUIPlugin_0, iStatus);
                break;
            }
            case 1: {
                JDIDebugUIPlugin.statusDialog(DebugUIMessages.JDIDebugUIPlugin_4, iStatus);
            }
        }
    }

    public static void statusDialog(String string, IStatus iStatus) {
        Shell shell = JDIDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            switch (iStatus.getSeverity()) {
                case 4: {
                    ErrorDialog.openError((Shell)shell, (String)string, (String)iStatus.getMessage(), (IStatus)iStatus);
                    break;
                }
                case 2: {
                    MessageDialog.openWarning((Shell)shell, (String)string, (String)iStatus.getMessage());
                    break;
                }
                case 1: {
                    MessageDialog.openInformation((Shell)shell, (String)string, (String)iStatus.getMessage());
                }
            }
        }
    }

    public static void errorDialog(String string, Throwable throwable) {
        Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, string, throwable);
        JDIDebugUIPlugin.statusDialog((IStatus)status);
    }

    public static Object createExtension(final IConfigurationElement iConfigurationElement, final String string) throws CoreException {
        Bundle bundle = Platform.getBundle((String)iConfigurationElement.getContributor().getName());
        if (bundle.getState() == 32) {
            return iConfigurationElement.createExecutableExtension(string);
        }
        final Object[] objectArray = new Object[1];
        final CoreException[] coreExceptionArray = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    objectArray[0] = iConfigurationElement.createExecutableExtension(string);
                }
                catch (CoreException coreException) {
                    coreExceptionArray[0] = coreException;
                }
            }
        });
        if (coreExceptionArray[0] != null) {
            throw coreExceptionArray[0];
        }
        return objectArray[0];
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext bundleContext) throws Exception {
        try {
            this.setShuttingDown(true);
            if (this.fTextTools != null) {
                this.fTextTools.dispose();
            }
            ResourcesPlugin.getWorkspace().removeSaveParticipant((Plugin)this);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stop(bundleContext);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.stop(bundleContext);
    }

    protected boolean isShuttingDown() {
        return this.fShuttingDown;
    }

    private void setShuttingDown(boolean bl) {
        this.fShuttingDown = bl;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Shell getShell() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (iWorkbenchWindowArray.length > 0) {
                return iWorkbenchWindowArray[0].getShell();
            }
        } else {
            return iWorkbenchWindow.getShell();
        }
        return null;
    }

    public void earlyStartup() {
    }
}

