/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.ICorrectionRequestor;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class CorrectionEngine
implements ProblemReasons {
    protected int correctionStart;
    protected int correctionEnd;
    protected int prefixLength;
    protected ICompilationUnit compilationUnit;
    protected ICorrectionRequestor correctionRequestor;
    protected static final int CLASSES = 1;
    protected static final int INTERFACES = 2;
    protected static final int IMPORT = 4;
    protected static final int METHOD = 8;
    protected static final int FIELD = 16;
    protected static final int LOCAL = 32;
    protected int filter;
    protected CompletionRequestor completionRequestor = new CompletionRequestor(){

        public void accept(CompletionProposal completionProposal) {
            switch (completionProposal.getKind()) {
                case 9: {
                    int n = completionProposal.getFlags();
                    if (Flags.isEnum(n) || Flags.isAnnotation(n)) break;
                    if ((CorrectionEngine.this.filter & 3) != 0) {
                        char[] cArray = completionProposal.getCompletion();
                        CorrectionEngine.this.correctionRequestor.acceptClass(completionProposal.getDeclarationSignature(), Signature.getSignatureSimpleName(completionProposal.getSignature()), CharOperation.subarray(cArray, CorrectionEngine.this.prefixLength, cArray.length), completionProposal.getFlags(), CorrectionEngine.this.correctionStart, CorrectionEngine.this.correctionEnd);
                        break;
                    }
                    if ((CorrectionEngine.this.filter & 4) == 0) break;
                    char[] cArray = completionProposal.getDeclarationSignature();
                    char[] cArray2 = Signature.getSignatureSimpleName(completionProposal.getSignature());
                    char[] cArray3 = CharOperation.concat(cArray, cArray2, '.');
                    CorrectionEngine.this.correctionRequestor.acceptClass(cArray, cArray2, CharOperation.subarray(cArray3, CorrectionEngine.this.prefixLength, cArray3.length), completionProposal.getFlags(), CorrectionEngine.this.correctionStart, CorrectionEngine.this.correctionEnd);
                    break;
                }
                case 2: {
                    if ((CorrectionEngine.this.filter & 0x10) == 0) break;
                    char[] cArray = completionProposal.getDeclarationSignature();
                    char[] cArray4 = completionProposal.getSignature();
                    CorrectionEngine.this.correctionRequestor.acceptField(Signature.getSignatureQualifier(cArray), Signature.getSignatureSimpleName(cArray), completionProposal.getName(), Signature.getSignatureQualifier(cArray4), Signature.getSignatureSimpleName(cArray4), completionProposal.getName(), completionProposal.getFlags(), CorrectionEngine.this.correctionStart, CorrectionEngine.this.correctionEnd);
                    break;
                }
                case 5: {
                    if ((CorrectionEngine.this.filter & 0x20) == 0) break;
                    char[] cArray = completionProposal.getSignature();
                    CorrectionEngine.this.correctionRequestor.acceptLocalVariable(completionProposal.getName(), Signature.getSignatureQualifier(cArray), Signature.getSignatureSimpleName(cArray), completionProposal.getFlags(), CorrectionEngine.this.correctionStart, CorrectionEngine.this.correctionEnd);
                    break;
                }
                case 6: {
                    if ((CorrectionEngine.this.filter & 8) == 0) break;
                    char[] cArray = completionProposal.getDeclarationSignature();
                    char[] cArray5 = completionProposal.getSignature();
                    char[][] cArray6 = Signature.getParameterTypes(cArray5);
                    int n = cArray6.length;
                    char[][] cArrayArray = new char[n][];
                    char[][] cArrayArray2 = new char[n][];
                    int n2 = 0;
                    while (n2 < n) {
                        cArrayArray[n2] = Signature.getSignatureQualifier(cArray6[n2]);
                        cArrayArray2[n2] = Signature.getSignatureSimpleName(cArray6[n2]);
                        ++n2;
                    }
                    char[] cArray7 = Signature.getReturnType(cArray5);
                    CorrectionEngine.this.correctionRequestor.acceptMethod(Signature.getSignatureQualifier(cArray), Signature.getSignatureSimpleName(cArray), completionProposal.getName(), cArrayArray, cArrayArray2, completionProposal.findParameterNames(null), Signature.getSignatureQualifier(cArray7), Signature.getSignatureSimpleName(cArray7), completionProposal.getName(), completionProposal.getFlags(), CorrectionEngine.this.correctionStart, CorrectionEngine.this.correctionEnd);
                    break;
                }
                case 8: {
                    if ((CorrectionEngine.this.filter & 7) == 0) break;
                    char[] cArray = completionProposal.getDeclarationSignature();
                    CorrectionEngine.this.correctionRequestor.acceptPackage(cArray, CharOperation.subarray(cArray, CorrectionEngine.this.prefixLength, cArray.length), CorrectionEngine.this.correctionStart, CorrectionEngine.this.correctionEnd);
                }
            }
        }
    };

    public CorrectionEngine(Map map) {
    }

    public void computeCorrections(IMarker iMarker, ICompilationUnit iCompilationUnit, int n, ICorrectionRequestor iCorrectionRequestor) throws JavaModelException {
        ICompilationUnit iCompilationUnit2;
        IJavaElement iJavaElement = iCompilationUnit2 = iCompilationUnit == null ? JavaCore.create(iMarker.getResource()) : iCompilationUnit;
        if (!(iCompilationUnit2 instanceof ICompilationUnit)) {
            return;
        }
        ICompilationUnit iCompilationUnit3 = iCompilationUnit2;
        int n2 = iMarker.getAttribute("id", -1);
        String[] stringArray = Util.getProblemArgumentsFromMarker(iMarker.getAttribute("arguments", ""));
        int n3 = iMarker.getAttribute("charStart", -1);
        int n4 = iMarker.getAttribute("charEnd", -1);
        this.computeCorrections(iCompilationUnit3, n2, n3 + n, n4 + n, stringArray, iCorrectionRequestor);
    }

    public void computeCorrections(IProblem iProblem, ICompilationUnit iCompilationUnit, ICorrectionRequestor iCorrectionRequestor) throws JavaModelException {
        if (iCorrectionRequestor == null) {
            throw new IllegalArgumentException(Messages.correction_nullUnit);
        }
        this.computeCorrections(iCompilationUnit, iProblem.getID(), iProblem.getSourceStart(), iProblem.getSourceEnd(), iProblem.getArguments(), iCorrectionRequestor);
    }

    private void computeCorrections(ICompilationUnit iCompilationUnit, int n, int n2, int n3, String[] stringArray, ICorrectionRequestor iCorrectionRequestor) {
        if (n == -1 || stringArray == null || n2 == -1 || n3 == -1) {
            return;
        }
        if (iCorrectionRequestor == null) {
            throw new IllegalArgumentException(Messages.correction_nullRequestor);
        }
        this.correctionRequestor = iCorrectionRequestor;
        this.correctionStart = n2;
        this.correctionEnd = n3;
        this.compilationUnit = iCompilationUnit;
        String string = null;
        try {
            switch (n) {
                case 268435846: {
                    this.filter = 4;
                    string = stringArray[0];
                    break;
                }
                case 0x1000002: {
                    this.filter = 3;
                    string = stringArray[0];
                    break;
                }
                case 0x4000064: 
                case 67108973: {
                    this.filter = 8;
                    string = stringArray[1];
                    break;
                }
                case 33554502: {
                    this.filter = 16;
                    string = stringArray[0];
                    break;
                }
                case 0x22000032: {
                    this.filter = 48;
                    string = stringArray[0];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        if (string != null) {
            this.correct(string.toCharArray());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void correct(char[] cArray) {
        try {
            String string = this.compilationUnit.getSource();
            Scanner scanner = new Scanner();
            scanner.setSource(string.toCharArray());
            scanner.resetTo(this.correctionStart, this.correctionEnd);
            int n = 0;
            char[] cArray2 = CharOperation.NO_CHAR;
            do {
                if ((n = scanner.getNextToken()) == 55) {
                    return;
                }
                char[] cArray3 = scanner.getCurrentTokenSource();
                if (CharOperation.prefixEquals(cArray2 = CharOperation.concat(cArray2, cArray3), cArray)) continue;
                return;
            } while (!CharOperation.equals(cArray, cArray2));
            this.correctionStart = scanner.startPosition;
            this.correctionEnd = scanner.currentPosition;
            this.prefixLength = CharOperation.lastIndexOf('.', cArray) + 1;
            int n2 = this.correctionStart;
            scanner.resetTo(n2, this.correctionEnd);
            int n3 = n2;
            int n4 = 0;
            while (n4 < 4 && scanner.getNextCharAsJavaIdentifierPart()) {
                n2 = n3;
                n3 = scanner.currentPosition;
                ++n4;
            }
            Hashtable hashtable = JavaCore.getOptions();
            try {
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>(hashtable);
                hashtable2.put("org.eclipse.wst.jsdt.core.codeComplete.camelCaseMatch", "disabled");
                JavaCore.setOptions(hashtable2);
                this.compilationUnit.codeComplete(n2, this.completionRequestor);
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                JavaCore.setOptions(hashtable);
                throw throwable;
            }
            {
                Object var10_14 = null;
                JavaCore.setOptions(hashtable);
                return;
            }
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        catch (InvalidInputException invalidInputException) {
            return;
        }
    }

    public static String[] getAllWarningTokens() {
        return CompilerOptions.warningTokens;
    }

    public static String[] getProblemArguments(IMarker iMarker) {
        String string = iMarker.getAttribute("arguments", null);
        return Util.getProblemArgumentsFromMarker(string);
    }

    public static String getWarningToken(int n) {
        long l = ProblemReporter.getIrritant(n);
        if (l != 0L) {
            return CompilerOptions.warningTokenFromIrritant(l);
        }
        return null;
    }
}

