/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core;

import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.core.INamingRequestor;
import org.eclipse.wst.jsdt.internal.core.InternalNamingConventions;

public final class NamingConventions {
    private static final char[] GETTER_BOOL_NAME = "is".toCharArray();
    private static final char[] GETTER_NAME = "get".toCharArray();
    private static final char[] SETTER_NAME = "set".toCharArray();

    private NamingConventions() {
    }

    private static char[] removePrefixAndSuffix(char[] cArray, char[][] cArray2, char[][] cArray3) {
        int n;
        int n2;
        char[] cArray4 = cArray;
        if (cArray2 != null) {
            int n3 = 0;
            n2 = 0;
            while (n2 < cArray2.length) {
                int n4;
                char[] cArray5 = cArray2[n2];
                if (CharOperation.prefixEquals(cArray5, cArray) && ((n = (int)(ScannerHelper.isLetter(cArray5[(n4 = cArray5.length) - 1]) ? 1 : 0)) == 0 || n != 0 && cArray.length > n4 && ScannerHelper.isUpperCase(cArray[n4])) && n3 < n4 && cArray.length != n4) {
                    cArray4 = CharOperation.subarray(cArray, n4, cArray.length);
                    n3 = n4;
                }
                ++n2;
            }
        }
        char[] cArray6 = cArray4;
        if (cArray3 != null) {
            n2 = 0;
            int n5 = 0;
            while (n5 < cArray3.length) {
                char[] cArray7 = cArray3[n5];
                if (CharOperation.endsWith(cArray4, cArray7) && n2 < (n = cArray7.length) && cArray4.length != n) {
                    cArray6 = CharOperation.subarray(cArray4, 0, cArray4.length - n);
                    n2 = n;
                }
                ++n5;
            }
        }
        cArray6[0] = ScannerHelper.toLowerCase(cArray6[0]);
        return cArray6;
    }

    public static char[] removePrefixAndSuffixForArgumentName(IJavaProject iJavaProject, char[] cArray) {
        AssistOptions assistOptions = new AssistOptions(iJavaProject.getOptions(true));
        return NamingConventions.removePrefixAndSuffix(cArray, assistOptions.argumentPrefixes, assistOptions.argumentSuffixes);
    }

    public static String removePrefixAndSuffixForArgumentName(IJavaProject iJavaProject, String string) {
        return String.valueOf(NamingConventions.removePrefixAndSuffixForArgumentName(iJavaProject, string.toCharArray()));
    }

    public static char[] removePrefixAndSuffixForFieldName(IJavaProject iJavaProject, char[] cArray, int n) {
        boolean bl = Flags.isStatic(n);
        AssistOptions assistOptions = new AssistOptions(iJavaProject.getOptions(true));
        return NamingConventions.removePrefixAndSuffix(cArray, bl ? assistOptions.staticFieldPrefixes : assistOptions.fieldPrefixes, bl ? assistOptions.staticFieldSuffixes : assistOptions.fieldSuffixes);
    }

    public static String removePrefixAndSuffixForFieldName(IJavaProject iJavaProject, String string, int n) {
        return String.valueOf(NamingConventions.removePrefixAndSuffixForFieldName(iJavaProject, string.toCharArray(), n));
    }

    public static char[] removePrefixAndSuffixForLocalVariableName(IJavaProject iJavaProject, char[] cArray) {
        AssistOptions assistOptions = new AssistOptions(iJavaProject.getOptions(true));
        return NamingConventions.removePrefixAndSuffix(cArray, assistOptions.localPrefixes, assistOptions.localSuffixes);
    }

    public static String removePrefixAndSuffixForLocalVariableName(IJavaProject iJavaProject, String string) {
        return String.valueOf(NamingConventions.removePrefixAndSuffixForLocalVariableName(iJavaProject, string.toCharArray()));
    }

    public static char[][] suggestArgumentNames(IJavaProject iJavaProject, char[] cArray, char[] cArray2, int n, char[][] cArray3) {
        NamingRequestor namingRequestor = new NamingRequestor();
        InternalNamingConventions.suggestArgumentNames(iJavaProject, cArray, cArray2, n, null, cArray3, namingRequestor);
        return namingRequestor.getResults();
    }

    public static String[] suggestArgumentNames(IJavaProject iJavaProject, String string, String string2, int n, String[] stringArray) {
        return NamingConventions.convertCharsToString(NamingConventions.suggestArgumentNames(iJavaProject, string != null ? string.toCharArray() : null, string2 != null ? string2.toCharArray() : null, n, NamingConventions.convertStringToChars(stringArray)));
    }

    public static char[][] suggestFieldNames(IJavaProject iJavaProject, char[] cArray, char[] cArray2, int n, int n2, char[][] cArray3) {
        NamingRequestor namingRequestor = new NamingRequestor();
        InternalNamingConventions.suggestFieldNames(iJavaProject, cArray, cArray2, n, n2, null, cArray3, namingRequestor);
        return namingRequestor.getResults();
    }

    public static String[] suggestFieldNames(IJavaProject iJavaProject, String string, String string2, int n, int n2, String[] stringArray) {
        return NamingConventions.convertCharsToString(NamingConventions.suggestFieldNames(iJavaProject, string.toCharArray(), string2.toCharArray(), n, n2, NamingConventions.convertStringToChars(stringArray)));
    }

    public static char[][] suggestLocalVariableNames(IJavaProject iJavaProject, char[] cArray, char[] cArray2, int n, char[][] cArray3) {
        NamingRequestor namingRequestor = new NamingRequestor();
        InternalNamingConventions.suggestLocalVariableNames(iJavaProject, cArray, cArray2, n, null, cArray3, namingRequestor);
        return namingRequestor.getResults();
    }

    public static String[] suggestLocalVariableNames(IJavaProject iJavaProject, String string, String string2, int n, String[] stringArray) {
        return NamingConventions.convertCharsToString(NamingConventions.suggestLocalVariableNames(iJavaProject, string.toCharArray(), string2.toCharArray(), n, NamingConventions.convertStringToChars(stringArray)));
    }

    public static char[] suggestGetterName(IJavaProject iJavaProject, char[] cArray, int n, boolean bl, char[][] cArray2) {
        if (bl) {
            char[] cArray3 = NamingConventions.removePrefixAndSuffixForFieldName(iJavaProject, cArray, n);
            int n2 = GETTER_BOOL_NAME.length;
            if (CharOperation.prefixEquals(GETTER_BOOL_NAME, cArray3) && cArray3.length > n2 && ScannerHelper.isUpperCase(cArray3[n2])) {
                return NamingConventions.suggestNewName(cArray3, cArray2);
            }
            return NamingConventions.suggestNewName(CharOperation.concat(GETTER_BOOL_NAME, NamingConventions.suggestAccessorName(iJavaProject, cArray, n)), cArray2);
        }
        return NamingConventions.suggestNewName(CharOperation.concat(GETTER_NAME, NamingConventions.suggestAccessorName(iJavaProject, cArray, n)), cArray2);
    }

    public static String suggestGetterName(IJavaProject iJavaProject, String string, int n, boolean bl, String[] stringArray) {
        return String.valueOf(NamingConventions.suggestGetterName(iJavaProject, string.toCharArray(), n, bl, NamingConventions.convertStringToChars(stringArray)));
    }

    public static char[] suggestSetterName(IJavaProject iJavaProject, char[] cArray, int n, boolean bl, char[][] cArray2) {
        if (bl) {
            char[] cArray3 = NamingConventions.removePrefixAndSuffixForFieldName(iJavaProject, cArray, n);
            int n2 = GETTER_BOOL_NAME.length;
            if (CharOperation.prefixEquals(GETTER_BOOL_NAME, cArray3) && cArray3.length > n2 && ScannerHelper.isUpperCase(cArray3[n2])) {
                cArray3 = CharOperation.subarray(cArray3, n2, cArray3.length);
                return NamingConventions.suggestNewName(CharOperation.concat(SETTER_NAME, NamingConventions.suggestAccessorName(iJavaProject, cArray3, n)), cArray2);
            }
            return NamingConventions.suggestNewName(CharOperation.concat(SETTER_NAME, NamingConventions.suggestAccessorName(iJavaProject, cArray, n)), cArray2);
        }
        return NamingConventions.suggestNewName(CharOperation.concat(SETTER_NAME, NamingConventions.suggestAccessorName(iJavaProject, cArray, n)), cArray2);
    }

    public static String suggestSetterName(IJavaProject iJavaProject, String string, int n, boolean bl, String[] stringArray) {
        return String.valueOf(NamingConventions.suggestSetterName(iJavaProject, string.toCharArray(), n, bl, NamingConventions.convertStringToChars(stringArray)));
    }

    private static char[] suggestAccessorName(IJavaProject iJavaProject, char[] cArray, int n) {
        char[] cArray2 = NamingConventions.removePrefixAndSuffixForFieldName(iJavaProject, cArray, n);
        if (cArray2.length > 0 && ScannerHelper.isLowerCase(cArray2[0])) {
            cArray2[0] = ScannerHelper.toUpperCase(cArray2[0]);
        }
        return cArray2;
    }

    private static char[] suggestNewName(char[] cArray, char[][] cArray2) {
        if (cArray2 == null) {
            return cArray;
        }
        char[] cArray3 = cArray;
        int n = 2;
        int n2 = 0;
        while (n2 < cArray2.length) {
            if (CharOperation.equals(cArray3, cArray2[n2], false)) {
                cArray3 = CharOperation.concat(cArray, String.valueOf(n++).toCharArray());
                n2 = 0;
                continue;
            }
            ++n2;
        }
        return cArray3;
    }

    private static String[] convertCharsToString(char[][] cArray) {
        int n = cArray == null ? 0 : cArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = String.valueOf(cArray[n2]);
            ++n2;
        }
        return stringArray;
    }

    private static char[][] convertStringToChars(String[] stringArray) {
        int n = stringArray == null ? 0 : stringArray.length;
        char[][] cArrayArray = new char[n][];
        int n2 = 0;
        while (n2 < n) {
            cArrayArray[n2] = stringArray[n2] == null ? CharOperation.NO_CHAR : stringArray[n2].toCharArray();
            ++n2;
        }
        return cArrayArray;
    }

    static class NamingRequestor
    implements INamingRequestor {
        private static final int SIZE = 10;
        private char[][] firstPrefixAndFirstSuffixResults = new char[10][];
        private int firstPrefixAndFirstSuffixResultsCount = 0;
        private char[][] firstPrefixAndSuffixResults = new char[10][];
        private int firstPrefixAndSuffixResultsCount = 0;
        private char[][] prefixAndFirstSuffixResults = new char[10][];
        private int prefixAndFirstSuffixResultsCount = 0;
        private char[][] prefixAndSuffixResults = new char[10][];
        private int prefixAndSuffixResultsCount = 0;
        private char[][] firstPrefixResults = new char[10][];
        private int firstPrefixResultsCount = 0;
        private char[][] prefixResults = new char[10][];
        private int prefixResultsCount = 0;
        private char[][] firstSuffixResults = new char[10][];
        private int firstSuffixResultsCount = 0;
        private char[][] suffixResults = new char[10][];
        private int suffixResultsCount = 0;
        private char[][] otherResults = new char[10][];
        private int otherResultsCount = 0;

        NamingRequestor() {
        }

        public void acceptNameWithPrefixAndSuffix(char[] cArray, boolean bl, boolean bl2, int n) {
            if (bl && bl2) {
                int n2 = this.firstPrefixAndFirstSuffixResults.length;
                if (n2 == this.firstPrefixAndFirstSuffixResultsCount) {
                    char[][] cArrayArray = new char[n2 * 2][];
                    this.firstPrefixAndFirstSuffixResults = cArrayArray;
                    System.arraycopy(this.firstPrefixAndFirstSuffixResults, 0, cArrayArray, 0, n2);
                }
                this.firstPrefixAndFirstSuffixResults[this.firstPrefixAndFirstSuffixResultsCount++] = cArray;
            } else if (bl) {
                int n3 = this.firstPrefixAndSuffixResults.length;
                if (n3 == this.firstPrefixAndSuffixResultsCount) {
                    char[][] cArrayArray = new char[n3 * 2][];
                    this.firstPrefixAndSuffixResults = cArrayArray;
                    System.arraycopy(this.firstPrefixAndSuffixResults, 0, cArrayArray, 0, n3);
                }
                this.firstPrefixAndSuffixResults[this.firstPrefixAndSuffixResultsCount++] = cArray;
            } else if (bl2) {
                int n4 = this.prefixAndFirstSuffixResults.length;
                if (n4 == this.prefixAndFirstSuffixResultsCount) {
                    char[][] cArrayArray = new char[n4 * 2][];
                    this.prefixAndFirstSuffixResults = cArrayArray;
                    System.arraycopy(this.prefixAndFirstSuffixResults, 0, cArrayArray, 0, n4);
                }
                this.prefixAndFirstSuffixResults[this.prefixAndFirstSuffixResultsCount++] = cArray;
            } else {
                int n5 = this.prefixAndSuffixResults.length;
                if (n5 == this.prefixAndSuffixResultsCount) {
                    char[][] cArrayArray = new char[n5 * 2][];
                    this.prefixAndSuffixResults = cArrayArray;
                    System.arraycopy(this.prefixAndSuffixResults, 0, cArrayArray, 0, n5);
                }
                this.prefixAndSuffixResults[this.prefixAndSuffixResultsCount++] = cArray;
            }
        }

        public void acceptNameWithPrefix(char[] cArray, boolean bl, int n) {
            if (bl) {
                int n2 = this.firstPrefixResults.length;
                if (n2 == this.firstPrefixResultsCount) {
                    char[][] cArrayArray = new char[n2 * 2][];
                    this.firstPrefixResults = cArrayArray;
                    System.arraycopy(this.firstPrefixResults, 0, cArrayArray, 0, n2);
                }
                this.firstPrefixResults[this.firstPrefixResultsCount++] = cArray;
            } else {
                int n3 = this.prefixResults.length;
                if (n3 == this.prefixResultsCount) {
                    char[][] cArrayArray = new char[n3 * 2][];
                    this.prefixResults = cArrayArray;
                    System.arraycopy(this.prefixResults, 0, cArrayArray, 0, n3);
                }
                this.prefixResults[this.prefixResultsCount++] = cArray;
            }
        }

        public void acceptNameWithSuffix(char[] cArray, boolean bl, int n) {
            if (bl) {
                int n2 = this.firstSuffixResults.length;
                if (n2 == this.firstSuffixResultsCount) {
                    char[][] cArrayArray = new char[n2 * 2][];
                    this.firstSuffixResults = cArrayArray;
                    System.arraycopy(this.firstSuffixResults, 0, cArrayArray, 0, n2);
                }
                this.firstSuffixResults[this.firstSuffixResultsCount++] = cArray;
            } else {
                int n3 = this.suffixResults.length;
                if (n3 == this.suffixResultsCount) {
                    char[][] cArrayArray = new char[n3 * 2][];
                    this.suffixResults = cArrayArray;
                    System.arraycopy(this.suffixResults, 0, cArrayArray, 0, n3);
                }
                this.suffixResults[this.suffixResultsCount++] = cArray;
            }
        }

        public void acceptNameWithoutPrefixAndSuffix(char[] cArray, int n) {
            int n2 = this.otherResults.length;
            if (n2 == this.otherResultsCount) {
                char[][] cArrayArray = new char[n2 * 2][];
                this.otherResults = cArrayArray;
                System.arraycopy(this.otherResults, 0, cArrayArray, 0, n2);
            }
            this.otherResults[this.otherResultsCount++] = cArray;
        }

        public char[][] getResults() {
            int n = this.firstPrefixAndFirstSuffixResultsCount + this.firstPrefixAndSuffixResultsCount + this.prefixAndFirstSuffixResultsCount + this.prefixAndSuffixResultsCount + this.firstPrefixResultsCount + this.prefixResultsCount + this.firstSuffixResultsCount + this.suffixResultsCount + this.otherResultsCount;
            char[][] cArrayArray = new char[n][];
            int n2 = 0;
            System.arraycopy(this.firstPrefixAndFirstSuffixResults, 0, cArrayArray, n2, this.firstPrefixAndFirstSuffixResultsCount);
            System.arraycopy(this.firstPrefixAndSuffixResults, 0, cArrayArray, n2 += this.firstPrefixAndFirstSuffixResultsCount, this.firstPrefixAndSuffixResultsCount);
            System.arraycopy(this.prefixAndFirstSuffixResults, 0, cArrayArray, n2 += this.firstPrefixAndSuffixResultsCount, this.prefixAndFirstSuffixResultsCount);
            System.arraycopy(this.prefixAndSuffixResults, 0, cArrayArray, n2 += this.prefixAndFirstSuffixResultsCount, this.prefixAndSuffixResultsCount);
            System.arraycopy(this.firstPrefixResults, 0, cArrayArray, n2 += this.prefixAndSuffixResultsCount, this.firstPrefixResultsCount);
            System.arraycopy(this.prefixResults, 0, cArrayArray, n2 += this.firstPrefixResultsCount, this.prefixResultsCount);
            System.arraycopy(this.firstSuffixResults, 0, cArrayArray, n2 += this.prefixResultsCount, this.firstSuffixResultsCount);
            System.arraycopy(this.suffixResults, 0, cArrayArray, n2 += this.firstSuffixResultsCount, this.suffixResultsCount);
            System.arraycopy(this.otherResults, 0, cArrayArray, n2 += this.suffixResultsCount, this.otherResultsCount);
            return cArrayArray;
        }
    }
}

