/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTConverter;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTRecoveryPropagator;
import org.eclipse.wst.jsdt.core.dom.ASTRequestor;
import org.eclipse.wst.jsdt.core.dom.ASTSyntaxErrorPropagator;
import org.eclipse.wst.jsdt.core.dom.BindingResolver;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.CompilationUnitResolver;
import org.eclipse.wst.jsdt.core.dom.DefaultBindingResolver;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.NodeSearcher;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveryScanner;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveryScannerData;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;
import org.eclipse.wst.jsdt.internal.core.BasicCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.BinaryType;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.util.CodeSnippetParsingUtil;
import org.eclipse.wst.jsdt.internal.core.util.RecordedParsingInformation;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ASTParser {
    public static final int K_EXPRESSION = 1;
    public static final int K_STATEMENTS = 2;
    public static final int K_CLASS_BODY_DECLARATIONS = 4;
    public static final int K_COMPILATION_UNIT = 8;
    private final int apiLevel;
    private int astKind;
    private Map compilerOptions;
    private boolean resolveBindings;
    private boolean partial = false;
    private boolean statementsRecovery;
    private boolean bindingsRecovery;
    private int focalPointPosition;
    private char[] rawSource = null;
    private ITypeRoot typeRoot = null;
    private int sourceOffset = 0;
    private int sourceLength = -1;
    private WorkingCopyOwner workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
    private IJavaProject project = null;
    private String unitName = null;

    public static ASTParser newParser(int n) {
        return new ASTParser(n);
    }

    ASTParser(int n) {
        if (n != 2 && n != 3) {
            throw new IllegalArgumentException();
        }
        this.apiLevel = n;
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        this.astKind = 8;
        this.rawSource = null;
        this.typeRoot = null;
        this.resolveBindings = false;
        this.sourceLength = -1;
        this.sourceOffset = 0;
        this.workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
        this.unitName = null;
        this.project = null;
        this.partial = false;
        Hashtable hashtable = JavaCore.getOptions();
        hashtable.remove("org.eclipse.wst.jsdt.core.compiler.taskTags");
        this.compilerOptions = hashtable;
    }

    public void setBindingsRecovery(boolean bl) {
        this.bindingsRecovery = bl;
    }

    public void setCompilerOptions(Map map) {
        map = map == null ? JavaCore.getOptions() : new HashMap(map);
        map.remove("org.eclipse.wst.jsdt.core.compiler.taskTags");
        this.compilerOptions = map;
    }

    public void setResolveBindings(boolean bl) {
        this.resolveBindings = bl;
    }

    public void setFocalPosition(int n) {
        this.partial = true;
        this.focalPointPosition = n;
    }

    public void setKind(int n) {
        if (n != 8 && n != 4 && n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        this.astKind = n;
    }

    public void setSource(char[] cArray) {
        this.rawSource = cArray;
        this.typeRoot = null;
    }

    public void setSource(ICompilationUnit iCompilationUnit) {
        this.setSource((ITypeRoot)iCompilationUnit);
    }

    public void setSource(IClassFile iClassFile) {
        this.setSource((ITypeRoot)iClassFile);
    }

    public void setSource(ITypeRoot iTypeRoot) {
        this.typeRoot = iTypeRoot;
        this.rawSource = null;
        if (iTypeRoot != null) {
            this.project = iTypeRoot.getJavaProject();
            Map map = this.project.getOptions(true);
            map.remove("org.eclipse.wst.jsdt.core.compiler.taskTags");
            this.compilerOptions = map;
        }
    }

    public void setSourceRange(int n, int n2) {
        if (n < 0 || n2 < -1) {
            throw new IllegalArgumentException();
        }
        this.sourceOffset = n;
        this.sourceLength = n2;
    }

    public void setStatementsRecovery(boolean bl) {
        this.statementsRecovery = bl;
    }

    public void setWorkingCopyOwner(WorkingCopyOwner workingCopyOwner) {
        this.workingCopyOwner = workingCopyOwner == null ? DefaultWorkingCopyOwner.PRIMARY : workingCopyOwner;
    }

    public void setUnitName(String string) {
        this.unitName = string;
    }

    public void setProject(IJavaProject iJavaProject) {
        this.project = iJavaProject;
        if (iJavaProject != null) {
            Map map = iJavaProject.getOptions(true);
            map.remove("org.eclipse.wst.jsdt.core.compiler.taskTags");
            this.compilerOptions = map;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ASTNode createAST(IProgressMonitor iProgressMonitor) {
        ASTNode aSTNode = null;
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask("", 1);
        }
        try {
            if (this.rawSource == null && this.typeRoot == null) {
                throw new IllegalStateException("source not specified");
            }
            aSTNode = this.internalCreateAST(iProgressMonitor);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.initializeDefaults();
            if (iProgressMonitor == null) throw throwable;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.initializeDefaults();
            if (iProgressMonitor == null) return aSTNode;
        }
        iProgressMonitor.done();
        return aSTNode;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createASTs(ICompilationUnit[] iCompilationUnitArray, String[] stringArray, ASTRequestor aSTRequestor, IProgressMonitor iProgressMonitor) {
        try {
            int n = 0;
            if (this.statementsRecovery) {
                n |= 2;
            }
            if (this.resolveBindings) {
                if (this.project == null) {
                    throw new IllegalStateException("project not specified");
                }
                if (this.bindingsRecovery) {
                    n |= 4;
                }
                CompilationUnitResolver.resolve(iCompilationUnitArray, stringArray, aSTRequestor, this.apiLevel, this.compilerOptions, this.project, this.workingCopyOwner, n, iProgressMonitor);
            } else {
                CompilationUnitResolver.parse(iCompilationUnitArray, aSTRequestor, this.apiLevel, this.compilerOptions, n, iProgressMonitor);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.initializeDefaults();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.initializeDefaults();
            return;
        }
    }

    public IBinding[] createBindings(IJavaElement[] iJavaElementArray, IProgressMonitor iProgressMonitor) {
        try {
            if (this.project == null) {
                throw new IllegalStateException("project not specified");
            }
            int n = 0;
            if (this.statementsRecovery) {
                n |= 2;
            }
            if (this.bindingsRecovery) {
                n |= 4;
            }
            IBinding[] iBindingArray = CompilationUnitResolver.resolve(iJavaElementArray, this.apiLevel, this.compilerOptions, this.project, this.workingCopyOwner, n, iProgressMonitor);
            Object var4_5 = null;
            this.initializeDefaults();
            return iBindingArray;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.initializeDefaults();
            throw throwable;
        }
    }

    private ASTNode internalCreateAST(IProgressMonitor iProgressMonitor) {
        boolean bl = this.resolveBindings;
        switch (this.astKind) {
            case 1: 
            case 2: 
            case 4: {
                if (this.rawSource == null) break;
                if (this.sourceOffset + this.sourceLength > this.rawSource.length) {
                    throw new IllegalStateException();
                }
                return this.internalCreateASTForKind();
            }
            case 8: {
                CompilationUnitDeclaration compilationUnitDeclaration = null;
                try {
                    Object object;
                    NodeSearcher nodeSearcher = null;
                    org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit iCompilationUnit = null;
                    WorkingCopyOwner workingCopyOwner = this.workingCopyOwner;
                    if (this.typeRoot instanceof ICompilationUnit) {
                        iCompilationUnit = (org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit)((Object)this.typeRoot);
                        iCompilationUnit = new BasicCompilationUnit(iCompilationUnit.getContents(), iCompilationUnit.getPackageName(), new String(iCompilationUnit.getFileName()), this.project);
                        workingCopyOwner = ((ICompilationUnit)this.typeRoot).getOwner();
                    } else if (this.typeRoot instanceof IClassFile) {
                        try {
                            String string = this.typeRoot.getSource();
                            if (string == null) {
                                throw new IllegalStateException();
                            }
                            object = (PackageFragment)this.typeRoot.getParent();
                            BinaryType cfr_ignored_0 = (BinaryType)this.typeRoot.findPrimaryType();
                            char[] cArray = this.typeRoot.getElementName().toCharArray();
                            iCompilationUnit = new BasicCompilationUnit(string.toCharArray(), Util.toCharArrays(((PackageFragment)object).names), new String(cArray), this.project);
                        }
                        catch (JavaModelException javaModelException) {
                            throw new IllegalStateException();
                        }
                    } else if (this.rawSource != null) {
                        bl = this.resolveBindings && this.unitName != null && this.project != null && this.compilerOptions != null;
                        iCompilationUnit = new BasicCompilationUnit(this.rawSource, null, this.unitName == null ? "" : this.unitName, this.project);
                    } else {
                        throw new IllegalStateException();
                    }
                    if (this.partial) {
                        nodeSearcher = new NodeSearcher(this.focalPointPosition);
                    }
                    int n = 0;
                    if (this.statementsRecovery) {
                        n |= 2;
                    }
                    if (bl) {
                        if (this.bindingsRecovery) {
                            n |= 4;
                        }
                        try {
                            compilationUnitDeclaration = CompilationUnitResolver.resolve(iCompilationUnit, this.project, nodeSearcher, this.compilerOptions, this.workingCopyOwner, n, iProgressMonitor);
                        }
                        catch (JavaModelException javaModelException) {
                            compilationUnitDeclaration = CompilationUnitResolver.parse(iCompilationUnit, nodeSearcher, this.compilerOptions, n &= 0xFFFFFFFB);
                            bl = false;
                        }
                    } else {
                        compilationUnitDeclaration = CompilationUnitResolver.parse(iCompilationUnit, nodeSearcher, this.compilerOptions, n);
                        bl = false;
                    }
                    object = CompilationUnitResolver.convert(compilationUnitDeclaration, iCompilationUnit.getContents(), this.apiLevel, this.compilerOptions, bl, workingCopyOwner, bl ? new DefaultBindingResolver.BindingTables() : null, n, iProgressMonitor);
                    ((CompilationUnit)object).setTypeRoot(this.typeRoot);
                    Object object2 = object;
                    Object var10_12 = null;
                    if (compilationUnitDeclaration != null && this.resolveBindings) {
                        compilationUnitDeclaration.cleanUp();
                        if (compilationUnitDeclaration.scope != null) {
                            compilationUnitDeclaration.scope.cleanup();
                        }
                    }
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    if (compilationUnitDeclaration != null && this.resolveBindings) {
                        compilationUnitDeclaration.cleanUp();
                        if (compilationUnitDeclaration.scope != null) {
                            compilationUnitDeclaration.scope.cleanup();
                        }
                    }
                    throw throwable;
                }
            }
        }
        throw new IllegalStateException();
    }

    private ASTNode internalCreateASTForKind() {
        ASTConverter aSTConverter = new ASTConverter(this.compilerOptions, false, null);
        aSTConverter.compilationUnitSource = this.rawSource;
        aSTConverter.compilationUnitSourceLength = this.rawSource.length;
        aSTConverter.scanner.setSource(this.rawSource);
        AST aST = AST.newAST(this.apiLevel);
        aST.setDefaultNodeFlag(2);
        aST.setBindingResolver(new BindingResolver());
        if (this.statementsRecovery) {
            aST.setFlag(2);
        }
        aSTConverter.setAST(aST);
        CodeSnippetParsingUtil codeSnippetParsingUtil = new CodeSnippetParsingUtil();
        CompilationUnit compilationUnit = aST.newCompilationUnit();
        if (this.sourceLength == -1) {
            this.sourceLength = this.rawSource.length;
        }
        switch (this.astKind) {
            case 2: {
                Object object;
                ConstructorDeclaration constructorDeclaration = codeSnippetParsingUtil.parseStatements(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true, this.statementsRecovery);
                RecoveryScannerData recoveryScannerData = constructorDeclaration.compilationResult.recoveryScannerData;
                if (recoveryScannerData != null) {
                    object = aSTConverter.scanner;
                    aSTConverter.docParser.scanner = aSTConverter.scanner = new RecoveryScanner((Scanner)object, recoveryScannerData.removeUnused());
                    aSTConverter.scanner.setSource(((Scanner)object).source);
                }
                object = codeSnippetParsingUtil.recordedParsingInformation;
                int[][] nArray = ((RecordedParsingInformation)object).commentPositions;
                if (nArray != null) {
                    aSTConverter.buildCommentsTable(compilationUnit, nArray);
                }
                compilationUnit.setLineEndTable(((RecordedParsingInformation)object).lineEnds);
                Block block = aST.newBlock();
                block.setSourceRange(this.sourceOffset, this.sourceOffset + this.sourceLength);
                ProgramElement[] programElementArray = constructorDeclaration.statements;
                if (programElementArray != null) {
                    int n = programElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        if (programElementArray[n2] instanceof LocalDeclaration) {
                            aSTConverter.checkAndAddMultipleLocalDeclaration(programElementArray, n2, block.statements());
                        } else {
                            Statement statement = aSTConverter.convert(programElementArray[n2]);
                            if (statement != null) {
                                block.statements().add(statement);
                            }
                        }
                        ++n2;
                    }
                }
                this.rootNodeToCompilationUnit(aST, compilationUnit, block, (RecordedParsingInformation)object, recoveryScannerData);
                aST.setDefaultNodeFlag(0);
                aST.setOriginalModificationCount(aST.modificationCount());
                return block;
            }
            case 1: {
                org.eclipse.wst.jsdt.internal.compiler.ast.Expression expression = codeSnippetParsingUtil.parseExpression(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true);
                RecordedParsingInformation recordedParsingInformation = codeSnippetParsingUtil.recordedParsingInformation;
                int[][] nArray = recordedParsingInformation.commentPositions;
                if (nArray != null) {
                    aSTConverter.buildCommentsTable(compilationUnit, nArray);
                }
                compilationUnit.setLineEndTable(recordedParsingInformation.lineEnds);
                if (expression != null) {
                    Expression expression2 = aSTConverter.convert(expression);
                    this.rootNodeToCompilationUnit(expression2.getAST(), compilationUnit, expression2, codeSnippetParsingUtil.recordedParsingInformation, null);
                    aST.setDefaultNodeFlag(0);
                    aST.setOriginalModificationCount(aST.modificationCount());
                    return expression2;
                }
                IProblem[] iProblemArray = recordedParsingInformation.problems;
                if (iProblemArray != null) {
                    compilationUnit.setProblems(iProblemArray);
                }
                aST.setDefaultNodeFlag(0);
                aST.setOriginalModificationCount(aST.modificationCount());
                return compilationUnit;
            }
            case 4: {
                org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode[] aSTNodeArray = codeSnippetParsingUtil.parseClassBodyDeclarations(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true);
                RecordedParsingInformation recordedParsingInformation = codeSnippetParsingUtil.recordedParsingInformation;
                int[][] nArray = recordedParsingInformation.commentPositions;
                if (nArray != null) {
                    aSTConverter.buildCommentsTable(compilationUnit, nArray);
                }
                compilationUnit.setLineEndTable(recordedParsingInformation.lineEnds);
                if (aSTNodeArray != null) {
                    CompilationUnit compilationUnit2 = aSTConverter.convert(aSTNodeArray, compilationUnit);
                    this.rootNodeToCompilationUnit(compilationUnit2.getAST(), compilationUnit, compilationUnit2, codeSnippetParsingUtil.recordedParsingInformation, null);
                    aST.setDefaultNodeFlag(0);
                    aST.setOriginalModificationCount(aST.modificationCount());
                    return compilationUnit;
                }
                IProblem[] iProblemArray = recordedParsingInformation.problems;
                if (iProblemArray != null) {
                    compilationUnit.setProblems(iProblemArray);
                }
                aST.setDefaultNodeFlag(0);
                aST.setOriginalModificationCount(aST.modificationCount());
                return compilationUnit;
            }
        }
        throw new IllegalStateException();
    }

    private void propagateErrors(ASTNode aSTNode, CategorizedProblem[] categorizedProblemArray, RecoveryScannerData recoveryScannerData) {
        aSTNode.accept(new ASTSyntaxErrorPropagator(categorizedProblemArray));
        if (recoveryScannerData != null) {
            aSTNode.accept(new ASTRecoveryPropagator(categorizedProblemArray, recoveryScannerData));
        }
    }

    private void rootNodeToCompilationUnit(AST aST, CompilationUnit compilationUnit, ASTNode aSTNode, RecordedParsingInformation recordedParsingInformation, RecoveryScannerData recoveryScannerData) {
        int n = recordedParsingInformation.problemsCount;
        switch (aSTNode.getNodeType()) {
            case 8: {
                CategorizedProblem[] categorizedProblemArray;
                Block block = (Block)aSTNode;
                if (n != 0) {
                    categorizedProblemArray = recordedParsingInformation.problems;
                    this.propagateErrors(block, categorizedProblemArray, recoveryScannerData);
                    compilationUnit.setProblems(categorizedProblemArray);
                }
                categorizedProblemArray = aST.newTypeDeclaration();
                Initializer initializer = aST.newInitializer();
                initializer.setBody(block);
                categorizedProblemArray.bodyDeclarations().add(initializer);
                compilationUnit.types().add(categorizedProblemArray);
                break;
            }
            case 15: {
                int n2;
                CompilationUnit compilationUnit2 = (CompilationUnit)aSTNode;
                if (n != 0) {
                    IProblem[] iProblemArray = recordedParsingInformation.problems;
                    n2 = 0;
                    int n3 = compilationUnit2.statements().size();
                    while (n2 < n3) {
                        this.propagateErrors((ASTNode)compilationUnit2.statements().get(n2), (CategorizedProblem[])iProblemArray, recoveryScannerData);
                        ++n2;
                    }
                    compilationUnit.setProblems(iProblemArray);
                }
                if (compilationUnit == aSTNode) break;
                int n4 = 0;
                n2 = compilationUnit2.statements().size();
                while (n4 < n2) {
                    compilationUnit.statements().add(compilationUnit2.statements().get(n4));
                    ++n4;
                }
                break;
            }
            case 55: {
                TypeDeclaration typeDeclaration = (TypeDeclaration)aSTNode;
                if (n != 0) {
                    IProblem[] iProblemArray = recordedParsingInformation.problems;
                    this.propagateErrors(typeDeclaration, (CategorizedProblem[])iProblemArray, recoveryScannerData);
                    compilationUnit.setProblems(iProblemArray);
                }
                compilationUnit.types().add(typeDeclaration);
                break;
            }
            default: {
                CategorizedProblem[] categorizedProblemArray;
                if (!(aSTNode instanceof Expression)) break;
                Expression expression = (Expression)aSTNode;
                if (n != 0) {
                    categorizedProblemArray = recordedParsingInformation.problems;
                    this.propagateErrors(expression, categorizedProblemArray, recoveryScannerData);
                    compilationUnit.setProblems(categorizedProblemArray);
                }
                categorizedProblemArray = aST.newExpressionStatement(expression);
                Block block = aST.newBlock();
                block.statements().add(categorizedProblemArray);
                Initializer initializer = aST.newInitializer();
                initializer.setBody(block);
                TypeDeclaration typeDeclaration = aST.newTypeDeclaration();
                typeDeclaration.bodyDeclarations().add(initializer);
                compilationUnit.types().add(typeDeclaration);
            }
        }
    }
}

