/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.HashSet;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.WildcardBinding;

class BindingComparator {
    BindingComparator() {
    }

    static boolean isEqual(TypeVariableBinding[] typeVariableBindingArray, TypeVariableBinding[] typeVariableBindingArray2) {
        if (typeVariableBindingArray == null) {
            return typeVariableBindingArray2 == null;
        }
        if (typeVariableBindingArray2 == null) {
            return false;
        }
        int n = typeVariableBindingArray.length;
        int n2 = typeVariableBindingArray2.length;
        if (n != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            TypeVariableBinding typeVariableBinding = typeVariableBindingArray[n3];
            TypeVariableBinding typeVariableBinding2 = typeVariableBindingArray2[n3];
            if (!BindingComparator.isEqual(typeVariableBinding, typeVariableBinding2)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    static boolean isEqual(Binding binding, Binding binding2, HashSet hashSet) {
        if (binding instanceof TypeBinding) {
            if (!(binding2 instanceof TypeBinding)) {
                return false;
            }
            return BindingComparator.isEqual((TypeBinding)binding, (TypeBinding)binding2, hashSet);
        }
        if (binding instanceof MethodBinding) {
            if (!(binding2 instanceof MethodBinding)) {
                return false;
            }
            return BindingComparator.isEqual((MethodBinding)binding, (MethodBinding)binding2, hashSet);
        }
        if (binding instanceof VariableBinding) {
            if (!(binding2 instanceof VariableBinding)) {
                return false;
            }
            return BindingComparator.isEqual((VariableBinding)binding, (VariableBinding)binding2);
        }
        if (binding instanceof PackageBinding) {
            if (!(binding2 instanceof PackageBinding)) {
                return false;
            }
            PackageBinding packageBinding = (PackageBinding)binding;
            PackageBinding packageBinding2 = (PackageBinding)binding2;
            return CharOperation.equals(packageBinding.compoundName, packageBinding2.compoundName);
        }
        if (binding instanceof ImportBinding) {
            if (!(binding2 instanceof ImportBinding)) {
                return false;
            }
            ImportBinding importBinding = (ImportBinding)binding;
            ImportBinding importBinding2 = (ImportBinding)binding2;
            return importBinding.isStatic() == importBinding2.isStatic() && importBinding.onDemand == importBinding2.onDemand && CharOperation.equals(importBinding.compoundName, importBinding2.compoundName);
        }
        return false;
    }

    static boolean isEqual(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return BindingComparator.isEqual(methodBinding, methodBinding2, new HashSet());
    }

    static boolean isEqual(MethodBinding methodBinding, MethodBinding methodBinding2, HashSet hashSet) {
        if (methodBinding == null) {
            return methodBinding2 == null;
        }
        if (methodBinding2 == null) {
            return false;
        }
        if (CharOperation.equals(methodBinding.selector, methodBinding2.selector) && BindingComparator.isEqual(methodBinding.returnType, methodBinding2.returnType, hashSet) && BindingComparator.isEqual(methodBinding.declaringClass, methodBinding2.declaringClass, hashSet) && BindingComparator.isEqual(methodBinding.parameters, methodBinding2.parameters, hashSet)) {
            return true;
        }
        MethodBinding methodBinding3 = null;
        MethodBinding methodBinding4 = null;
        if (methodBinding.selector == TypeConstants.INIT) {
            methodBinding3 = methodBinding;
            methodBinding4 = methodBinding2;
        } else if (methodBinding2.selector == TypeConstants.INIT) {
            methodBinding3 = methodBinding2;
            methodBinding4 = methodBinding;
        }
        return methodBinding3 != null && CharOperation.equals(methodBinding4.selector, methodBinding3.declaringClass.sourceName) && BindingComparator.isEqual(methodBinding4.parameters, methodBinding3.parameters, hashSet);
    }

    static boolean isEqual(VariableBinding variableBinding, VariableBinding variableBinding2) {
        return (variableBinding.modifiers & 0xFFFF) == (variableBinding2.modifiers & 0xFFFF) && CharOperation.equals(variableBinding.name, variableBinding2.name) && BindingComparator.isEqual(variableBinding.type, variableBinding2.type) && variableBinding.id == variableBinding2.id;
    }

    static boolean isEqual(FieldBinding fieldBinding, FieldBinding fieldBinding2) {
        HashSet hashSet = new HashSet();
        return (fieldBinding.modifiers & 0xFFFF) == (fieldBinding2.modifiers & 0xFFFF) && CharOperation.equals(fieldBinding.name, fieldBinding2.name) && BindingComparator.isEqual(fieldBinding.type, fieldBinding2.type, hashSet) && BindingComparator.isEqual(fieldBinding.declaringClass, fieldBinding2.declaringClass, hashSet);
    }

    static boolean isEqual(TypeBinding[] typeBindingArray, TypeBinding[] typeBindingArray2) {
        return BindingComparator.isEqual(typeBindingArray, typeBindingArray2, new HashSet());
    }

    static boolean isEqual(TypeBinding[] typeBindingArray, TypeBinding[] typeBindingArray2, HashSet hashSet) {
        if (typeBindingArray == null) {
            return typeBindingArray2 == null;
        }
        if (typeBindingArray2 == null) {
            return false;
        }
        int n = typeBindingArray.length;
        int n2 = typeBindingArray2.length;
        if (n != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            if (!BindingComparator.isEqual(typeBindingArray[n3], typeBindingArray2[n3], hashSet)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    static boolean isEqual(TypeBinding typeBinding, TypeBinding typeBinding2, HashSet hashSet) {
        if (typeBinding == typeBinding2) {
            return true;
        }
        if (typeBinding == null || typeBinding2 == null) {
            return false;
        }
        switch (typeBinding.kind()) {
            case 132: {
                if (!typeBinding2.isBaseType()) {
                    return false;
                }
                return typeBinding.id == typeBinding2.id;
            }
            case 68: {
                if (!typeBinding2.isArrayType()) {
                    return false;
                }
                return typeBinding.dimensions() == typeBinding2.dimensions() && BindingComparator.isEqual(typeBinding.leafComponentType(), typeBinding2.leafComponentType(), hashSet);
            }
            case 260: {
                if (!typeBinding2.isParameterizedType()) {
                    return false;
                }
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
                ParameterizedTypeBinding parameterizedTypeBinding2 = (ParameterizedTypeBinding)typeBinding2;
                return CharOperation.equals(parameterizedTypeBinding.compoundName, parameterizedTypeBinding2.compoundName) && (parameterizedTypeBinding.modifiers & 0xFFFF) == (parameterizedTypeBinding2.modifiers & 0xFFFF) && BindingComparator.isEqual(parameterizedTypeBinding.arguments, parameterizedTypeBinding2.arguments, hashSet) && BindingComparator.isEqual(parameterizedTypeBinding.enclosingType(), parameterizedTypeBinding2.enclosingType(), hashSet);
            }
            case 516: {
                if (!typeBinding2.isWildcard()) {
                    return false;
                }
                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                WildcardBinding wildcardBinding2 = (WildcardBinding)typeBinding2;
                return BindingComparator.isEqual(wildcardBinding.bound, wildcardBinding2.bound, hashSet) && wildcardBinding.boundKind == wildcardBinding2.boundKind;
            }
            case 4100: {
                if (!typeBinding2.isTypeVariable()) {
                    return false;
                }
                if (typeBinding.isCapture()) {
                    if (!typeBinding2.isCapture()) {
                        return false;
                    }
                    CaptureBinding captureBinding = (CaptureBinding)typeBinding;
                    CaptureBinding captureBinding2 = (CaptureBinding)typeBinding2;
                    if (captureBinding.position == captureBinding2.position) {
                        if (hashSet.contains(typeBinding)) {
                            return true;
                        }
                        hashSet.add(typeBinding);
                        return BindingComparator.isEqual(captureBinding.wildcard, captureBinding2.wildcard, hashSet) && BindingComparator.isEqual(captureBinding.sourceType, captureBinding2.sourceType, hashSet);
                    }
                    return false;
                }
                TypeVariableBinding typeVariableBinding = (TypeVariableBinding)typeBinding;
                TypeVariableBinding typeVariableBinding2 = (TypeVariableBinding)typeBinding2;
                if (CharOperation.equals(typeVariableBinding.sourceName, typeVariableBinding2.sourceName)) {
                    if (hashSet.contains(typeBinding)) {
                        return true;
                    }
                    hashSet.add(typeBinding);
                    return BindingComparator.isEqual(typeVariableBinding.declaringElement, typeVariableBinding2.declaringElement, hashSet) && BindingComparator.isEqual(typeVariableBinding.superclass(), typeVariableBinding2.superclass(), hashSet) && BindingComparator.isEqual(typeVariableBinding.superInterfaces(), typeVariableBinding2.superInterfaces(), hashSet);
                }
                return false;
            }
            case 2052: {
                if (!typeBinding2.isGenericType()) {
                    return false;
                }
                ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
                ReferenceBinding referenceBinding2 = (ReferenceBinding)typeBinding2;
                return CharOperation.equals(referenceBinding.compoundName, referenceBinding2.compoundName) && (referenceBinding.modifiers & 0xFFFF) == (referenceBinding2.modifiers & 0xFFFF) && BindingComparator.isEqual(referenceBinding.typeVariables(), referenceBinding2.typeVariables(), hashSet) && BindingComparator.isEqual(referenceBinding.enclosingType(), referenceBinding2.enclosingType(), hashSet);
            }
        }
        if (!(typeBinding2 instanceof ReferenceBinding)) {
            return false;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        ReferenceBinding referenceBinding3 = (ReferenceBinding)typeBinding2;
        char[] cArray = referenceBinding.constantPoolName();
        char[] cArray2 = referenceBinding3.constantPoolName();
        if (cArray == null) {
            if (cArray2 != null) {
                return false;
            }
            if (!CharOperation.equals(referenceBinding.computeUniqueKey(), referenceBinding3.computeUniqueKey())) {
                return false;
            }
        } else {
            if (cArray2 == null) {
                return false;
            }
            if (!CharOperation.equals(cArray, cArray2)) {
                return false;
            }
        }
        return CharOperation.equals(referenceBinding.compoundName, referenceBinding3.compoundName) && !referenceBinding3.isGenericType() && referenceBinding.isRawType() == referenceBinding3.isRawType() && (referenceBinding.modifiers & 0xFFFFFFDF & 0xFFFF) == (referenceBinding3.modifiers & 0xFFFFFFDF & 0xFFFF) && BindingComparator.isEqual(referenceBinding.enclosingType(), referenceBinding3.enclosingType(), hashSet);
    }

    static boolean isEqual(TypeBinding typeBinding, TypeBinding typeBinding2) {
        return BindingComparator.isEqual(typeBinding, typeBinding2, new HashSet());
    }
}

