/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.List;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AnnotationBinding;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.BindingResolver;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IAnnotationBinding;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeBinding;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;

class RecoveredTypeBinding
implements ITypeBinding {
    private VariableDeclaration variableDeclaration;
    private Type currentType;
    private BindingResolver resolver;
    private int dimensions;
    private RecoveredTypeBinding innerTypeBinding;
    private ITypeBinding[] typeArguments;
    private org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding referenceBinding;

    RecoveredTypeBinding(BindingResolver bindingResolver, VariableDeclaration variableDeclaration) {
        this.variableDeclaration = variableDeclaration;
        this.resolver = bindingResolver;
        this.currentType = this.getType();
        this.dimensions = variableDeclaration.getExtraDimensions();
        if (this.currentType.isArrayType()) {
            this.dimensions += ((ArrayType)this.currentType).getDimensions();
        }
    }

    RecoveredTypeBinding(BindingResolver bindingResolver, org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding typeBinding) {
        this.resolver = bindingResolver;
        this.dimensions = typeBinding.dimensions();
        this.referenceBinding = typeBinding;
    }

    RecoveredTypeBinding(BindingResolver bindingResolver, Type type) {
        this.currentType = type;
        this.resolver = bindingResolver;
        this.dimensions = 0;
        if (type.isArrayType()) {
            this.dimensions += ((ArrayType)type).getDimensions();
        }
    }

    RecoveredTypeBinding(BindingResolver bindingResolver, RecoveredTypeBinding recoveredTypeBinding, int n) {
        this.innerTypeBinding = recoveredTypeBinding;
        this.dimensions = recoveredTypeBinding.getDimensions() + n;
        this.resolver = bindingResolver;
    }

    public ITypeBinding createArrayType(int n) {
        return this.resolver.getTypeBinding(this, n);
    }

    public String getBinaryName() {
        return null;
    }

    public ITypeBinding getBound() {
        return null;
    }

    public ITypeBinding getComponentType() {
        if (this.dimensions == 0) {
            return null;
        }
        return this.resolver.getTypeBinding(this, -1);
    }

    public IVariableBinding[] getDeclaredFields() {
        return TypeBinding.NO_VARIABLE_BINDINGS;
    }

    public IMethodBinding[] getDeclaredMethods() {
        return TypeBinding.NO_METHOD_BINDINGS;
    }

    public int getDeclaredModifiers() {
        return 0;
    }

    public ITypeBinding[] getDeclaredTypes() {
        return TypeBinding.NO_TYPE_BINDINGS;
    }

    public ITypeBinding getDeclaringClass() {
        return null;
    }

    public IMethodBinding getDeclaringMethod() {
        return null;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public ITypeBinding getElementType() {
        if (this.referenceBinding != null) {
            if (this.referenceBinding.isArrayType()) {
                ArrayBinding arrayBinding = (ArrayBinding)this.referenceBinding;
                return new RecoveredTypeBinding(this.resolver, arrayBinding.leafComponentType);
            }
            return new RecoveredTypeBinding(this.resolver, this.referenceBinding);
        }
        if (this.innerTypeBinding != null) {
            return this.innerTypeBinding.getElementType();
        }
        if (this.currentType != null && this.currentType.isArrayType()) {
            return this.resolver.getTypeBinding(((ArrayType)this.currentType).getElementType());
        }
        if (this.variableDeclaration != null && this.variableDeclaration.getExtraDimensions() != 0) {
            return this.resolver.getTypeBinding(this.getType());
        }
        return null;
    }

    public ITypeBinding getErasure() {
        return this;
    }

    public ITypeBinding[] getInterfaces() {
        return TypeBinding.NO_TYPE_BINDINGS;
    }

    public int getModifiers() {
        return 0;
    }

    public String getName() {
        char[] cArray = new char[this.dimensions * 2];
        int n = this.dimensions * 2 - 1;
        while (n >= 0) {
            cArray[n] = 93;
            cArray[n - 1] = 91;
            n -= 2;
        }
        StringBuffer stringBuffer = new StringBuffer(this.getInternalName());
        stringBuffer.append(cArray);
        return String.valueOf(stringBuffer);
    }

    private String getInternalName() {
        if (this.innerTypeBinding != null) {
            return this.innerTypeBinding.getInternalName();
        }
        if (this.referenceBinding != null) {
            ReferenceBinding referenceBinding = null;
            if (this.referenceBinding.isArrayType()) {
                ArrayBinding arrayBinding = (ArrayBinding)this.referenceBinding;
                if (arrayBinding.leafComponentType instanceof ReferenceBinding) {
                    referenceBinding = (ReferenceBinding)arrayBinding.leafComponentType;
                }
            } else if (this.referenceBinding instanceof ReferenceBinding) {
                referenceBinding = (ReferenceBinding)this.referenceBinding;
            }
            return new String(referenceBinding.compoundName[referenceBinding.compoundName.length - 1]);
        }
        return this.getTypeNameFrom(this.getType());
    }

    public IPackageBinding getPackage() {
        CompilationUnitScope compilationUnitScope = this.resolver.scope();
        if (compilationUnitScope != null) {
            return this.resolver.getPackageBinding(compilationUnitScope.getCurrentPackage());
        }
        return null;
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public ITypeBinding getSuperclass() {
        return this.resolver.resolveWellKnownType("java.lang.Object");
    }

    public ITypeBinding[] getTypeArguments() {
        if (this.referenceBinding != null) {
            this.typeArguments = TypeBinding.NO_TYPE_BINDINGS;
            return TypeBinding.NO_TYPE_BINDINGS;
        }
        if (this.typeArguments != null) {
            return this.typeArguments;
        }
        if (this.innerTypeBinding != null) {
            return this.innerTypeBinding.getTypeArguments();
        }
        if (this.currentType.isParameterizedType()) {
            ParameterizedType parameterizedType = (ParameterizedType)this.currentType;
            List list = parameterizedType.typeArguments();
            int n = list.size();
            ITypeBinding[] iTypeBindingArray = new ITypeBinding[n];
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding iTypeBinding = ((Type)list.get(n2)).resolveBinding();
                if (iTypeBinding == null) {
                    this.typeArguments = TypeBinding.NO_TYPE_BINDINGS;
                    return TypeBinding.NO_TYPE_BINDINGS;
                }
                iTypeBindingArray[n2] = iTypeBinding;
                ++n2;
            }
            this.typeArguments = iTypeBindingArray;
            return iTypeBindingArray;
        }
        this.typeArguments = TypeBinding.NO_TYPE_BINDINGS;
        return TypeBinding.NO_TYPE_BINDINGS;
    }

    public ITypeBinding[] getTypeBounds() {
        return TypeBinding.NO_TYPE_BINDINGS;
    }

    public ITypeBinding getTypeDeclaration() {
        return this;
    }

    public ITypeBinding[] getTypeParameters() {
        return TypeBinding.NO_TYPE_BINDINGS;
    }

    public ITypeBinding getWildcard() {
        return null;
    }

    public boolean isAnnotation() {
        return false;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isAssignmentCompatible(ITypeBinding iTypeBinding) {
        if ("java.lang.Object".equals(iTypeBinding.getQualifiedName())) {
            return true;
        }
        return this.isEqualTo(iTypeBinding);
    }

    public boolean isCapture() {
        return false;
    }

    public boolean isCastCompatible(ITypeBinding iTypeBinding) {
        if ("java.lang.Object".equals(iTypeBinding.getQualifiedName())) {
            return true;
        }
        return this.isEqualTo(iTypeBinding);
    }

    public boolean isClass() {
        return true;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isFromSource() {
        return false;
    }

    public boolean isGenericType() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isMember() {
        return false;
    }

    public boolean isNested() {
        return false;
    }

    public boolean isNullType() {
        return false;
    }

    public boolean isParameterizedType() {
        if (this.innerTypeBinding != null) {
            return this.innerTypeBinding.isParameterizedType();
        }
        if (this.currentType != null) {
            return this.currentType.isParameterizedType();
        }
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isRawType() {
        return false;
    }

    public boolean isSubTypeCompatible(ITypeBinding iTypeBinding) {
        if ("java.lang.Object".equals(iTypeBinding.getQualifiedName())) {
            return true;
        }
        return this.isEqualTo(iTypeBinding);
    }

    public boolean isTopLevel() {
        return true;
    }

    public boolean isTypeVariable() {
        return false;
    }

    public boolean isUpperbound() {
        return false;
    }

    public boolean isWildcardType() {
        return false;
    }

    public IAnnotationBinding[] getAnnotations() {
        return AnnotationBinding.NoAnnotations;
    }

    public IJavaElement getJavaElement() {
        try {
            return new CompilationUnit(null, this.getInternalName(), this.resolver.getWorkingCopyOwner()).getWorkingCopy(this.resolver.getWorkingCopyOwner(), null);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public String getKey() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Recovered#");
        if (this.innerTypeBinding != null) {
            stringBuffer.append("innerTypeBinding").append(this.innerTypeBinding.getKey());
        } else if (this.currentType != null) {
            stringBuffer.append("currentType").append(this.currentType.toString());
        } else if (this.referenceBinding != null) {
            stringBuffer.append("referenceBinding").append(this.referenceBinding.computeUniqueKey());
        } else if (this.variableDeclaration != null) {
            stringBuffer.append("variableDeclaration").append(this.variableDeclaration.getClass()).append(this.variableDeclaration.getName().getIdentifier()).append(this.variableDeclaration.getExtraDimensions());
        }
        stringBuffer.append(this.getDimensions());
        if (this.typeArguments != null) {
            stringBuffer.append('<');
            int n = 0;
            int n2 = this.typeArguments.length;
            while (n < n2) {
                if (n != 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.typeArguments[n].getKey());
                ++n;
            }
            stringBuffer.append('>');
        }
        return String.valueOf(stringBuffer);
    }

    public int getKind() {
        return 2;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isEqualTo(IBinding iBinding) {
        if (!iBinding.isRecovered() || iBinding.getKind() != 2) {
            return false;
        }
        return this.getKey().equals(iBinding.getKey());
    }

    public boolean isRecovered() {
        return true;
    }

    public boolean isSynthetic() {
        return false;
    }

    private String getTypeNameFrom(Type type) {
        if (type == null) {
            return Util.EMPTY_STRING;
        }
        switch (type.getNodeType0()) {
            case 5: {
                ArrayType arrayType = (ArrayType)type;
                type = arrayType.getElementType();
                return this.getTypeNameFrom(type);
            }
            case 74: {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                StringBuffer stringBuffer = new StringBuffer(this.getTypeNameFrom(parameterizedType.getType()));
                ITypeBinding[] iTypeBindingArray = this.getTypeArguments();
                int n = iTypeBindingArray.length;
                if (n != 0) {
                    stringBuffer.append('<');
                    int n2 = 0;
                    while (n2 < n) {
                        if (n2 > 0) {
                            stringBuffer.append(',');
                        }
                        stringBuffer.append(iTypeBindingArray[n2].getName());
                        ++n2;
                    }
                    stringBuffer.append('>');
                }
                return String.valueOf(stringBuffer);
            }
            case 39: {
                PrimitiveType primitiveType = (PrimitiveType)type;
                return primitiveType.getPrimitiveTypeCode().toString();
            }
            case 75: {
                QualifiedType qualifiedType = (QualifiedType)type;
                return qualifiedType.getName().getIdentifier();
            }
            case 43: {
                SimpleType simpleType = (SimpleType)type;
                Name name = simpleType.getName();
                if (name.isQualifiedName()) {
                    QualifiedName qualifiedName = (QualifiedName)name;
                    return qualifiedName.getName().getIdentifier();
                }
                return ((SimpleName)name).getIdentifier();
            }
        }
        return Util.EMPTY_STRING;
    }

    private Type getType() {
        if (this.currentType != null) {
            return this.currentType;
        }
        if (this.variableDeclaration == null) {
            return null;
        }
        switch (this.variableDeclaration.getNodeType()) {
            case 44: {
                SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)this.variableDeclaration;
                return singleVariableDeclaration.getType();
            }
        }
        ASTNode aSTNode = this.variableDeclaration.getParent();
        switch (aSTNode.getNodeType()) {
            case 58: {
                VariableDeclarationExpression variableDeclarationExpression = (VariableDeclarationExpression)aSTNode;
                return variableDeclarationExpression.getType();
            }
            case 60: {
                VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)aSTNode;
                return variableDeclarationStatement.getType();
            }
            case 23: {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)aSTNode;
                return fieldDeclaration.getType();
            }
        }
        return null;
    }

    public boolean isCompilationUnit() {
        return false;
    }
}

