/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SimplePropertyDescriptor;

public abstract class StructuralPropertyDescriptor {
    private final String propertyId;
    private final Class nodeClass;

    StructuralPropertyDescriptor(Class clazz, String string) {
        if (clazz == null || string == null) {
            throw new IllegalArgumentException();
        }
        this.propertyId = string;
        this.nodeClass = clazz;
    }

    public final String getId() {
        return this.propertyId;
    }

    public final Class getNodeClass() {
        return this.nodeClass;
    }

    public final boolean isSimpleProperty() {
        return this instanceof SimplePropertyDescriptor;
    }

    public final boolean isChildProperty() {
        return this instanceof ChildPropertyDescriptor;
    }

    public final boolean isChildListProperty() {
        return this instanceof ChildListPropertyDescriptor;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isChildListProperty()) {
            stringBuffer.append("ChildList");
        }
        if (this.isChildProperty()) {
            stringBuffer.append("Child");
        }
        if (this.isSimpleProperty()) {
            stringBuffer.append("Simple");
        }
        stringBuffer.append("Property[");
        if (this.nodeClass != null) {
            stringBuffer.append(this.nodeClass.getName());
        }
        stringBuffer.append(",");
        if (this.propertyId != null) {
            stringBuffer.append(this.propertyId);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

