/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AnnotationBinding;
import org.eclipse.wst.jsdt.core.dom.BindingComparator;
import org.eclipse.wst.jsdt.core.dom.BindingResolver;
import org.eclipse.wst.jsdt.core.dom.DefaultBindingResolver;
import org.eclipse.wst.jsdt.core.dom.IAnnotationBinding;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.LocalVariable;

class VariableBinding
implements IVariableBinding {
    private static final int VALID_MODIFIERS = 223;
    private org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding binding;
    private ITypeBinding declaringClass;
    private String key;
    private String name;
    private BindingResolver resolver;
    private ITypeBinding type;

    VariableBinding(BindingResolver bindingResolver, org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding variableBinding) {
        this.resolver = bindingResolver;
        this.binding = variableBinding;
    }

    public IAnnotationBinding[] getAnnotations() {
        org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationBinding[] annotationBindingArray = this.binding.getAnnotations();
        int n = annotationBindingArray == null ? 0 : annotationBindingArray.length;
        IAnnotationBinding[] iAnnotationBindingArray = n == 0 ? AnnotationBinding.NoAnnotations : new AnnotationBinding[n];
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBinding iAnnotationBinding = this.resolver.getAnnotationInstance(annotationBindingArray[n2]);
            if (iAnnotationBinding == null) {
                return AnnotationBinding.NoAnnotations;
            }
            iAnnotationBindingArray[n2] = iAnnotationBinding;
            ++n2;
        }
        return iAnnotationBindingArray;
    }

    public Object getConstantValue() {
        Constant constant = this.binding.constant();
        if (constant == null || constant == Constant.NotAConstant) {
            return null;
        }
        switch (constant.typeID()) {
            case 5: {
                return constant.booleanValue();
            }
            case 3: {
                return new Byte(constant.byteValue());
            }
            case 2: {
                return new Character(constant.charValue());
            }
            case 8: {
                return new Double(constant.doubleValue());
            }
            case 9: {
                return new Float(constant.floatValue());
            }
            case 10: {
                return new Integer(constant.intValue());
            }
            case 7: {
                return new Long(constant.longValue());
            }
            case 4: {
                return new Short(constant.shortValue());
            }
            case 11: {
                return constant.stringValue();
            }
        }
        return null;
    }

    public ITypeBinding getDeclaringClass() {
        if (this.isField()) {
            if (this.declaringClass == null) {
                FieldBinding fieldBinding = (FieldBinding)this.binding;
                this.declaringClass = this.resolver.getTypeBinding(fieldBinding.declaringClass);
            }
            return this.declaringClass;
        }
        return null;
    }

    public IMethodBinding getDeclaringMethod() {
        if (!this.isField()) {
            for (ASTNode aSTNode = this.resolver.findDeclaringNode(this); aSTNode != null; aSTNode = aSTNode.getParent()) {
                switch (aSTNode.getNodeType()) {
                    case 28: {
                        return null;
                    }
                    case 31: {
                        MethodDeclaration methodDeclaration = (MethodDeclaration)aSTNode;
                        return methodDeclaration.resolveBinding();
                    }
                }
            }
        }
        return null;
    }

    public IJavaElement getJavaElement() {
        JavaElement javaElement = this.getUnresolvedJavaElement();
        if (javaElement == null) {
            return null;
        }
        return javaElement.resolved(this.binding);
    }

    public String getKey() {
        if (this.key == null) {
            this.key = new String(this.binding.computeUniqueKey());
        }
        return this.key;
    }

    public int getKind() {
        return 3;
    }

    public int getModifiers() {
        if (this.isField()) {
            return ((FieldBinding)this.binding).getAccessFlags() & 0xDF;
        }
        if (this.binding.isFinal()) {
            return 16;
        }
        return 0;
    }

    public String getName() {
        if (this.name == null) {
            this.name = new String(this.binding.name);
        }
        return this.name;
    }

    public ITypeBinding getType() {
        if (this.type == null) {
            this.type = this.resolver.getTypeBinding(this.binding.type);
        }
        return this.type;
    }

    private JavaElement getUnresolvedJavaElement() {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        if (this.isField()) {
            FieldBinding fieldBinding = (FieldBinding)this.binding;
            if (fieldBinding.declaringClass == null) {
                return null;
            }
            IType iType = (IType)this.getDeclaringClass().getJavaElement();
            if (iType == null) {
                return null;
            }
            return (JavaElement)((Object)iType.getField(this.getName()));
        }
        IMethodBinding iMethodBinding = this.getDeclaringMethod();
        if (iMethodBinding == null) {
            return null;
        }
        JavaElement javaElement = (JavaElement)iMethodBinding.getJavaElement();
        if (!(this.resolver instanceof DefaultBindingResolver)) {
            return null;
        }
        VariableDeclaration variableDeclaration = (VariableDeclaration)((DefaultBindingResolver)this.resolver).bindingsToAstNodes.get(this);
        if (variableDeclaration == null) {
            return null;
        }
        if (variableDeclaration instanceof SingleVariableDeclaration) {
            n4 = variableDeclaration.getStartPosition();
            n3 = variableDeclaration.getLength();
            object = ((SingleVariableDeclaration)variableDeclaration).getName();
            n2 = ((ASTNode)object).getStartPosition();
            n = ((ASTNode)object).getLength();
        } else {
            n2 = variableDeclaration.getStartPosition();
            n = variableDeclaration.getLength();
            object = variableDeclaration.getParent();
            n4 = ((ASTNode)object).getStartPosition();
            n3 = ((ASTNode)object).getLength();
        }
        object = this.binding.type.genericTypeSignature();
        return new LocalVariable(javaElement, variableDeclaration.getName().getIdentifier(), n4, n4 + n3 - 1, n2, n2 + n - 1, new String((char[])object));
    }

    public IVariableBinding getVariableDeclaration() {
        if (this.isField()) {
            FieldBinding fieldBinding = (FieldBinding)this.binding;
            return this.resolver.getVariableBinding(fieldBinding.original());
        }
        return this;
    }

    public int getVariableId() {
        return this.binding.id;
    }

    public boolean isParameter() {
        return (this.binding.tagBits & 0x400L) != 0L;
    }

    public boolean isDeprecated() {
        if (this.isField()) {
            return ((FieldBinding)this.binding).isDeprecated();
        }
        return false;
    }

    public boolean isEnumConstant() {
        return (this.binding.modifiers & 0x4000) != 0;
    }

    public boolean isEqualTo(IBinding iBinding) {
        if (iBinding == this) {
            return true;
        }
        if (iBinding == null) {
            return false;
        }
        if (!(iBinding instanceof VariableBinding)) {
            return false;
        }
        org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding variableBinding = ((VariableBinding)iBinding).binding;
        if (this.binding instanceof FieldBinding) {
            if (variableBinding instanceof FieldBinding) {
                return BindingComparator.isEqual((FieldBinding)this.binding, (FieldBinding)variableBinding);
            }
            return false;
        }
        if (BindingComparator.isEqual(this.binding, variableBinding)) {
            IMethodBinding iMethodBinding = this.getDeclaringMethod();
            IMethodBinding iMethodBinding2 = ((VariableBinding)iBinding).getDeclaringMethod();
            if (iMethodBinding == null) {
                return iMethodBinding2 == null;
            }
            return iMethodBinding.isEqualTo(iMethodBinding2);
        }
        return false;
    }

    public boolean isField() {
        return this.binding instanceof FieldBinding;
    }

    public boolean isGlobal() {
        return this.binding instanceof LocalVariableBinding && ((LocalVariableBinding)this.binding).declaringScope instanceof CompilationUnitScope;
    }

    public boolean isSynthetic() {
        if (this.isField()) {
            return ((FieldBinding)this.binding).isSynthetic();
        }
        return false;
    }

    public boolean isRecovered() {
        return false;
    }

    public String toString() {
        return this.binding.toString();
    }
}

