/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.CastExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;

public class AllocationExpression
extends Expression
implements InvocationSite {
    public TypeReference type;
    public Expression[] arguments;
    public MethodBinding binding;
    protected MethodBinding codegenBinding;
    MethodBinding syntheticAccessor;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;
    public FieldDeclaration enumConstant;
    public Expression member;
    public boolean isShort;

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.member != null) {
            flowInfo = this.member.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
        }
        if (this.arguments != null) {
            int n = 0;
            int n2 = this.arguments.length;
            while (n < n2) {
                flowInfo = this.arguments[n].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                ++n;
            }
        }
        TypeBinding[] typeBindingArray = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions.length != 0) {
            flowContext.checkExceptionHandlers(typeBindingArray, (ASTNode)this, (FlowInfo)flowInfo.unconditionalCopy(), blockScope);
        }
        return flowInfo;
    }

    public void checkCapturedLocalInitializationIfNecessary(ReferenceBinding referenceBinding, BlockScope blockScope, FlowInfo flowInfo) {
        NestedTypeBinding nestedTypeBinding;
        SyntheticArgumentBinding[] syntheticArgumentBindingArray;
        if (referenceBinding.isLocalType() && !referenceBinding.isAnonymousType() && !blockScope.isDefinedInType(referenceBinding) && (syntheticArgumentBindingArray = (nestedTypeBinding = (NestedTypeBinding)referenceBinding).syntheticOuterLocalVariables()) != null) {
            int n = 0;
            int n2 = syntheticArgumentBindingArray.length;
            while (n < n2) {
                SyntheticArgumentBinding syntheticArgumentBinding = syntheticArgumentBindingArray[n];
                LocalVariableBinding localVariableBinding = syntheticArgumentBinding.actualOuterLocalVariable;
                if (localVariableBinding != null && localVariableBinding.declaration != null && !flowInfo.isDefinitelyAssigned(localVariableBinding)) {
                    blockScope.problemReporter().uninitializedLocalVariable(localVariableBinding, this);
                }
                ++n;
            }
        }
    }

    public Expression enclosingInstance() {
        return null;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        ReferenceBinding referenceBinding = this.codegenBinding.declaringClass;
        codeStream.new_(referenceBinding);
        if (bl) {
            codeStream.dup();
        }
        if (this.type != null) {
            codeStream.recordPositionsFrom(n, this.type.sourceStart);
        } else {
            codeStream.ldc(String.valueOf(this.enumConstant.name));
            codeStream.generateInlinedValue(this.enumConstant.binding.id);
        }
        if (referenceBinding.isNestedType()) {
            codeStream.generateSyntheticEnclosingInstanceValues(blockScope, referenceBinding, this.enclosingInstance(), this);
        }
        this.generateArguments(this.binding, this.arguments, blockScope, codeStream);
        if (referenceBinding.isNestedType()) {
            codeStream.generateSyntheticOuterArgumentValues(blockScope, referenceBinding, this);
        }
        if (this.syntheticAccessor == null) {
            codeStream.invokespecial(this.codegenBinding);
        } else {
            int n2 = 0;
            int n3 = this.syntheticAccessor.parameters.length - this.codegenBinding.parameters.length;
            while (n2 < n3) {
                codeStream.aconst_null();
                ++n2;
            }
            codeStream.invokespecial(this.syntheticAccessor);
        }
        codeStream.generateImplicitConversion(this.implicitConversion);
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean isSuperAccess() {
        return false;
    }

    public boolean isTypeAccess() {
        return true;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding.declaringClass.erasure();
        if (referenceBinding.isNestedType() && blockScope.enclosingSourceType().isLocalType()) {
            if (referenceBinding.isLocalType()) {
                ((LocalTypeBinding)referenceBinding).addInnerEmulationDependent(blockScope, false);
            } else {
                blockScope.propagateInnerEmulation(referenceBinding, false);
            }
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        this.codegenBinding = this.binding.original();
        if (this.codegenBinding.isPrivate()) {
            ReferenceBinding referenceBinding = this.codegenBinding.declaringClass;
            if (blockScope.enclosingSourceType() != referenceBinding) {
                if ((referenceBinding.tagBits & 0x10L) != 0L && blockScope.compilerOptions().complianceLevel >= 0x300000L) {
                    this.codegenBinding.tagBits |= 0x400L;
                } else {
                    this.syntheticAccessor = ((SourceTypeBinding)referenceBinding).addSyntheticMethod(this.codegenBinding, this.isSuperAccess());
                    blockScope.problemReporter().needToEmulateMethodAccess(this.codegenBinding, this);
                }
            }
        }
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2;
        stringBuffer.append("new ");
        this.member.print(n, stringBuffer);
        if (this.typeArguments != null) {
            stringBuffer.append('<');
            n2 = this.typeArguments.length - 1;
            int n3 = 0;
            while (n3 < n2) {
                this.typeArguments[n3].print(0, stringBuffer);
                stringBuffer.append(", ");
                ++n3;
            }
            this.typeArguments[n2].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        if (this.type != null) {
            this.type.printExpression(0, stringBuffer);
        }
        if (!this.isShort) {
            stringBuffer.append('(');
            if (this.arguments != null) {
                n2 = 0;
                while (n2 < this.arguments.length) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    this.arguments[n2].printExpression(0, stringBuffer);
                    ++n2;
                }
            }
            stringBuffer.append(')');
        }
        return stringBuffer;
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        int n;
        block27: {
            Object object;
            Object object2;
            block24: {
                block25: {
                    block28: {
                        block26: {
                            this.constant = Constant.NotAConstant;
                            if (this.member == null) break block24;
                            if (!(this.member instanceof SingleNameReference)) break block25;
                            object2 = ((SingleNameReference)this.member).token;
                            object = blockScope.getBinding((char[])object2, (0xC | this.bits) & 0xF, (InvocationSite)this, true);
                            if (!(object instanceof TypeBinding)) break block26;
                            this.resolvedType = (TypeBinding)object;
                            break block27;
                        }
                        if (!(object instanceof MethodBinding)) break block28;
                        this.resolvedType = ((MethodBinding)object).returnType;
                        break block27;
                    }
                    if (object == null || ((Binding)object).isValidBinding()) break block27;
                    blockScope.problemReporter().invalidType(this, new ProblemReferenceBinding((char[])object2, null, ((Binding)object).problemId()));
                    break block27;
                }
                this.resolvedType = this.member.resolveType(blockScope);
                break block27;
            }
            if (this.type == null) {
                this.resolvedType = blockScope.enclosingReceiverType();
            } else {
                this.resolvedType = this.type.resolveType(blockScope, true);
                if (this.type instanceof ParameterizedQualifiedTypeReference) {
                    object2 = (ReferenceBinding)this.resolvedType;
                    if (object2 == null) {
                        return null;
                    }
                    block0: while ((object2.modifiers & 8) == 0 && !object2.isRawType()) {
                        if ((object2 = object2.enclosingType()) != null) continue;
                        object = (ParameterizedQualifiedTypeReference)this.type;
                        n = ((ParameterizedQualifiedTypeReference)object).typeArguments.length - 2;
                        while (n >= 0) {
                            if (((ParameterizedQualifiedTypeReference)object).typeArguments[n] != null) {
                                blockScope.problemReporter().illegalQualifiedParameterizedTypeAllocation(this.type, this.resolvedType);
                                break block0;
                            }
                            --n;
                        }
                        break block0;
                    }
                }
            }
        }
        if (this.typeArguments != null) {
            int n2 = this.typeArguments.length;
            boolean bl = false;
            this.genericTypeArguments = new TypeBinding[n2];
            n = 0;
            while (n < n2) {
                this.genericTypeArguments[n] = this.typeArguments[n].resolveType(blockScope, true);
                if (this.genericTypeArguments[n] == null) {
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                return null;
            }
        }
        boolean bl = false;
        TypeBinding[] typeBindingArray = Binding.NO_PARAMETERS;
        if (this.arguments != null) {
            n = 0;
            int n3 = this.arguments.length;
            typeBindingArray = new TypeBinding[n3];
            int n4 = 0;
            while (n4 < n3) {
                Expression expression = this.arguments[n4];
                if (expression instanceof CastExpression) {
                    expression.bits |= 0x20;
                    bl = true;
                }
                if ((typeBindingArray[n4] = expression.resolveType(blockScope)) == null) {
                    n = 1;
                }
                ++n4;
            }
            if (n != 0) {
                if (this.resolvedType instanceof ReferenceBinding) {
                    TypeBinding[] typeBindingArray2 = new TypeBinding[n3];
                    int n5 = n3;
                    while (--n5 >= 0) {
                        TypeBinding typeBinding = typeBindingArray2[n5] = typeBindingArray[n5] == null ? this.resolvedType : typeBindingArray[n5];
                    }
                    this.binding = blockScope.findMethod((ReferenceBinding)this.resolvedType, TypeConstants.INIT, typeBindingArray2, this);
                }
                return this.resolvedType;
            }
        }
        if (this.resolvedType == null) {
            return null;
        }
        if (this.type != null && !this.resolvedType.canBeInstantiated()) {
            blockScope.problemReporter().cannotInstantiate(this.type, this.resolvedType);
            return this.resolvedType;
        }
        if (this.resolvedType instanceof ReferenceBinding) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
            this.binding = blockScope.getConstructor(referenceBinding, typeBindingArray, this);
            if (!this.binding.isValidBinding()) {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = referenceBinding;
                }
                blockScope.problemReporter().invalidConstructor(this, this.binding);
                return this.resolvedType;
            }
            if (this.isMethodUseDeprecated(this.binding, blockScope, true)) {
                blockScope.problemReporter().deprecatedMethod(this.binding, this);
            }
            AllocationExpression.checkInvocationArguments(blockScope, null, referenceBinding, this.binding, this.arguments, typeBindingArray, bl, this);
        }
        return this.resolvedType;
    }

    public void setActualReceiverType(ReferenceBinding referenceBinding) {
    }

    public void setDepth(int n) {
    }

    public void setFieldIndex(int n) {
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            if (this.typeArguments != null) {
                n2 = 0;
                n = this.typeArguments.length;
                while (n2 < n) {
                    this.typeArguments[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
            if (this.member != null) {
                this.member.traverse(aSTVisitor, blockScope);
            } else if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
            if (this.arguments != null) {
                n2 = 0;
                n = this.arguments.length;
                while (n2 < n) {
                    this.arguments[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

