/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.CastExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class CombinedBinaryExpression
extends BinaryExpression {
    public int arity;
    public int arityMax;
    public static final int ARITY_MAX_MAX = 160;
    public static final int ARITY_MAX_MIN = 20;
    public static int defaultArityMaxStartingValue = 20;
    public BinaryExpression[] referencesTable;

    public CombinedBinaryExpression(Expression expression, Expression expression2, int n, int n2) {
        super(expression, expression2, n);
        this.arity = n2;
        if (n2 > 1) {
            this.referencesTable = new BinaryExpression[n2];
            this.referencesTable[n2 - 1] = (BinaryExpression)expression;
            int n3 = n2 - 1;
            while (n3 > 0) {
                this.referencesTable[n3 - 1] = (BinaryExpression)this.referencesTable[n3].left;
                --n3;
            }
        } else {
            this.arityMax = defaultArityMaxStartingValue;
        }
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.referencesTable == null) {
            return super.analyseCode(blockScope, flowContext, flowInfo);
        }
        BinaryExpression binaryExpression = this.referencesTable[0];
        if (binaryExpression.resolvedType.id != 11) {
            binaryExpression.left.checkNPE(blockScope, flowContext, flowInfo);
        }
        flowInfo = binaryExpression.left.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
        int n = 0;
        int n2 = this.arity;
        while (n < n2) {
            binaryExpression = this.referencesTable[n];
            if (binaryExpression.resolvedType.id != 11) {
                binaryExpression.right.checkNPE(blockScope, flowContext, flowInfo);
            }
            flowInfo = binaryExpression.right.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
            ++n;
        }
        if (this.resolvedType.id != 11) {
            this.right.checkNPE(blockScope, flowContext, flowInfo);
        }
        return this.right.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
    }

    public void generateOptimizedStringConcatenation(BlockScope blockScope, CodeStream codeStream, int n) {
        if (this.referencesTable == null) {
            super.generateOptimizedStringConcatenation(blockScope, codeStream, n);
        } else if ((this.bits & 0xFC0) >> 6 == 14 && (this.bits & 0xF) == 11) {
            if (this.constant != Constant.NotAConstant) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
                codeStream.invokeStringConcatenationAppendForType(this.implicitConversion & 0xF);
            } else {
                BinaryExpression binaryExpression = this.referencesTable[0];
                int n2 = 0;
                int n3 = codeStream.position;
                n2 = this.arity - 1;
                while (n2 >= 0) {
                    binaryExpression = this.referencesTable[n2];
                    if (binaryExpression.constant != Constant.NotAConstant) {
                        codeStream.generateConstant(binaryExpression.constant, binaryExpression.implicitConversion);
                        codeStream.invokeStringConcatenationAppendForType(binaryExpression.implicitConversion & 0xF);
                        break;
                    }
                    --n2;
                }
                if (++n2 == 0) {
                    binaryExpression.left.generateOptimizedStringConcatenation(blockScope, codeStream, binaryExpression.left.implicitConversion & 0xF);
                }
                int n4 = n2;
                while (n4 < this.arity) {
                    binaryExpression = this.referencesTable[n4];
                    codeStream.recordPositionsFrom(n3, binaryExpression.left.sourceStart);
                    int n5 = codeStream.position;
                    binaryExpression.right.generateOptimizedStringConcatenation(blockScope, codeStream, binaryExpression.right.implicitConversion & 0xF);
                    codeStream.recordPositionsFrom(n5, binaryExpression.right.sourceStart);
                    ++n4;
                }
                codeStream.recordPositionsFrom(n3, this.left.sourceStart);
                n3 = codeStream.position;
                this.right.generateOptimizedStringConcatenation(blockScope, codeStream, this.right.implicitConversion & 0xF);
                codeStream.recordPositionsFrom(n3, this.right.sourceStart);
            }
        } else {
            super.generateOptimizedStringConcatenation(blockScope, codeStream, n);
        }
    }

    public void generateOptimizedStringConcatenationCreation(BlockScope blockScope, CodeStream codeStream, int n) {
        if (this.referencesTable == null) {
            super.generateOptimizedStringConcatenationCreation(blockScope, codeStream, n);
        } else if ((this.bits & 0xFC0) >> 6 == 14 && (this.bits & 0xF) == 11 && this.constant == Constant.NotAConstant) {
            int n2 = codeStream.position;
            BinaryExpression binaryExpression = this.referencesTable[this.arity - 1];
            int n3 = 0;
            n3 = this.arity - 1;
            while (n3 >= 0) {
                binaryExpression = this.referencesTable[n3];
                if ((binaryExpression.bits & 0xFC0) >> 6 == 14 && (binaryExpression.bits & 0xF) == 11) {
                    if (binaryExpression.constant != Constant.NotAConstant) {
                        codeStream.newStringContatenation();
                        codeStream.dup();
                        codeStream.ldc(binaryExpression.constant.stringValue());
                        codeStream.invokeStringConcatenationStringConstructor();
                        break;
                    }
                } else {
                    binaryExpression.generateOptimizedStringConcatenationCreation(blockScope, codeStream, binaryExpression.implicitConversion & 0xF);
                    break;
                }
                --n3;
            }
            if (++n3 == 0) {
                binaryExpression.left.generateOptimizedStringConcatenationCreation(blockScope, codeStream, binaryExpression.left.implicitConversion & 0xF);
            }
            int n4 = n3;
            while (n4 < this.arity) {
                binaryExpression = this.referencesTable[n4];
                codeStream.recordPositionsFrom(n2, binaryExpression.left.sourceStart);
                int n5 = codeStream.position;
                binaryExpression.right.generateOptimizedStringConcatenation(blockScope, codeStream, binaryExpression.right.implicitConversion & 0xF);
                codeStream.recordPositionsFrom(n5, binaryExpression.right.sourceStart);
                ++n4;
            }
            codeStream.recordPositionsFrom(n2, this.left.sourceStart);
            n2 = codeStream.position;
            this.right.generateOptimizedStringConcatenation(blockScope, codeStream, this.right.implicitConversion & 0xF);
            codeStream.recordPositionsFrom(n2, this.right.sourceStart);
        } else {
            super.generateOptimizedStringConcatenationCreation(blockScope, codeStream, n);
        }
    }

    public StringBuffer printExpressionNoParenthesis(int n, StringBuffer stringBuffer) {
        if (this.referencesTable == null) {
            return super.printExpressionNoParenthesis(n, stringBuffer);
        }
        String string = this.operatorToString();
        int n2 = this.arity - 1;
        while (n2 >= 0) {
            stringBuffer.append('(');
            --n2;
        }
        stringBuffer = this.referencesTable[0].left.printExpression(n, stringBuffer);
        n2 = 0;
        int n3 = this.arity;
        while (n2 < n3) {
            stringBuffer.append(' ').append(string).append(' ');
            stringBuffer = this.referencesTable[n2].right.printExpression(0, stringBuffer);
            stringBuffer.append(')');
            ++n2;
        }
        stringBuffer.append(' ').append(string).append(' ');
        return this.right.printExpression(0, stringBuffer);
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        if (this.referencesTable == null) {
            return super.resolveType(blockScope);
        }
        BinaryExpression binaryExpression = this.referencesTable[0];
        if (binaryExpression.left instanceof CastExpression) {
            binaryExpression.left.bits |= 0x20;
        }
        binaryExpression.left.resolveType(blockScope);
        int n = 0;
        int n2 = this.arity;
        while (n < n2) {
            this.referencesTable[n].nonRecursiveResolveTypeUpwards(blockScope);
            ++n;
        }
        this.nonRecursiveResolveTypeUpwards(blockScope);
        return this.resolvedType;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (this.referencesTable == null) {
            super.traverse(aSTVisitor, blockScope);
        } else {
            if (aSTVisitor.visit(this, blockScope)) {
                int n = this.arity - 1;
                while (n >= 0) {
                    if (!aSTVisitor.visit(this.referencesTable[n], blockScope)) {
                        aSTVisitor.endVisit(this.referencesTable[n], blockScope);
                        break;
                    }
                    --n;
                }
                if (++n == 0) {
                    this.referencesTable[0].left.traverse(aSTVisitor, blockScope);
                }
                int n2 = n;
                int n3 = this.arity;
                while (n2 < n3) {
                    this.referencesTable[n2].right.traverse(aSTVisitor, blockScope);
                    aSTVisitor.endVisit(this.referencesTable[n2], blockScope);
                    ++n2;
                }
                this.right.traverse(aSTVisitor, blockScope);
            }
            aSTVisitor.endVisit(this, blockScope);
        }
    }

    public void tuneArityMax() {
        if (this.arityMax < 160) {
            this.arityMax *= 2;
        }
    }
}

