/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;

public class QualifiedTypeReference
extends TypeReference {
    public char[][] tokens;
    public long[] sourcePositions;

    public QualifiedTypeReference(char[][] cArray, long[] lArray) {
        this.tokens = cArray;
        this.sourcePositions = lArray;
        this.sourceStart = (int)(this.sourcePositions[0] >>> 32);
        this.sourceEnd = (int)(this.sourcePositions[this.sourcePositions.length - 1] & 0xFFFFFFFFL);
    }

    public TypeReference copyDims(int n) {
        return new ArrayQualifiedTypeReference(this.tokens, n, this.sourcePositions);
    }

    protected TypeBinding findNextTypeBinding(int n, Scope scope, PackageBinding packageBinding) {
        TypeBinding typeBinding;
        LookupEnvironment lookupEnvironment = scope.environment();
        try {
            lookupEnvironment.missingClassFileLocation = this;
            if (this.resolvedType == null) {
                this.resolvedType = scope.getType(this.tokens[n], packageBinding);
            } else {
                this.resolvedType = scope.getMemberType(this.tokens[n], (ReferenceBinding)this.resolvedType);
                if (this.resolvedType instanceof ProblemReferenceBinding) {
                    ProblemReferenceBinding problemReferenceBinding = (ProblemReferenceBinding)this.resolvedType;
                    this.resolvedType = new ProblemReferenceBinding(CharOperation.subarray(this.tokens, 0, n + 1), problemReferenceBinding.closestMatch(), this.resolvedType.problemId());
                }
            }
            typeBinding = this.resolvedType;
            Object var6_8 = null;
        }
        catch (AbortCompilation abortCompilation) {
            try {
                abortCompilation.updateContext(this, scope.referenceCompilationUnit().compilationResult);
                throw abortCompilation;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                lookupEnvironment.missingClassFileLocation = null;
                throw throwable;
            }
        }
        lookupEnvironment.missingClassFileLocation = null;
        return typeBinding;
    }

    public char[] getLastToken() {
        return this.tokens[this.tokens.length - 1];
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        Binding binding = scope.getPackage(this.tokens);
        if (binding != null && !binding.isValidBinding()) {
            return (ReferenceBinding)binding;
        }
        PackageBinding packageBinding = binding == null ? null : (PackageBinding)binding;
        boolean bl = scope.kind == 3;
        TypeBinding typeBinding = null;
        int n = packageBinding == null ? 0 : packageBinding.compoundName.length;
        int n2 = this.tokens.length;
        int n3 = n2 - 1;
        while (n < n2) {
            boolean bl2;
            this.findNextTypeBinding(n, scope, packageBinding);
            if (!this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            if (n == 0 && this.resolvedType.isTypeVariable() && ((TypeVariableBinding)this.resolvedType).firstBound == null) {
                scope.problemReporter().illegalAccessFromTypeVariable((TypeVariableBinding)this.resolvedType, this);
                this.resolvedType = null;
                return null;
            }
            if (n < n3 && this.isTypeUseDeprecated(this.resolvedType, scope)) {
                this.reportDeprecatedType(this.resolvedType, scope);
            }
            if (bl && ((ClassScope)scope).detectHierarchyCycle(this.resolvedType, this)) {
                return null;
            }
            ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
            typeBinding = typeBinding != null ? (referenceBinding.isGenericType() ? scope.environment().createRawType(referenceBinding, (ReferenceBinding)typeBinding) : ((bl2 = typeBinding.isRawType()) && !referenceBinding.isStatic() ? scope.environment().createRawType((ReferenceBinding)referenceBinding.erasure(), (ReferenceBinding)typeBinding) : ((bl2 || typeBinding.isParameterizedType()) && typeBinding.erasure() == referenceBinding.enclosingType().erasure() ? scope.environment().createParameterizedType((ReferenceBinding)referenceBinding.erasure(), null, (ReferenceBinding)typeBinding) : referenceBinding))) : (referenceBinding.isGenericType() ? (ReferenceBinding)scope.environment().convertToRawType(referenceBinding) : referenceBinding);
            ++n;
        }
        this.resolvedType = typeBinding;
        return this.resolvedType;
    }

    public char[][] getTypeName() {
        return this.tokens;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2 = 0;
        while (n2 < this.tokens.length) {
            if (n2 > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(this.tokens[n2]);
            ++n2;
        }
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        aSTVisitor.visit(this, classScope);
        aSTVisitor.endVisit(this, classScope);
    }
}

