/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.batch;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Hashtable;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public class ClasspathDirectory
extends ClasspathLocation {
    private char[] normalizedPath;
    private String path;
    private Hashtable directoryCache;
    private String[] missingPackageHolder = new String[1];
    private int mode;
    private String encoding;

    ClasspathDirectory(File file, String string, int n, AccessRuleSet accessRuleSet, String string2) {
        super(accessRuleSet, string2);
        this.mode = n;
        this.path = file.getAbsolutePath();
        if (!this.path.endsWith(File.separator)) {
            this.path = String.valueOf(this.path) + File.separator;
        }
        this.directoryCache = new Hashtable(11);
        this.encoding = string;
    }

    String[] directoryList(String string) {
        String[] stringArray = (String[])this.directoryCache.get(string);
        if (stringArray == this.missingPackageHolder) {
            return null;
        }
        if (stringArray != null) {
            return stringArray;
        }
        File file = new File(String.valueOf(this.path) + string);
        if (file.isDirectory()) {
            String string2;
            String string3;
            int n = string.length();
            int n2 = string.lastIndexOf(File.separatorChar);
            while (--n > n2 && !ScannerHelper.isUpperCase(string.charAt(n))) {
            }
            if (n <= n2 || !(n2 != -1 ? !this.doesFileExist(string3 = string.substring(n2 + 1), string2 = string.substring(0, n2)) : !this.doesFileExist(string, Util.EMPTY_STRING))) {
                stringArray = file.list();
                if (stringArray == null) {
                    stringArray = CharOperation.NO_STRINGS;
                }
                this.directoryCache.put(string, stringArray);
                return stringArray;
            }
        }
        this.directoryCache.put(string, this.missingPackageHolder);
        return null;
    }

    boolean doesFileExist(String string, String string2) {
        String[] stringArray = this.directoryList(string2);
        if (stringArray == null) {
            return false;
        }
        int n = stringArray.length;
        while (--n >= 0) {
            if (!string.equals(stringArray[n])) continue;
            return true;
        }
        return false;
    }

    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2) {
        return this.findClass(cArray, string, string2, false);
    }

    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2, boolean bl) {
        Object object;
        boolean bl2;
        if (!this.isPackage(string)) {
            return null;
        }
        String string3 = new String(cArray);
        boolean bl3 = (this.mode & 2) != 0 && this.doesFileExist(String.valueOf(string3) + ".js", string);
        boolean bl4 = bl2 = (this.mode & 1) != 0 && this.doesFileExist(String.valueOf(string3) + ".js", string);
        if (bl2 && !bl) {
            object = String.valueOf(this.path) + string2.substring(0, string2.length() - 6) + ".js";
            if (!bl3) {
                return new NameEnvironmentAnswer(new CompilationUnit(null, (String)object, this.encoding, this.destinationPath), this.fetchAccessRestriction(string2));
            }
            String string4 = String.valueOf(this.path) + string2;
            long l = new File(string4).lastModified();
            long l2 = new File((String)object).lastModified();
            if (l2 > l) {
                return new NameEnvironmentAnswer(new CompilationUnit(null, (String)object, this.encoding, this.destinationPath), this.fetchAccessRestriction(string2));
            }
        }
        if (bl3) {
            try {
                object = ClassFileReader.read(String.valueOf(this.path) + string2);
                if (object != null) {
                    return new NameEnvironmentAnswer((IBinaryType)object, this.fetchAccessRestriction(string2));
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public char[][][] findTypeNames(String string) {
        int n;
        if (!this.isPackage(string)) {
            return null;
        }
        File file = new File(String.valueOf(this.path) + string);
        if (!file.exists() || !file.isDirectory()) {
            return null;
        }
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                String string2 = string.toLowerCase();
                return string2.endsWith(".class") || string2.endsWith(".java");
            }
        });
        if (stringArray == null || (n = stringArray.length) == 0) {
            return null;
        }
        char[][][] cArrayArray = new char[n][][];
        char[][] cArray = CharOperation.splitOn(File.separatorChar, string.toCharArray());
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            int n3 = string2.indexOf(46);
            cArrayArray[n2] = CharOperation.arrayConcat(cArray, string2.substring(0, n3).toCharArray());
            ++n2;
        }
        return cArrayArray;
    }

    public void initialize() throws IOException {
    }

    public boolean isPackage(String string) {
        return this.directoryList(string) != null;
    }

    public void reset() {
        this.directoryCache = new Hashtable(11);
    }

    public String toString() {
        return "ClasspathDirectory " + this.path;
    }

    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            this.normalizedPath = this.path.toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace(this.normalizedPath, '\\', '/');
            }
        }
        return this.normalizedPath;
    }

    public String getPath() {
        return this.path;
    }

    public NameEnvironmentAnswer findBinding(char[] cArray, String string, int n, ITypeRequestor iTypeRequestor) {
        return null;
    }
}

