/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.infer.InferredType;

public class ClasspathFile
extends ClasspathLocation {
    protected File file;
    protected Hashtable packageCache;
    String packageName;
    protected char[] normalizedPath;
    String encoding;
    HashtableOfObject[] definedItems = new HashtableOfObject[16];
    NameEnvironmentAnswer foundAnswer;

    public ClasspathFile(File file, String string, AccessRuleSet accessRuleSet, String string2) {
        super(accessRuleSet, string2);
        this.file = file;
        this.packageName = file.getName();
        this.encoding = string;
    }

    public NameEnvironmentAnswer findBinding(char[] cArray, String string, int n, ITypeRequestor iTypeRequestor) {
        if (this.foundAnswer == null) {
            this.parseFile(iTypeRequestor);
        }
        NameEnvironmentAnswer nameEnvironmentAnswer = null;
        if ((n & 3) != 0 && (nameEnvironmentAnswer = (NameEnvironmentAnswer)this.definedItems[3].get(cArray)) != null) {
            return nameEnvironmentAnswer;
        }
        if ((n & 4) != 0 && (nameEnvironmentAnswer = (NameEnvironmentAnswer)this.definedItems[4].get(cArray)) != null) {
            return nameEnvironmentAnswer;
        }
        if ((n & 8) != 0 && (nameEnvironmentAnswer = (NameEnvironmentAnswer)this.definedItems[8].get(cArray)) != null) {
            return nameEnvironmentAnswer;
        }
        return null;
    }

    private void parseFile(ITypeRequestor iTypeRequestor) {
        CompilationUnit compilationUnit = new CompilationUnit(null, this.file.getAbsolutePath(), this.encoding);
        compilationUnit.packageName = new char[][]{this.packageName.toCharArray()};
        int n = 0;
        while (n < this.definedItems.length) {
            this.definedItems[n] = new HashtableOfObject();
            ++n;
        }
        this.foundAnswer = new NameEnvironmentAnswer(compilationUnit, this.fetchAccessRestriction(this.file.getAbsolutePath()));
        if (iTypeRequestor != null) {
            ASTNode aSTNode;
            CompilationUnitDeclaration compilationUnitDeclaration = iTypeRequestor.doParse(compilationUnit, null);
            int n2 = 0;
            while (n2 < compilationUnitDeclaration.statements.length) {
                if (compilationUnitDeclaration.statements[n2] instanceof AbstractMethodDeclaration) {
                    aSTNode = (AbstractMethodDeclaration)compilationUnitDeclaration.statements[n2];
                    this.definedItems[8].put(((AbstractMethodDeclaration)aSTNode).selector, this.foundAnswer);
                } else if (compilationUnitDeclaration.statements[n2] instanceof AbstractVariableDeclaration) {
                    aSTNode = (AbstractVariableDeclaration)compilationUnitDeclaration.statements[n2];
                    this.definedItems[3].put(((AbstractVariableDeclaration)aSTNode).name, this.foundAnswer);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < compilationUnitDeclaration.numberInferredTypes) {
                aSTNode = compilationUnitDeclaration.inferredTypes[n2];
                if (((InferredType)aSTNode).isDefinition) {
                    this.definedItems[4].put(((InferredType)aSTNode).getName(), this.foundAnswer);
                }
                ++n2;
            }
        } else {
            throw new UnimplementedException();
        }
    }

    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2) {
        return this.findClass(cArray, string, string2, false);
    }

    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2, boolean bl) {
        if (!this.isPackage(string)) {
            return null;
        }
        throw new UnimplementedException();
    }

    public void initialize() throws IOException {
    }

    public boolean isPackage(String string) {
        return this.packageName.equals(string);
    }

    public void reset() {
        this.packageCache = null;
    }

    public String toString() {
        return "Classpath for file " + this.file.getPath();
    }

    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            char[] cArray = this.file.getPath().toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace(cArray, '\\', '/');
            }
            this.normalizedPath = CharOperation.subarray(cArray, 0, CharOperation.lastIndexOf('.', cArray));
        }
        return this.normalizedPath;
    }

    public String getPath() {
        return this.file.getPath();
    }

    public char[][][] findTypeNames(String string) {
        throw new UnimplementedException("implement");
    }
}

