/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.classfmt;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.AnnotationInfo;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.FieldInfoWithAnnotation;
import org.eclipse.wst.jsdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryField;
import org.eclipse.wst.jsdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.wst.jsdt.internal.compiler.impl.ByteConstant;
import org.eclipse.wst.jsdt.internal.compiler.impl.CharConstant;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.wst.jsdt.internal.compiler.impl.FloatConstant;
import org.eclipse.wst.jsdt.internal.compiler.impl.IntConstant;
import org.eclipse.wst.jsdt.internal.compiler.impl.LongConstant;
import org.eclipse.wst.jsdt.internal.compiler.impl.ShortConstant;
import org.eclipse.wst.jsdt.internal.compiler.impl.StringConstant;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public class FieldInfo
extends ClassFileStruct
implements IBinaryField,
Comparable {
    protected int accessFlags = -1;
    protected int attributeBytes;
    protected Constant constant;
    protected char[] descriptor;
    protected char[] name;
    protected char[] signature;
    protected int signatureUtf8Offset = -1;
    protected long tagBits;
    protected Object wrappedConstantValue;

    public static FieldInfo createField(byte[] byArray, int[] nArray, int n) {
        FieldInfo fieldInfo = new FieldInfo(byArray, nArray, n);
        AnnotationInfo[] annotationInfoArray = fieldInfo.readAttributes();
        if (annotationInfoArray == null) {
            return fieldInfo;
        }
        return new FieldInfoWithAnnotation(fieldInfo, annotationInfoArray);
    }

    protected FieldInfo(byte[] byArray, int[] nArray, int n) {
        super(byArray, nArray, n);
    }

    private AnnotationInfo[] decodeAnnotations(int n, boolean bl) {
        int n2 = this.u2At(n + 6);
        if (n2 > 0) {
            int n3 = n + 8;
            AnnotationInfo[] annotationInfoArray = null;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                AnnotationInfo annotationInfo = new AnnotationInfo(this.reference, this.constantPoolOffsets, n3 + this.structOffset, bl, false);
                n3 += annotationInfo.readOffset;
                long l = annotationInfo.standardAnnotationTagBits;
                if (l != 0L) {
                    this.tagBits |= l;
                } else {
                    if (annotationInfoArray == null) {
                        annotationInfoArray = new AnnotationInfo[n2 - n5];
                    }
                    annotationInfoArray[n4++] = annotationInfo;
                }
                ++n5;
            }
            if (annotationInfoArray != null) {
                if (n4 != annotationInfoArray.length) {
                    AnnotationInfo[] annotationInfoArray2 = annotationInfoArray;
                    annotationInfoArray = new AnnotationInfo[n4];
                    System.arraycopy(annotationInfoArray2, 0, annotationInfoArray, 0, n4);
                }
                return annotationInfoArray;
            }
        }
        return null;
    }

    public int compareTo(Object object) {
        if (!(object instanceof FieldInfo)) {
            throw new ClassCastException();
        }
        return new String(this.getName()).compareTo(new String(((FieldInfo)object).getName()));
    }

    public Constant getConstant() {
        if (this.constant == null) {
            this.readConstantAttribute();
        }
        return this.constant;
    }

    public char[] getGenericSignature() {
        if (this.signatureUtf8Offset != -1) {
            if (this.signature == null) {
                this.signature = this.utf8At(this.signatureUtf8Offset + 3, this.u2At(this.signatureUtf8Offset + 1));
            }
            return this.signature;
        }
        return null;
    }

    public int getModifiers() {
        if (this.accessFlags == -1) {
            this.accessFlags = this.u2At(0);
            this.readModifierRelatedAttributes();
        }
        return this.accessFlags;
    }

    public char[] getName() {
        if (this.name == null) {
            int n = this.constantPoolOffsets[this.u2At(2)] - this.structOffset;
            this.name = this.utf8At(n + 3, this.u2At(n + 1));
        }
        return this.name;
    }

    public long getTagBits() {
        return this.tagBits;
    }

    public char[] getTypeName() {
        if (this.descriptor == null) {
            int n = this.constantPoolOffsets[this.u2At(4)] - this.structOffset;
            this.descriptor = this.utf8At(n + 3, this.u2At(n + 1));
        }
        return this.descriptor;
    }

    public IBinaryAnnotation[] getAnnotations() {
        return null;
    }

    public Object getWrappedConstantValue() {
        if (this.wrappedConstantValue == null && this.hasConstant()) {
            Constant constant = this.getConstant();
            switch (constant.typeID()) {
                case 10: {
                    this.wrappedConstantValue = new Integer(constant.intValue());
                    break;
                }
                case 3: {
                    this.wrappedConstantValue = new Byte(constant.byteValue());
                    break;
                }
                case 4: {
                    this.wrappedConstantValue = new Short(constant.shortValue());
                    break;
                }
                case 2: {
                    this.wrappedConstantValue = new Character(constant.charValue());
                    break;
                }
                case 9: {
                    this.wrappedConstantValue = new Float(constant.floatValue());
                    break;
                }
                case 8: {
                    this.wrappedConstantValue = new Double(constant.doubleValue());
                    break;
                }
                case 5: {
                    this.wrappedConstantValue = Util.toBoolean(constant.booleanValue());
                    break;
                }
                case 7: {
                    this.wrappedConstantValue = new Long(constant.longValue());
                    break;
                }
                case 11: {
                    this.wrappedConstantValue = constant.stringValue();
                }
            }
        }
        return this.wrappedConstantValue;
    }

    public boolean hasConstant() {
        return this.getConstant() != Constant.NotAConstant;
    }

    protected void initialize() {
        this.getModifiers();
        this.getName();
        this.getConstant();
        this.getTypeName();
        this.getGenericSignature();
        this.reset();
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    private AnnotationInfo[] readAttributes() {
        int n = this.u2At(6);
        int n2 = 8;
        AnnotationInfo[] annotationInfoArray = null;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.constantPoolOffsets[this.u2At(n2)] - this.structOffset;
            char[] cArray = this.utf8At(n4 + 3, this.u2At(n4 + 1));
            if (cArray.length > 0) {
                switch (cArray[0]) {
                    case 'S': {
                        if (!CharOperation.equals(AttributeNamesConstants.SignatureName, cArray)) break;
                        this.signatureUtf8Offset = this.constantPoolOffsets[this.u2At(n2 + 6)] - this.structOffset;
                        break;
                    }
                    case 'R': {
                        AnnotationInfo[] annotationInfoArray2 = null;
                        if (CharOperation.equals(cArray, AttributeNamesConstants.RuntimeVisibleAnnotationsName)) {
                            annotationInfoArray2 = this.decodeAnnotations(n2, true);
                        } else if (CharOperation.equals(cArray, AttributeNamesConstants.RuntimeInvisibleAnnotationsName)) {
                            annotationInfoArray2 = this.decodeAnnotations(n2, false);
                        }
                        if (annotationInfoArray2 == null) break;
                        if (annotationInfoArray == null) {
                            annotationInfoArray = annotationInfoArray2;
                            break;
                        }
                        int n5 = annotationInfoArray.length;
                        AnnotationInfo[] annotationInfoArray3 = new AnnotationInfo[n5 + annotationInfoArray2.length];
                        System.arraycopy(annotationInfoArray, 0, annotationInfoArray3, 0, n5);
                        System.arraycopy(annotationInfoArray2, 0, annotationInfoArray3, n5, annotationInfoArray2.length);
                        annotationInfoArray = annotationInfoArray3;
                    }
                }
            }
            n2 = (int)((long)n2 + (6L + this.u4At(n2 + 2)));
            ++n3;
        }
        this.attributeBytes = n2;
        return annotationInfoArray;
    }

    private void readConstantAttribute() {
        int n = this.u2At(6);
        int n2 = 8;
        boolean bl = false;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.constantPoolOffsets[this.u2At(n2)] - this.structOffset;
            char[] cArray = this.utf8At(n4 + 3, this.u2At(n4 + 1));
            if (CharOperation.equals(cArray, AttributeNamesConstants.ConstantValueName)) {
                bl = true;
                int n5 = this.constantPoolOffsets[this.u2At(n2 + 6)] - this.structOffset;
                block0 : switch (this.u1At(n5)) {
                    case 3: {
                        char[] cArray2 = this.getTypeName();
                        if (cArray2.length == 1) {
                            switch (cArray2[0]) {
                                case 'Z': {
                                    this.constant = BooleanConstant.fromValue(this.i4At(n5 + 1) == 1);
                                    break block0;
                                }
                                case 'I': {
                                    this.constant = IntConstant.fromValue(this.i4At(n5 + 1));
                                    break block0;
                                }
                                case 'C': {
                                    this.constant = CharConstant.fromValue((char)this.i4At(n5 + 1));
                                    break block0;
                                }
                                case 'B': {
                                    this.constant = ByteConstant.fromValue((byte)this.i4At(n5 + 1));
                                    break block0;
                                }
                                case 'S': {
                                    this.constant = ShortConstant.fromValue((short)this.i4At(n5 + 1));
                                    break block0;
                                }
                            }
                            this.constant = Constant.NotAConstant;
                            break;
                        }
                        this.constant = Constant.NotAConstant;
                        break;
                    }
                    case 4: {
                        this.constant = FloatConstant.fromValue(this.floatAt(n5 + 1));
                        break;
                    }
                    case 6: {
                        this.constant = DoubleConstant.fromValue(this.doubleAt(n5 + 1));
                        break;
                    }
                    case 5: {
                        this.constant = LongConstant.fromValue(this.i8At(n5 + 1));
                        break;
                    }
                    case 8: {
                        n4 = this.constantPoolOffsets[this.u2At(n5 + 1)] - this.structOffset;
                        this.constant = StringConstant.fromValue(String.valueOf(this.utf8At(n4 + 3, this.u2At(n4 + 1))));
                    }
                }
            }
            n2 = (int)((long)n2 + (6L + this.u4At(n2 + 2)));
            ++n3;
        }
        if (!bl) {
            this.constant = Constant.NotAConstant;
        }
    }

    private void readModifierRelatedAttributes() {
        int n = this.u2At(6);
        int n2 = 8;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.constantPoolOffsets[this.u2At(n2)] - this.structOffset;
            char[] cArray = this.utf8At(n4 + 3, this.u2At(n4 + 1));
            if (cArray.length != 0) {
                switch (cArray[0]) {
                    case 'D': {
                        if (!CharOperation.equals(cArray, AttributeNamesConstants.DeprecatedName)) break;
                        this.accessFlags |= 0x100000;
                        break;
                    }
                    case 'S': {
                        if (!CharOperation.equals(cArray, AttributeNamesConstants.SyntheticName)) break;
                        this.accessFlags |= 0x1000;
                    }
                }
            }
            n2 = (int)((long)n2 + (6L + this.u4At(n2 + 2)));
            ++n3;
        }
    }

    public int sizeInBytes() {
        return this.attributeBytes;
    }

    public void throwFormatException() throws ClassFormatException {
        throw new ClassFormatException(17);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        this.toStringContent(stringBuffer);
        return stringBuffer.toString();
    }

    protected void toStringContent(StringBuffer stringBuffer) {
        int n = this.getModifiers();
        stringBuffer.append('{').append(String.valueOf((n & 0x100000) != 0 ? "deprecated " : Util.EMPTY_STRING) + ((n & 1) == 1 ? "public " : Util.EMPTY_STRING) + ((n & 2) == 2 ? "private " : Util.EMPTY_STRING) + ((n & 4) == 4 ? "protected " : Util.EMPTY_STRING) + ((n & 8) == 8 ? "static " : Util.EMPTY_STRING) + ((n & 0x10) == 16 ? "final " : Util.EMPTY_STRING) + ((n & 0x40) == 64 ? "volatile " : Util.EMPTY_STRING) + ((n & 0x80) == 128 ? "transient " : Util.EMPTY_STRING)).append(this.getTypeName()).append(' ').append(this.getName()).append(' ').append(this.getConstant()).append('}').toString();
    }
}

