/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InferenceContext;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.wst.jsdt.internal.infer.InferredType;

public final class ArrayBinding
extends ReferenceBinding {
    public static final FieldBinding ArrayLength = new FieldBinding(TypeConstants.LENGTH, TypeBinding.INT, 17, null, Constant.NotAConstant);
    public TypeBinding leafComponentType;
    public int dimensions;
    LookupEnvironment environment;
    char[] constantPoolName;
    char[] genericTypeSignature;
    ReferenceBinding referenceBinding;

    public ArrayBinding(TypeBinding typeBinding, int n, LookupEnvironment lookupEnvironment) {
        this.tagBits |= 1L;
        this.leafComponentType = typeBinding;
        this.dimensions = n;
        this.environment = lookupEnvironment;
        if (typeBinding instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)typeBinding).addWrapper(this, lookupEnvironment);
        } else {
            this.tagBits |= typeBinding.tagBits & 0x60000000L;
        }
        this.referenceBinding = lookupEnvironment.getType(TypeConstants.ARRAY);
        this.fPackage = lookupEnvironment.defaultPackage;
    }

    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, InferenceContext inferenceContext, int n) {
    }

    public char[] computeUniqueKey(boolean bl) {
        char[] cArray = new char[this.dimensions];
        int n = this.dimensions - 1;
        while (n >= 0) {
            cArray[n] = 91;
            --n;
        }
        return CharOperation.concat(cArray, this.leafComponentType.computeUniqueKey(bl));
    }

    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        char[] cArray = new char[this.dimensions];
        int n = this.dimensions - 1;
        while (n >= 0) {
            cArray[n] = 91;
            --n;
        }
        this.constantPoolName = CharOperation.concat(cArray, this.leafComponentType.signature());
        return this.constantPoolName;
    }

    public String debugName() {
        StringBuffer stringBuffer = new StringBuffer(this.dimensions * 2);
        int n = this.dimensions;
        while (--n >= 0) {
            stringBuffer.append("[]");
        }
        return String.valueOf(this.leafComponentType.debugName()) + stringBuffer.toString();
    }

    public int dimensions() {
        return this.dimensions;
    }

    public TypeBinding elementsType() {
        if (this.dimensions == 1) {
            return this.leafComponentType;
        }
        return this.environment.createArrayType(this.leafComponentType, this.dimensions - 1);
    }

    public TypeBinding erasure() {
        TypeBinding typeBinding = this.leafComponentType.erasure();
        if (this.leafComponentType != typeBinding) {
            return this.environment.createArrayType(typeBinding, this.dimensions);
        }
        return this;
    }

    public LookupEnvironment environment() {
        return this.environment;
    }

    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            char[] cArray = new char[this.dimensions];
            int n = this.dimensions - 1;
            while (n >= 0) {
                cArray[n] = 91;
                --n;
            }
            this.genericTypeSignature = CharOperation.concat(cArray, this.leafComponentType.genericTypeSignature());
        }
        return this.genericTypeSignature;
    }

    public PackageBinding getPackage() {
        return this.leafComponentType.getPackage();
    }

    public int hashCode() {
        return this.leafComponentType == null ? super.hashCode() : this.leafComponentType.hashCode();
    }

    public boolean isCompatibleWith(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 68: {
                ArrayBinding arrayBinding = (ArrayBinding)typeBinding;
                if (arrayBinding.leafComponentType.isBaseType()) {
                    return false;
                }
                if (this.dimensions == arrayBinding.dimensions) {
                    return this.leafComponentType.isCompatibleWith(arrayBinding.leafComponentType);
                }
                if (this.dimensions >= arrayBinding.dimensions) break;
                return false;
            }
            case 132: {
                return false;
            }
            case 516: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
            case 4100: {
                if (typeBinding.isCapture()) {
                    CaptureBinding captureBinding = (CaptureBinding)typeBinding;
                    TypeBinding typeBinding2 = captureBinding.lowerBound;
                    if (typeBinding2 != null) {
                        if (!typeBinding2.isArrayType()) {
                            return false;
                        }
                        return this.isCompatibleWith(typeBinding2);
                    }
                }
                return false;
            }
        }
        switch (typeBinding.leafComponentType().id) {
            case 1: 
            case 36: 
            case 37: {
                return true;
            }
        }
        return false;
    }

    public int kind() {
        return 68;
    }

    public TypeBinding leafComponentType() {
        return this.leafComponentType;
    }

    public int problemId() {
        return this.leafComponentType.problemId();
    }

    public char[] qualifiedSourceName() {
        char[] cArray = new char[this.dimensions * 2];
        int n = this.dimensions * 2 - 1;
        while (n >= 0) {
            cArray[n] = 93;
            cArray[n - 1] = 91;
            n -= 2;
        }
        return CharOperation.concat(this.leafComponentType.qualifiedSourceName(), cArray);
    }

    public char[] readableName() {
        char[] cArray = new char[this.dimensions * 2];
        int n = this.dimensions * 2 - 1;
        while (n >= 0) {
            cArray[n] = 93;
            cArray[n - 1] = 91;
            n -= 2;
        }
        return CharOperation.concat(this.leafComponentType.readableName(), cArray);
    }

    public char[] shortReadableName() {
        char[] cArray = new char[this.dimensions * 2];
        int n = this.dimensions * 2 - 1;
        while (n >= 0) {
            cArray[n] = 93;
            cArray[n - 1] = 91;
            n -= 2;
        }
        return CharOperation.concat(this.leafComponentType.shortReadableName(), cArray);
    }

    public char[] sourceName() {
        char[] cArray = new char[this.dimensions * 2];
        int n = this.dimensions * 2 - 1;
        while (n >= 0) {
            cArray[n] = 93;
            cArray[n - 1] = 91;
            n -= 2;
        }
        return CharOperation.concat(this.leafComponentType.sourceName(), cArray);
    }

    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
        if (this.leafComponentType == unresolvedReferenceBinding) {
            this.leafComponentType = lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
            this.tagBits |= this.leafComponentType.tagBits & 0x60000000L;
        }
    }

    public String toString() {
        return this.leafComponentType != null ? this.debugName() : "NULL TYPE ARRAY";
    }

    public FieldBinding[] availableFields() {
        return this.referenceBinding.availableFields();
    }

    public MethodBinding[] availableMethods() {
        return this.referenceBinding.availableMethods();
    }

    public int fieldCount() {
        return this.referenceBinding.fieldCount();
    }

    public FieldBinding[] fields() {
        return this.referenceBinding.fields();
    }

    public InferredType getInferredType() {
        return this.referenceBinding.getInferredType();
    }

    public MethodBinding[] getMethods(char[] cArray) {
        return this.referenceBinding.getMethods(cArray);
    }

    boolean implementsMethod(MethodBinding methodBinding) {
        return this.referenceBinding.implementsMethod(methodBinding);
    }

    public MethodBinding[] methods() {
        return this.referenceBinding.methods();
    }
}

