/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.parser;

import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredStatement;

public class RecoveredLocalVariable
extends RecoveredStatement {
    public LocalDeclaration localDeclaration;
    boolean alreadyCompletedLocalInitialization;

    public RecoveredLocalVariable(LocalDeclaration localDeclaration, RecoveredElement recoveredElement, int n) {
        super(localDeclaration, recoveredElement, n);
        this.localDeclaration = localDeclaration;
        this.alreadyCompletedLocalInitialization = localDeclaration.initialization != null;
    }

    public RecoveredElement add(Statement statement, int n) {
        if (this.alreadyCompletedLocalInitialization || !(statement instanceof Expression)) {
            return super.add(statement, n);
        }
        this.alreadyCompletedLocalInitialization = true;
        this.localDeclaration.initialization = (Expression)statement;
        this.localDeclaration.declarationSourceEnd = statement.sourceEnd;
        this.localDeclaration.declarationEnd = statement.sourceEnd;
        return this;
    }

    public ASTNode parseTree() {
        return this.localDeclaration;
    }

    public int sourceEnd() {
        return this.localDeclaration.declarationSourceEnd;
    }

    public String toString(int n) {
        return String.valueOf(this.tabString(n)) + "Recovered local variable:\n" + this.localDeclaration.print(n + 1, new StringBuffer(10));
    }

    public Statement updatedStatement() {
        return this.localDeclaration;
    }

    public RecoveredElement updateOnClosingBrace(int n, int n2) {
        if (this.bracketBalance > 0) {
            --this.bracketBalance;
            if (this.bracketBalance == 0) {
                this.alreadyCompletedLocalInitialization = true;
            }
            return this;
        }
        if (this.parent != null) {
            return this.parent.updateOnClosingBrace(n, n2);
        }
        return this;
    }

    public RecoveredElement updateOnOpeningBrace(int n, int n2) {
        if (this.localDeclaration.declarationSourceEnd == 0 && (this.localDeclaration.type instanceof ArrayTypeReference || this.localDeclaration.type instanceof ArrayQualifiedTypeReference) && !this.alreadyCompletedLocalInitialization) {
            ++this.bracketBalance;
            return null;
        }
        this.updateSourceEndIfNecessary(n - 1, n2 - 1);
        return this.parent.updateOnOpeningBrace(n, n2);
    }

    public void updateParseTree() {
        this.updatedStatement();
    }

    public void updateSourceEndIfNecessary(int n, int n2) {
        if (this.localDeclaration.declarationSourceEnd == 0) {
            this.localDeclaration.declarationSourceEnd = n2;
            this.localDeclaration.declarationEnd = n2;
        }
    }

    public ProgramElement updatedASTNode() {
        return this.updatedStatement();
    }
}

