/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.parser;

import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.Block;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredBlock;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredField;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredLocalVariable;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredMethod;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredStatement;

public class RecoveredUnit
extends RecoveredElement {
    public CompilationUnitDeclaration unitDeclaration;
    public RecoveredElement[] statements;
    public int statementCount;

    public RecoveredUnit(CompilationUnitDeclaration compilationUnitDeclaration, int n, Parser parser) {
        super(null, n, parser);
        this.unitDeclaration = compilationUnitDeclaration;
    }

    public RecoveredElement add(AbstractMethodDeclaration abstractMethodDeclaration, int n) {
        RecoveredMethod recoveredMethod = new RecoveredMethod(abstractMethodDeclaration, this, n, this.recoveringParser);
        this.addStatement(recoveredMethod);
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (abstractMethodDeclaration.declarationSourceEnd == 0) {
            return recoveredMethod;
        }
        return this;
    }

    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n) {
        RecoveredField recoveredField = new RecoveredField(fieldDeclaration, this, n);
        this.addStatement(recoveredField);
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (fieldDeclaration.declarationSourceEnd == 0) {
            return recoveredField;
        }
        return this;
    }

    public RecoveredElement add(LocalDeclaration localDeclaration, int n) {
        RecoveredLocalVariable recoveredLocalVariable = new RecoveredLocalVariable(localDeclaration, (RecoveredElement)this, n);
        this.addStatement(recoveredLocalVariable);
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (localDeclaration.declarationSourceEnd == 0) {
            return recoveredLocalVariable;
        }
        return this;
    }

    public RecoveredElement add(ImportReference importReference, int n) {
        return this;
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n) {
        return this;
    }

    private void addStatement(RecoveredElement recoveredElement) {
        if (this.statements == null) {
            this.statements = new RecoveredElement[5];
            this.statementCount = 0;
        } else if (this.statementCount == this.statements.length) {
            this.statements = new RecoveredElement[2 * this.statementCount];
            System.arraycopy(this.statements, 0, this.statements, 0, this.statementCount);
        }
        this.statements[this.statementCount++] = recoveredElement;
    }

    public ASTNode parseTree() {
        return this.unitDeclaration;
    }

    public int sourceEnd() {
        return this.unitDeclaration.sourceEnd;
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n));
        stringBuffer.append("Recovered unit: [\n");
        this.unitDeclaration.print(n + 1, stringBuffer);
        stringBuffer.append(this.tabString(n + 1));
        stringBuffer.append("]");
        if (this.statements != null) {
            int n2 = 0;
            while (n2 < this.statementCount) {
                stringBuffer.append("\n");
                stringBuffer.append(this.statements[n2].toString(n + 1));
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public CompilationUnitDeclaration updatedCompilationUnitDeclaration() {
        int n;
        int n2 = n = this.unitDeclaration.sourceEnd > 0 ? this.unitDeclaration.sourceEnd : this.parser().scanner.eofPosition;
        if (this.statementCount > 0) {
            int n3 = this.unitDeclaration.statements == null ? 0 : this.unitDeclaration.statements.length;
            ProgramElement[] programElementArray = new ProgramElement[n3 + this.statementCount];
            if (n3 > 0) {
                System.arraycopy(this.unitDeclaration.statements, 0, programElementArray, 0, n3);
            }
            ASTNode aSTNode = this.statements[this.statementCount - 1].parseTree();
            if (aSTNode.sourceEnd == 0) {
                aSTNode.sourceEnd = n;
                if (aSTNode instanceof Assignment) {
                    Assignment assignment = (Assignment)aSTNode;
                    if (assignment.expression instanceof FunctionExpression) {
                        FunctionExpression functionExpression = (FunctionExpression)assignment.expression;
                        functionExpression.sourceEnd = aSTNode.sourceEnd;
                        functionExpression.methodDeclaration.bodyEnd = functionExpression.methodDeclaration.sourceEnd = aSTNode.sourceEnd;
                    }
                }
            }
            if (aSTNode instanceof AbstractMethodDeclaration && ((AbstractMethodDeclaration)aSTNode).bodyEnd <= 0) {
                ((AbstractMethodDeclaration)aSTNode).bodyEnd = this.unitDeclaration.sourceEnd;
            }
            int n4 = n3;
            int n5 = 0;
            while (n5 < this.statementCount) {
                ProgramElement programElement = this.statements[n5].updatedASTNode();
                if (programElement != null && programElement.sourceEnd <= 0) {
                    programElement.sourceEnd = this.unitDeclaration.sourceEnd;
                }
                if (programElement instanceof AbstractMethodDeclaration && ((AbstractMethodDeclaration)programElement).bodyEnd <= 0) {
                    ((AbstractMethodDeclaration)programElement).bodyEnd = this.unitDeclaration.sourceEnd;
                }
                programElementArray[n4++] = programElement;
                ++n5;
            }
            this.unitDeclaration.statements = programElementArray;
        } else if (this.unitDeclaration.statements == null) {
            this.unitDeclaration.statements = new ProgramElement[0];
        }
        return this.unitDeclaration;
    }

    public RecoveredElement add(Block block, int n) {
        RecoveredBlock recoveredBlock = new RecoveredBlock(block, (RecoveredElement)this, n);
        if (this.parser().statementRecoveryActivated) {
            this.addBlockStatement(recoveredBlock);
        }
        this.addStatement(recoveredBlock);
        if (block.sourceEnd == 0) {
            return recoveredBlock;
        }
        return this;
    }

    public RecoveredElement add(Statement statement, int n) {
        RecoveredStatement recoveredStatement = new RecoveredStatement(statement, this, n);
        this.addStatement(recoveredStatement);
        if (statement.sourceEnd == 0) {
            return recoveredStatement;
        }
        return this;
    }

    public void updateParseTree() {
        this.updatedCompilationUnitDeclaration();
    }

    public void updateSourceEndIfNecessary(int n, int n2) {
        if (this.unitDeclaration.sourceEnd == 0) {
            this.unitDeclaration.sourceEnd = n2;
        }
    }

    public ProgramElement updatedASTNode() {
        throw new UnimplementedException();
    }

    public void updateFromParserState() {
        if (this.parser().astPtr >= 0) {
            // empty if block
        }
    }
}

