/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryField;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.core.BinaryMember;
import org.eclipse.wst.jsdt.internal.core.BinaryType;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.JavadocConstants;
import org.eclipse.wst.jsdt.internal.core.ResolvedBinaryField;

class BinaryField
extends BinaryMember
implements IField {
    protected BinaryField(JavaElement javaElement, String string) {
        super(javaElement, string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BinaryField)) {
            return false;
        }
        return super.equals(object);
    }

    public Object getConstant() throws JavaModelException {
        IBinaryField iBinaryField = (IBinaryField)this.getElementInfo();
        return BinaryField.convertConstant(iBinaryField.getConstant());
    }

    public int getFlags() throws JavaModelException {
        IBinaryField iBinaryField = (IBinaryField)this.getElementInfo();
        return iBinaryField.getModifiers();
    }

    public int getElementType() {
        return 8;
    }

    protected char getHandleMementoDelimiter() {
        return '^';
    }

    public String getKey(boolean bl) throws JavaModelException {
        return this.getKey(this, bl);
    }

    public String getTypeSignature() throws JavaModelException {
        IBinaryField iBinaryField = (IBinaryField)this.getElementInfo();
        return new String(ClassFile.translatedName(iBinaryField.getTypeName()));
    }

    public boolean isEnumConstant() throws JavaModelException {
        return Flags.isEnum(this.getFlags());
    }

    public boolean isResolved() {
        return false;
    }

    public JavaElement resolved(Binding binding) {
        ResolvedBinaryField resolvedBinaryField = new ResolvedBinaryField(this.parent, this.name, new String(binding.computeUniqueKey()));
        resolvedBinaryField.occurrenceCount = this.occurrenceCount;
        return resolvedBinaryField;
    }

    protected void toStringInfo(int n, StringBuffer stringBuffer, Object object, boolean bl) {
        stringBuffer.append(this.tabString(n));
        if (object == null) {
            this.toStringName(stringBuffer);
            stringBuffer.append(" (not open)");
        } else if (object == NO_INFO) {
            this.toStringName(stringBuffer);
        } else {
            try {
                stringBuffer.append(Signature.toString(this.getTypeSignature()));
                stringBuffer.append(" ");
                this.toStringName(stringBuffer);
            }
            catch (JavaModelException javaModelException) {
                stringBuffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }

    public String getAttachedJavadoc(IProgressMonitor iProgressMonitor) throws JavaModelException {
        String string = ((BinaryType)this.getDeclaringType()).getJavadocContents(iProgressMonitor);
        if (string == null) {
            return null;
        }
        int n = string.indexOf("<A NAME=\"" + this.getElementName() + "\"");
        if (n == -1) {
            throw new JavaModelException(new JavaModelStatus(1009, this));
        }
        int n2 = string.indexOf("</A>", n);
        if (n2 == -1) {
            throw new JavaModelException(new JavaModelStatus(1009, this));
        }
        int n3 = string.indexOf("<A NAME=\"", n2);
        int n4 = string.indexOf("<!-- ========= CONSTRUCTOR DETAIL ======== -->", n2);
        if (n4 == -1 && (n4 = string.indexOf("<!-- ============ METHOD DETAIL ========== -->", n2)) == -1) {
            n4 = string.indexOf("<!-- ========= END OF CLASS DATA ========= -->", n2);
        }
        if ((n3 = Math.min(n3, n4)) == -1) {
            throw new JavaModelException(new JavaModelStatus(1009, this));
        }
        return string.substring(n2 + JavadocConstants.ANCHOR_SUFFIX_LENGTH, n3);
    }
}

