/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IClasspathAttribute;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.XMLWriter;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UserLibrary {
    private static final String CURRENT_VERSION = "1";
    private static final String TAG_VERSION = "version";
    private static final String TAG_USERLIBRARY = "userlibrary";
    private static final String TAG_SOURCEATTACHMENT = "sourceattachment";
    private static final String TAG_SOURCEATTACHMENTROOT = "sourceattachmentroot";
    private static final String TAG_PATH = "path";
    private static final String TAG_ARCHIVE = "archive";
    private static final String TAG_SYSTEMLIBRARY = "systemlibrary";
    private boolean isSystemLibrary;
    private IClasspathEntry[] entries;

    public UserLibrary(IClasspathEntry[] iClasspathEntryArray, boolean bl) {
        Assert.isNotNull((Object)iClasspathEntryArray);
        this.entries = iClasspathEntryArray;
        this.isSystemLibrary = bl;
    }

    public IClasspathEntry[] getEntries() {
        return this.entries;
    }

    public boolean isSystemLibrary() {
        return this.isSystemLibrary;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            UserLibrary userLibrary = (UserLibrary)object;
            if (this.entries.length == userLibrary.entries.length && this.isSystemLibrary == userLibrary.isSystemLibrary) {
                int n = 0;
                while (n < this.entries.length) {
                    if (!this.entries[n].equals(userLibrary.entries[n])) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        if (this.isSystemLibrary) {
            ++n;
        }
        int n2 = 0;
        while (n2 < this.entries.length) {
            n = n * 17 + this.entries.hashCode();
            ++n2;
        }
        return n;
    }

    String serialize() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
        XMLWriter xMLWriter = new XMLWriter((Writer)outputStreamWriter, null, true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(TAG_VERSION, String.valueOf(CURRENT_VERSION));
        hashMap.put(TAG_SYSTEMLIBRARY, String.valueOf(this.isSystemLibrary));
        xMLWriter.printTag(TAG_USERLIBRARY, hashMap, true, true, false);
        int n = 0;
        while (n < this.entries.length) {
            IPath iPath;
            ClasspathEntry classpathEntry = (ClasspathEntry)this.entries[n];
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put(TAG_PATH, classpathEntry.getPath().toString());
            IPath iPath2 = classpathEntry.getSourceAttachmentPath();
            if (iPath2 != null) {
                hashMap2.put(TAG_SOURCEATTACHMENT, (String)iPath2);
            }
            if ((iPath = classpathEntry.getSourceAttachmentRootPath()) != null) {
                hashMap2.put(TAG_SOURCEATTACHMENTROOT, (String)iPath);
            }
            boolean bl = classpathEntry.extraAttributes != null && classpathEntry.extraAttributes.length != 0;
            boolean bl2 = classpathEntry.getAccessRuleSet() != null;
            xMLWriter.printTag(TAG_ARCHIVE, hashMap2, true, true, !bl && !bl2);
            if (bl) {
                classpathEntry.encodeExtraAttributes(xMLWriter, true, true);
            }
            if (bl2) {
                classpathEntry.encodeAccessRules(xMLWriter, true, true);
            }
            if (bl || bl2) {
                xMLWriter.endTag(TAG_ARCHIVE, true, true);
            }
            ++n;
        }
        xMLWriter.endTag(TAG_USERLIBRARY, true, true);
        outputStreamWriter.flush();
        outputStreamWriter.close();
        return byteArrayOutputStream.toString("UTF8");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static UserLibrary createFromString(Reader reader) throws IOException {
        NodeList nodeList;
        Element element;
        try {
            try {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                element = documentBuilder.parse(new InputSource(reader)).getDocumentElement();
            }
            catch (SAXException sAXException) {
                throw new IOException(Messages.file_badFormat);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new IOException(Messages.file_badFormat);
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            reader.close();
            throw throwable;
        }
        {
            nodeList = null;
        }
        reader.close();
        if (!element.getNodeName().equalsIgnoreCase(TAG_USERLIBRARY)) {
            throw new IOException(Messages.file_badFormat);
        }
        boolean bl = Boolean.valueOf(element.getAttribute(TAG_SYSTEMLIBRARY));
        nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>(n);
        int n2 = 0;
        while (true) {
            Element element2;
            if (n2 >= n) {
                IClasspathEntry[] iClasspathEntryArray = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
                return new UserLibrary(iClasspathEntryArray, bl);
            }
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1 && (element2 = (Element)node).getNodeName().equals(TAG_ARCHIVE)) {
                String string = element2.getAttribute(TAG_PATH);
                Path path = element2.hasAttribute(TAG_SOURCEATTACHMENT) ? new Path(element2.getAttribute(TAG_SOURCEATTACHMENT)) : null;
                Path path2 = element2.hasAttribute(TAG_SOURCEATTACHMENTROOT) ? new Path(element2.getAttribute(TAG_SOURCEATTACHMENTROOT)) : null;
                NodeList nodeList2 = element2.getElementsByTagName("*");
                boolean[] blArray = new boolean[nodeList2.getLength()];
                NodeList nodeList3 = ClasspathEntry.getChildAttributes("attributes", nodeList2, blArray);
                IClasspathAttribute[] iClasspathAttributeArray = ClasspathEntry.decodeExtraAttributes(nodeList3);
                nodeList3 = ClasspathEntry.getChildAttributes("accessrules", nodeList2, blArray);
                IAccessRule[] iAccessRuleArray = ClasspathEntry.decodeAccessRules(nodeList3);
                IClasspathEntry iClasspathEntry = JavaCore.newLibraryEntry((IPath)new Path(string), (IPath)path, (IPath)path2, iAccessRuleArray, iClasspathAttributeArray, false);
                arrayList.add(iClasspathEntry);
            }
            ++n2;
        }
    }

    public String toString() {
        if (this.entries == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(String.valueOf(this.entries[n2].toString()) + '\n');
            ++n2;
        }
        return stringBuffer.toString();
    }
}

