/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.dom.rewrite;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.RewriteEventStore;

public final class NodeInfoStore {
    private AST ast;
    private Map placeholderNodes;
    private Set collapsedNodes;

    public NodeInfoStore(AST aST) {
        this.ast = aST;
        this.placeholderNodes = null;
        this.collapsedNodes = null;
    }

    public final void markAsStringPlaceholder(ASTNode aSTNode, String string) {
        StringPlaceholderData stringPlaceholderData = new StringPlaceholderData();
        stringPlaceholderData.code = string;
        this.setPlaceholderData(aSTNode, stringPlaceholderData);
    }

    public final void markAsCopyTarget(ASTNode aSTNode, RewriteEventStore.CopySourceInfo copySourceInfo) {
        CopyPlaceholderData copyPlaceholderData = new CopyPlaceholderData();
        copyPlaceholderData.copySource = copySourceInfo;
        this.setPlaceholderData(aSTNode, copyPlaceholderData);
    }

    public final ASTNode newPlaceholderNode(int n) {
        try {
            ASTNode aSTNode = this.ast.createInstance(n);
            switch (aSTNode.getNodeType()) {
                case 23: {
                    ((FieldDeclaration)aSTNode).fragments().add(this.ast.newVariableDeclarationFragment());
                    break;
                }
                case 100: {
                    ((Modifier)aSTNode).setKeyword(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
                    break;
                }
                case 54: {
                    ((TryStatement)aSTNode).setFinally(this.ast.newBlock());
                    break;
                }
                case 58: {
                    ((VariableDeclarationExpression)aSTNode).fragments().add(this.ast.newVariableDeclarationFragment());
                    break;
                }
                case 60: {
                    ((VariableDeclarationStatement)aSTNode).fragments().add(this.ast.newVariableDeclarationFragment());
                    break;
                }
                case 74: {
                    ((ParameterizedType)aSTNode).typeArguments().add(this.ast.newWildcardType());
                }
            }
            return aSTNode;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public Block createCollapsePlaceholder() {
        Block block = this.ast.newBlock();
        if (this.collapsedNodes == null) {
            this.collapsedNodes = new HashSet();
        }
        this.collapsedNodes.add(block);
        return block;
    }

    public boolean isCollapsed(ASTNode aSTNode) {
        if (this.collapsedNodes != null) {
            return this.collapsedNodes.contains(aSTNode);
        }
        return false;
    }

    public Object getPlaceholderData(ASTNode aSTNode) {
        if (this.placeholderNodes != null) {
            return this.placeholderNodes.get(aSTNode);
        }
        return null;
    }

    private void setPlaceholderData(ASTNode aSTNode, PlaceholderData placeholderData) {
        if (this.placeholderNodes == null) {
            this.placeholderNodes = new IdentityHashMap();
        }
        this.placeholderNodes.put(aSTNode, placeholderData);
    }

    public void clear() {
        this.placeholderNodes = null;
        this.collapsedNodes = null;
    }

    protected static final class CopyPlaceholderData
    extends PlaceholderData {
        public RewriteEventStore.CopySourceInfo copySource;

        protected CopyPlaceholderData() {
        }

        public String toString() {
            return "[placeholder " + this.copySource + "]";
        }
    }

    static class PlaceholderData {
        PlaceholderData() {
        }
    }

    protected static final class StringPlaceholderData
    extends PlaceholderData {
        public String code;

        protected StringPlaceholderData() {
        }

        public String toString() {
            return "[placeholder string: " + this.code + "]";
        }
    }
}

