/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.hierarchy;

import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryField;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;

public class HierarchyBinaryType
implements IBinaryType {
    private int modifiers;
    private char[] sourceName;
    private char[] name;
    private char[] enclosingTypeName;
    private char[] superclass;
    private char[][] superInterfaces = NoInterface;
    private char[][] typeParameterSignatures;
    private char[] genericSignature;

    public HierarchyBinaryType(int n, char[] cArray, char[] cArray2, char[] cArray3, char[][] cArray4, char c) {
        this.modifiers = n;
        this.sourceName = cArray2;
        if (cArray3 == null) {
            this.name = CharOperation.concat(cArray, cArray2, '/');
        } else {
            this.name = CharOperation.concat(cArray, '/', cArray3, '$', cArray2);
            this.enclosingTypeName = CharOperation.concat(cArray, cArray3, '/');
            CharOperation.replace(this.enclosingTypeName, '.', '/');
        }
        this.typeParameterSignatures = cArray4;
        CharOperation.replace(this.name, '.', '/');
    }

    public char[] getEnclosingTypeName() {
        return this.enclosingTypeName;
    }

    public IBinaryField[] getFields() {
        return null;
    }

    public char[] getFileName() {
        return null;
    }

    public char[] getGenericSignature() {
        if (this.typeParameterSignatures != null && this.genericSignature == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('<');
            int n = 0;
            int n2 = this.typeParameterSignatures.length;
            while (n < n2) {
                stringBuffer.append(this.typeParameterSignatures[n]);
                ++n;
            }
            stringBuffer.append('>');
            if (this.superclass == null) {
                stringBuffer.append(Signature.createTypeSignature("java.lang.Object", true));
            } else {
                stringBuffer.append(Signature.createTypeSignature(this.superclass, true));
            }
            if (this.superInterfaces != null) {
                n = 0;
                n2 = this.superInterfaces.length;
                while (n < n2) {
                    stringBuffer.append(Signature.createTypeSignature(this.superInterfaces[n], true));
                    ++n;
                }
            }
            this.genericSignature = stringBuffer.toString().toCharArray();
            CharOperation.replace(this.genericSignature, '.', '/');
        }
        return this.genericSignature;
    }

    public char[][] getInterfaceNames() {
        return this.superInterfaces;
    }

    public IBinaryNestedType[] getMemberTypes() {
        return null;
    }

    public IBinaryMethod[] getMethods() {
        return null;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public char[] getName() {
        return this.name;
    }

    public char[] getSourceName() {
        return this.sourceName;
    }

    public char[] getSuperclassName() {
        return this.superclass;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isBinaryType() {
        return true;
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isMember() {
        return false;
    }

    public void recordSuperType(char[] cArray, char[] cArray2, char c) {
        int n;
        if (cArray2 != null && cArray2[(n = cArray2.length) - 1] == '$') {
            char[] cArray3 = CharOperation.lastSegment(cArray2, '.');
            cArray = CharOperation.concat(cArray3, cArray);
            cArray2 = CharOperation.subarray(cArray2, 0, n - cArray3.length - 1);
        }
        if (c == 'C') {
            if (TypeDeclaration.kind(this.modifiers) == 2) {
                return;
            }
            char[] cArray4 = CharOperation.concat(cArray2, cArray, '/');
            CharOperation.replace(cArray4, '.', '/');
            this.superclass = cArray4;
        } else {
            char[] cArray5 = CharOperation.concat(cArray2, cArray, '/');
            CharOperation.replace(cArray5, '.', '/');
            if (this.superInterfaces == NoInterface) {
                this.superInterfaces = new char[][]{cArray5};
            } else {
                int n2 = this.superInterfaces.length;
                char[][] cArrayArray = new char[n2 + 1][];
                this.superInterfaces = cArrayArray;
                System.arraycopy(this.superInterfaces, 0, cArrayArray, 0, n2);
                this.superInterfaces[n2] = cArray5;
            }
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.modifiers == 1) {
            stringBuffer.append("public ");
        }
        switch (TypeDeclaration.kind(this.modifiers)) {
            case 1: {
                stringBuffer.append("class ");
                break;
            }
            case 2: {
                stringBuffer.append("interface ");
                break;
            }
            case 3: {
                stringBuffer.append("enum ");
            }
        }
        if (this.name != null) {
            stringBuffer.append(this.name);
        }
        if (this.superclass != null) {
            stringBuffer.append("\n  extends ");
            stringBuffer.append(this.superclass);
        }
        if (this.superInterfaces != null && (n = this.superInterfaces.length) != 0) {
            stringBuffer.append("\n implements ");
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(this.superInterfaces[n2]);
                if (n2 != n - 1) {
                    stringBuffer.append(", ");
                }
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public IBinaryAnnotation[] getAnnotations() {
        return null;
    }

    public char[] sourceFileName() {
        return null;
    }

    public long getTagBits() {
        return 0L;
    }
}

