/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.hierarchy;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IRegion;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.Region;
import org.eclipse.wst.jsdt.internal.core.TypeVector;
import org.eclipse.wst.jsdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.wst.jsdt.internal.core.hierarchy.RegionBasedHierarchyBuilder;
import org.eclipse.wst.jsdt.internal.core.hierarchy.TypeHierarchy;

public class RegionBasedTypeHierarchy
extends TypeHierarchy {
    protected IRegion region;

    public RegionBasedTypeHierarchy(IRegion iRegion, ICompilationUnit[] iCompilationUnitArray, IType iType, boolean bl) {
        super(iType, iCompilationUnitArray, (IJavaSearchScope)null, bl);
        Region region = new Region(){

            public void add(IJavaElement iJavaElement) {
                if (!this.contains(iJavaElement)) {
                    this.removeAllChildren(iJavaElement);
                    this.fRootElements.add(iJavaElement);
                    if (iJavaElement.getElementType() == 2) {
                        try {
                            IPackageFragmentRoot[] iPackageFragmentRootArray = ((IJavaProject)iJavaElement).getPackageFragmentRoots();
                            int n = 0;
                            int n2 = iPackageFragmentRootArray.length;
                            while (n < n2) {
                                if (iPackageFragmentRootArray[n].isArchive() && !this.fRootElements.contains(iPackageFragmentRootArray[n])) {
                                    this.fRootElements.add(iPackageFragmentRootArray[n]);
                                }
                                ++n;
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                    }
                    this.fRootElements.trimToSize();
                }
            }
        };
        IJavaElement[] iJavaElementArray = iRegion.getElements();
        int n = 0;
        int n2 = iJavaElementArray.length;
        while (n < n2) {
            region.add(iJavaElementArray[n]);
            ++n;
        }
        this.region = region;
        if (iJavaElementArray.length > 0) {
            this.project = iJavaElementArray[0].getJavaProject();
        }
    }

    protected void initializeRegions() {
        super.initializeRegions();
        IJavaElement[] iJavaElementArray = this.region.getElements();
        int n = 0;
        while (n < iJavaElementArray.length) {
            IJavaElement iJavaElement = iJavaElementArray[n];
            if (iJavaElement instanceof IOpenable) {
                this.files.put(iJavaElement, new ArrayList());
            } else {
                Openable openable = (Openable)((JavaElement)iJavaElement).getOpenableParent();
                if (openable != null) {
                    this.files.put(openable, new ArrayList());
                }
            }
            this.checkCanceled();
            ++n;
        }
    }

    protected void compute() throws JavaModelException, CoreException {
        RegionBasedHierarchyBuilder regionBasedHierarchyBuilder = new RegionBasedHierarchyBuilder(this);
        ((HierarchyBuilder)regionBasedHierarchyBuilder).build(this.computeSubtypes);
    }

    protected boolean isAffectedByOpenable(IJavaElementDelta iJavaElementDelta, IJavaElement iJavaElement) {
        if (iJavaElement instanceof CompilationUnit && ((CompilationUnit)iJavaElement).isWorkingCopy()) {
            return super.isAffectedByOpenable(iJavaElementDelta, iJavaElement);
        }
        if (this.focusType == null) {
            return this.region.contains(iJavaElement);
        }
        return super.isAffectedByOpenable(iJavaElementDelta, iJavaElement);
    }

    public IJavaProject javaProject() {
        return this.project;
    }

    public void pruneDeadBranches() {
        this.pruneDeadBranches(this.getRootClasses());
        this.pruneDeadBranches(this.getRootInterfaces());
    }

    private boolean pruneDeadBranches(IType iType) {
        TypeVector typeVector = (TypeVector)this.typeToSubtypes.get(iType);
        if (typeVector == null) {
            return true;
        }
        this.pruneDeadBranches(typeVector.copy().elements());
        typeVector = (TypeVector)this.typeToSubtypes.get(iType);
        return typeVector == null || typeVector.size == 0;
    }

    private void pruneDeadBranches(IType[] iTypeArray) {
        int n = 0;
        int n2 = iTypeArray.length;
        while (n < n2) {
            IType iType = iTypeArray[n];
            if (this.pruneDeadBranches(iType) && !this.region.contains(iType)) {
                this.removeType(iType);
            }
            ++n;
        }
    }

    protected void removeType(IType iType) {
        IType[] iTypeArray;
        IType iType2;
        IType[] iTypeArray2 = this.getSubtypes(iType);
        this.typeToSubtypes.remove(iType);
        if (iTypeArray2 != null) {
            int n = 0;
            while (n < iTypeArray2.length) {
                this.removeType(iTypeArray2[n]);
                ++n;
            }
        }
        if ((iType2 = (IType)this.classToSuperclass.remove(iType)) != null && (iTypeArray = (IType[])this.typeToSubtypes.get(iType2)) != null) {
            iTypeArray.remove(iType);
        }
        if ((iTypeArray = (IType[])this.typeToSuperInterfaces.remove(iType)) != null) {
            int n = 0;
            int n2 = iTypeArray.length;
            while (n < n2) {
                IType iType3 = iTypeArray[n];
                TypeVector typeVector = (TypeVector)this.typeToSubtypes.get(iType3);
                if (typeVector != null) {
                    typeVector.remove(iType);
                }
                ++n;
            }
        }
        this.interfaces.remove(iType);
    }
}

